/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc;

import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class ConnectionContext {
    private static final L10N L = new L10N(ConnectionContext.class);
    private static final Logger log = Log.open(ConnectionContext.class);
    private static InitialContext _initialContext;
    private static ThreadLocal<HashMap<String, ConnectionContext>> _localConn;
    private int _depth;
    private Connection _conn;

    public static void begin(String jndiName) {
        ConnectionContext cxt;
        HashMap<String, ConnectionContext> map = _localConn.get();
        if (map == null) {
            map = new HashMap(8);
            _localConn.set(map);
        }
        if ((cxt = map.get(jndiName)) == null) {
            cxt = new ConnectionContext();
            map.put(jndiName, cxt);
        }
        ++cxt._depth;
    }

    public static Connection getConnection(String jndiName) throws SQLException {
        HashMap<String, ConnectionContext> map = _localConn.get();
        if (map == null) {
            throw new IllegalStateException(L.l("'{0}' is not an available connection.", jndiName));
        }
        ConnectionContext cxt = map.get(jndiName);
        if (cxt == null || cxt._depth == 0) {
            throw new IllegalStateException(L.l("'{0}' is not an available connection.", jndiName));
        }
        if (cxt._conn == null) {
            try {
                DataSource ds = (DataSource)_initialContext.lookup(jndiName);
                cxt._conn = ds.getConnection();
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    public static void end(String jdbcName) {
        HashMap<String, ConnectionContext> map = _localConn.get();
        if (map == null) {
            return;
        }
        ConnectionContext cxt = map.get(jdbcName);
        if (cxt == null) {
            return;
        }
        if (--cxt._depth == 0) {
            Connection conn = cxt._conn;
            try {
                cxt._conn = null;
                conn.close();
            }
            catch (SQLException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    private static Context getInitialContext() {
        if (_initialContext == null) {
            try {
                _initialContext = new InitialContext();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return _initialContext;
    }

    static {
        _localConn = new ThreadLocal();
    }
}

