/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc;

import com.caucho.jdbc.DerbyMetaData;
import com.caucho.jdbc.GenericMetaData;
import com.caucho.jdbc.MysqlMetaData;
import com.caucho.jdbc.OracleMetaData;
import com.caucho.jdbc.PostgresMetaData;
import com.caucho.jdbc.ResinMetaData;
import com.caucho.jdbc.SqlServerMetaData;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public abstract class JdbcMetaData {
    private static final L10N L = new L10N(JdbcMetaData.class);
    private static final Logger log = Log.open(JdbcMetaData.class);
    private DataSource _ds;

    protected JdbcMetaData(DataSource ds) {
        this._ds = ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JdbcMetaData create(DataSource ds) {
        Connection conn = null;
        try {
            conn = ds.getConnection();
            DatabaseMetaData md = conn.getMetaData();
            String name = md.getDatabaseProductName();
            log.fine(L.l("Database '{0}' metadata.", name));
            if ("oracle".equalsIgnoreCase(name)) {
                OracleMetaData oracleMetaData = new OracleMetaData(ds);
                return oracleMetaData;
            }
            if ("resin".equalsIgnoreCase(name)) {
                ResinMetaData resinMetaData = new ResinMetaData(ds);
                return resinMetaData;
            }
            if ("postgres".equalsIgnoreCase(name) || "PostgreSQL".equalsIgnoreCase(name)) {
                PostgresMetaData postgresMetaData = new PostgresMetaData(ds);
                return postgresMetaData;
            }
            if ("mysql".equalsIgnoreCase(name)) {
                MysqlMetaData mysqlMetaData = new MysqlMetaData(ds);
                return mysqlMetaData;
            }
            if ("Microsoft SQL Server".equalsIgnoreCase(name)) {
                SqlServerMetaData sqlServerMetaData = new SqlServerMetaData(ds);
                return sqlServerMetaData;
            }
            if ("Apache Derby".equalsIgnoreCase(name)) {
                DerbyMetaData derbyMetaData = new DerbyMetaData(ds);
                return derbyMetaData;
            }
            log.fine(name + " is an unknown database type, using generic sql");
            GenericMetaData genericMetaData = new GenericMetaData(ds);
            return genericMetaData;
        }
        catch (SQLException e) {
            log.log(Level.FINE, e.toString(), e);
            GenericMetaData genericMetaData = new GenericMetaData(ds);
            return genericMetaData;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatabaseName() {
        Connection conn = null;
        try {
            conn = this.getConnection();
            DatabaseMetaData md = conn.getMetaData();
            String string = md.getDatabaseProductName();
            return string;
        }
        catch (SQLException e) {
            log.log(Level.WARNING, e.toString(), e);
            String string = "unknown";
            return string;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    public abstract String getBlobType();

    public boolean isTruncateBlobBeforeDelete() {
        return false;
    }

    public abstract boolean supportsGetGeneratedKeys();

    public abstract String getFalseLiteral();

    public abstract boolean supportsPositionFunction();

    public abstract boolean supportsUpdateTableAlias();

    public abstract boolean supportsUpdateTableList();

    public boolean isForeignKeyViolationSQLState(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        return sqlState.equals("23503");
    }

    public boolean isUniqueConstraintSQLState(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        return sqlState.equals("23000") || sqlState.equals("23505");
    }

    public abstract String getLongType();

    public abstract boolean supportsIdentity();

    public abstract String createIdentitySQL(String var1);

    public abstract boolean supportsSequences();

    public abstract String createSequenceSQL(String var1, int var2);

    public abstract String selectSequenceSQL(String var1);

    public String testSequenceSQL(String name) {
        return this.selectSequenceSQL(name) + " WHERE 1=0";
    }

    public String generateBoolean(String term) {
        return term;
    }

    public boolean isLimit() {
        return false;
    }

    public boolean isLimitOffset() {
        return false;
    }

    public String limit(String sql, int firstResults, int maxResults) {
        return sql;
    }

    public abstract String getCreateColumnSQL(int var1, int var2, int var3, int var4);

    protected Connection getConnection() throws SQLException {
        return this._ds.getConnection();
    }
}

