/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jdbc;

import com.caucho.config.ConfigException;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.jms.jdbc.JdbcManager;
import com.caucho.jms.jdbc.JdbcMessage;
import com.caucho.jms.queue.AbstractDestination;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;

public abstract class JdbcDestination
extends AbstractDestination {
    static final Logger log = Logger.getLogger(JdbcDestination.class.getName());
    static final L10N L = new L10N(JdbcDestination.class);
    protected JdbcManager _jdbcManager = new JdbcManager();
    private String _name;
    private long _lastPurgeTime;

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public boolean isTopic() {
        return false;
    }

    public void setJdbcManager(JdbcManager jdbcManager) {
        this._jdbcManager = jdbcManager;
    }

    public JdbcManager getJdbcManager() {
        return this._jdbcManager;
    }

    public void setDataSource(DataSource dataSource) {
        this._jdbcManager.setDataSource(dataSource);
    }

    public void setTablespace(String tablespace) {
        this._jdbcManager.setTablespace(tablespace);
    }

    @PostConstruct
    public void init() throws ConfigException, SQLException {
        this._jdbcManager.init();
    }

    protected int createDestination(String name, boolean isTopic) throws SQLException {
        block12: {
            ResultSet rs;
            PreparedStatement pstmt;
            String sql;
            String destinationTable;
            Connection conn;
            block11: {
                String destinationSequence;
                block10: {
                    int n;
                    conn = this._jdbcManager.getDataSource().getConnection();
                    destinationTable = this._jdbcManager.getDestinationTable();
                    destinationSequence = this._jdbcManager.getDestinationSequence();
                    try {
                        sql = "SELECT id FROM " + destinationTable + " WHERE name=? AND is_topic=?";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, name);
                        pstmt.setInt(2, isTopic ? 1 : 0);
                        rs = pstmt.executeQuery();
                        if (!rs.next()) break block10;
                        n = rs.getInt(1);
                        Object var13_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_15 = null;
                        conn.close();
                        throw throwable;
                    }
                    conn.close();
                    return n;
                }
                rs.close();
                if (destinationSequence == null) break block11;
                JdbcMetaData metaData = this._jdbcManager.getMetaData();
                sql = metaData.selectSequenceSQL(destinationSequence);
                int id = 0;
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (!rs.next()) {
                    throw new RuntimeException("can't create sequence");
                }
                id = rs.getInt(1);
                sql = "INSERT INTO " + destinationTable + " (id,name,is_topic) VALUES(?,?,?)";
                pstmt = conn.prepareStatement(sql);
                pstmt.setInt(1, id);
                pstmt.setString(2, name);
                pstmt.setInt(3, isTopic ? 1 : 0);
                pstmt.executeUpdate();
                if (isTopic) {
                    log.fine("JMSTopic[" + name + "," + id + "] created");
                } else {
                    log.fine("JMSQueue[" + name + "," + id + "] created");
                }
                int n = id;
                Object var13_13 = null;
                conn.close();
                return n;
            }
            sql = "INSERT INTO " + destinationTable + " (name,is_topic) VALUES(?,?)";
            pstmt = conn.prepareStatement(sql, 1);
            pstmt.setString(1, name);
            pstmt.setInt(2, isTopic ? 1 : 0);
            pstmt.executeUpdate();
            rs = pstmt.getGeneratedKeys();
            if (!rs.next()) break block12;
            int id = rs.getInt(1);
            if (isTopic) {
                log.fine("JMSTopic[" + name + "," + id + "] created");
            } else {
                log.fine("JMSQueue[" + name + "," + id + "] created");
            }
            int n = id;
            Object var13_14 = null;
            conn.close();
            return n;
        }
        throw new SQLException(L.l("can't generate destination for {0}", name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeExpiredMessages() {
        long purgeInterval = this._jdbcManager.getPurgeInterval();
        long now = Alarm.getCurrentTime();
        if (now < this._lastPurgeTime + purgeInterval) {
            return;
        }
        this._lastPurgeTime = now;
        try {
            DataSource dataSource = this._jdbcManager.getDataSource();
            String messageTable = this._jdbcManager.getMessageTable();
            JdbcMessage jdbcMessage = this._jdbcManager.getJdbcMessage();
            Connection conn = dataSource.getConnection();
            try {
                String sql = "DELETE FROM " + messageTable + " WHERE expire < ? AND consumer IS NULL";
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, Alarm.getCurrentTime());
                int count = pstmt.executeUpdate();
                if (count > 0) {
                    log.fine("JMSQueue[" + this.getName() + "] purged " + count + " expired mesages");
                }
                pstmt.close();
                Object var13_11 = null;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                conn.close();
                throw throwable;
            }
            conn.close();
            {
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }
}

