/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.message;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.message.MessageType;
import com.caucho.jms.message.ObjectConverter;
import com.caucho.vfs.StreamImplOutputStream;
import com.caucho.vfs.TempStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.StreamMessage;

public class StreamMessageImpl
extends MessageImpl
implements StreamMessage {
    private ArrayList<Object> _values = new ArrayList();
    private int _index;
    private byte[] _bytes;
    private int _bytesOffset;

    public StreamMessageImpl() {
    }

    StreamMessageImpl(StreamMessage stream) throws JMSException {
        super((Message)stream);
        try {
            stream.reset();
            while (true) {
                this.writeObject(stream.readObject());
            }
        }
        catch (MessageEOFException messageEOFException) {
            this.reset();
            return;
        }
    }

    StreamMessageImpl(StreamMessageImpl stream) {
        super(stream);
        this._values.addAll(stream._values);
        try {
            this.reset();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MessageType getType() {
        return MessageType.STREAM;
    }

    public void setReceive() throws JMSException {
        super.setReceive();
        this.reset();
    }

    public void reset() throws JMSException {
        this.setBodyReadOnly();
        this._index = 0;
        this._bytes = null;
        this._bytesOffset = 0;
    }

    public boolean readBoolean() throws JMSException {
        boolean value = ObjectConverter.toBoolean(this.readObjectImpl());
        ++this._index;
        return value;
    }

    public byte readByte() throws JMSException {
        byte value = ObjectConverter.toByte(this.readObjectImpl());
        ++this._index;
        return value;
    }

    public short readShort() throws JMSException {
        short value = ObjectConverter.toShort(this.readObjectImpl());
        ++this._index;
        return value;
    }

    public int readInt() throws JMSException {
        int value = ObjectConverter.toInt(this.readObjectImpl());
        ++this._index;
        return value;
    }

    public long readLong() throws JMSException {
        long value = ObjectConverter.toLong(this.readObjectImpl());
        ++this._index;
        return value;
    }

    public float readFloat() throws JMSException {
        float value = ObjectConverter.toFloat(this.readObjectImpl());
        ++this._index;
        return value;
    }

    public double readDouble() throws JMSException {
        double value = ObjectConverter.toDouble(this.readObjectImpl());
        ++this._index;
        return value;
    }

    public char readChar() throws JMSException {
        char value = ObjectConverter.toChar(this.readObjectImpl());
        ++this._index;
        return value;
    }

    public String readString() throws JMSException {
        String value = ObjectConverter.toString(this.readObjectImpl());
        ++this._index;
        return value;
    }

    public int readBytes(byte[] value) throws JMSException {
        if (this._bytes != null) {
            if (this._bytesOffset == this._bytes.length) {
                this._bytes = null;
                this._bytesOffset = 0;
                return -1;
            }
        } else {
            this._bytes = ObjectConverter.toBytes(this.readObjectImpl());
            ++this._index;
        }
        if (this._bytes == null) {
            return -1;
        }
        int sublen = this._bytes.length - this._bytesOffset;
        if (value.length < sublen) {
            sublen = value.length;
        }
        for (int i = 0; i < sublen; ++i) {
            value[i] = this._bytes[this._bytesOffset++];
        }
        return sublen;
    }

    public Object readObject() throws JMSException {
        Object value = this.readObjectImpl();
        ++this._index;
        return value;
    }

    private Object readObjectImpl() throws JMSException {
        this.checkBodyReadable();
        if (this._values.size() <= this._index) {
            throw new MessageEOFException(L.l("end of message in stream"));
        }
        this._bytes = null;
        this._bytesOffset = 0;
        return this._values.get(this._index);
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this._values.clear();
        this._index = 0;
        this._bytes = null;
        this._bytesOffset = 0;
    }

    public void writeBoolean(boolean b) throws JMSException {
        this.writeObject(new Boolean(b));
    }

    public void writeByte(byte b) throws JMSException {
        this.writeObject(new Byte(b));
    }

    public void writeShort(short s) throws JMSException {
        this.writeObject(new Short(s));
    }

    public void writeInt(int i) throws JMSException {
        this.writeObject(new Integer(i));
    }

    public void writeLong(long l) throws JMSException {
        this.writeObject(new Long(l));
    }

    public void writeFloat(float f) throws JMSException {
        this.writeObject(new Float(f));
    }

    public void writeDouble(double d) throws JMSException {
        this.writeObject(new Double(d));
    }

    public void writeString(String s) throws JMSException {
        this.writeObject(s);
    }

    public void writeChar(char ch) throws JMSException {
        this.writeObject(new Character(ch));
    }

    public void writeBytes(byte[] buf) throws JMSException {
        this.writeBytes(buf, 0, buf.length);
    }

    public void writeBytes(byte[] buf, int offset, int length) throws JMSException {
        byte[] newBuf = new byte[length];
        System.arraycopy(buf, offset, newBuf, 0, length);
        this.writeObject(newBuf);
    }

    public void writeObject(Object obj) throws JMSException {
        this.checkBodyWriteable();
        this._values.add(obj);
    }

    public MessageImpl copy() {
        return new StreamMessageImpl(this);
    }

    protected void copy(StreamMessageImpl newMsg) {
        super.copy(newMsg);
        newMsg._values = new ArrayList<Object>(this._values);
        newMsg._index = 0;
    }

    public InputStream bodyToInputStream() throws IOException {
        if (this._values == null || this._values.size() == 0) {
            return null;
        }
        TempStream body = new TempStream();
        body.openWrite();
        StreamImplOutputStream ws = new StreamImplOutputStream(body);
        Hessian2Output out = new Hessian2Output(ws);
        out.writeObject(this._values);
        out.close();
        ws.close();
        return body.openRead();
    }

    public void readBody(InputStream is) throws IOException, JMSException {
        if (is != null) {
            Hessian2Input in = new Hessian2Input(is);
            this._values = (ArrayList)in.readObject();
            in.close();
        }
        this.reset();
    }

    public String toString() {
        return "StreamMessageImpl[]";
    }
}

