/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.queue;

import com.caucho.jms.queue.AbstractDestination;
import com.caucho.jms.queue.EntryCallback;
import com.caucho.jms.queue.MessageCallback;
import com.caucho.jms.queue.MessageException;
import com.caucho.jms.queue.MessageQueue;
import com.caucho.jms.queue.QueueAdmin;
import com.caucho.jms.queue.QueueEntry;
import com.caucho.jms.queue.QueueEntrySelector;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.TextMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueue<E>
extends AbstractDestination<E>
implements Queue,
MessageQueue<E>,
BlockingQueue<E> {
    private static final L10N L = new L10N(AbstractQueue.class);
    private static final Logger log = Logger.getLogger(AbstractQueue.class.getName());
    private QueueAdmin _admin;
    private long _listenerFailCount;
    private long _listenerFailLastTime;

    protected AbstractQueue() {
    }

    public void setQueueName(String name) {
        this.setName(name);
    }

    protected void init() {
    }

    @PostConstruct
    public void postConstruct() {
        try {
            this.init();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        this._admin = new QueueAdmin(this);
        this._admin.register();
    }

    @Override
    public void send(String msgId, E msg, int priority, long expireTime) throws MessageException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void send(String msgId, E msg, int priority, long expireTime, Object publisher) throws MessageException {
        this.send(msgId, msg, priority, expireTime);
    }

    @Override
    public QueueEntry<E> receiveEntry(long expireTime, boolean isAutoAck) {
        return null;
    }

    public QueueEntry<E> receiveEntry(long expireTime, boolean isAutoAck, QueueEntrySelector selector) throws MessageException {
        return this.receiveEntry(expireTime, isAutoAck);
    }

    @Override
    public EntryCallback<E> addMessageCallback(MessageCallback<E> callback, boolean isAutoAck) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void removeMessageCallback(EntryCallback<E> entryCallback) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void acknowledge(String msgId) {
    }

    @Override
    public void rollback(String msgId) {
    }

    public E receive() throws MessageException {
        long expireTime = Alarm.isTest() ? Alarm.getCurrentTimeActual() + 120000L : 0x3FFFFFFFFFFFFFFFL;
        return this.receive(expireTime, true);
    }

    @Override
    public E receive(long expireTime) throws MessageException {
        return this.receive(expireTime, true);
    }

    public E receive(long expireTime, boolean isAutoAcknowledge) throws MessageException {
        QueueEntry<E> entry = this.receiveEntry(expireTime, isAutoAcknowledge);
        if (entry != null) {
            return entry.getPayload();
        }
        return null;
    }

    public ArrayList<? extends QueueEntry<E>> getBrowserList() {
        return new ArrayList();
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean offer(E message, long timeout, TimeUnit unit) {
        int priority = 0;
        timeout = unit.toMillis(timeout);
        long expires = Alarm.getCurrentTimeActual() + timeout;
        this.send(this.generateMessageID(), message, priority, expires);
        return true;
    }

    @Override
    public boolean offer(E message) {
        return this.offer(message, 0L, TimeUnit.SECONDS);
    }

    @Override
    public void put(E value) {
        this.offer(value, Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public E poll(long timeout, TimeUnit unit) {
        long msTimeout = unit.toMillis(timeout);
        long expireTime = msTimeout + Alarm.getCurrentTimeActual();
        E payload = this.receive(expireTime);
        try {
            if (payload == null) {
                return null;
            }
            if (payload instanceof ObjectMessage) {
                return (E)((ObjectMessage)payload).getObject();
            }
            if (payload instanceof TextMessage) {
                return (E)((TextMessage)payload).getText();
            }
            return payload;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageException(e);
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public E peek() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public E poll() {
        return this.poll(0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public E take() {
        return this.poll(Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> c, int max) {
        throw new UnsupportedOperationException();
    }

    public int getConsumerCount() {
        return 0;
    }

    public int getReceiverCount() {
        return 0;
    }

    public int getQueueSize() {
        return -1;
    }

    public long getListenerFailCountTotal() {
        return this._listenerFailCount;
    }

    public long getListenerFailLastTime() {
        return this._listenerFailLastTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListenerException(Exception e) {
        AbstractQueue abstractQueue = this;
        synchronized (abstractQueue) {
            ++this._listenerFailCount;
            this._listenerFailLastTime = Alarm.getCurrentTimeActual();
        }
    }

    protected void startPoll() {
    }

    protected void stopPoll() {
    }

    @Override
    @PreDestroy
    public void close() {
        this.stopPoll();
        super.close();
    }
}

