/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmtp;

import com.caucho.bam.ActorError;
import com.caucho.bam.ActorStream;
import com.caucho.hmtp.HmtpPacketType;
import com.caucho.json.JsonInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmtpReader {
    private static final Logger log = Logger.getLogger(JmtpReader.class.getName());
    private static final HashMap<String, HmtpPacketType> _typeMap = new HashMap();
    private InputStream _is;
    private JsonInput _in;

    public JmtpReader() {
    }

    public JmtpReader(InputStream is) {
        this.init(is);
    }

    public void init(InputStream is) {
        this._is = is;
        this._in = new JsonInput(is);
    }

    public boolean readPacket(ActorStream actorStream) throws IOException {
        if (actorStream == null) {
            throw new IllegalStateException("HmtpReader.readPacket requires a valid ActorStream for callbacks");
        }
        try {
            if (!this.startPacket()) {
                this.close();
                return false;
            }
        }
        catch (IOException e) {
            log.fine(this + " exception while reading JMTP packet\n  " + e);
            log.log(Level.FINER, e.toString(), e);
        }
        JsonInput in = this._in;
        if (in == null) {
            return false;
        }
        String type = this.readString();
        String to = this.readString();
        String from = this.readString();
        String payloadType = this.readString();
        Class payloadClass = this.getPayloadClass(payloadType);
        HmtpPacketType packetType = _typeMap.get(type);
        if (packetType == null) {
            throw new IllegalStateException("'" + type + "' is an unknown packet type");
        }
        switch (packetType) {
            case MESSAGE: {
                Serializable value = (Serializable)in.readObject(payloadClass);
                in.endPacket();
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " message " + value + " {to:" + to + ", from:" + from + "}");
                }
                actorStream.message(to, from, value);
                break;
            }
            case MESSAGE_ERROR: {
                Serializable value = (Serializable)in.readObject();
                ActorError error = in.readObject(ActorError.class);
                in.endPacket();
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " messageError " + error + " " + value + " {to:" + to + ", from:" + from + "}");
                }
                actorStream.messageError(to, from, value, error);
                break;
            }
            case QUERY_GET: {
                long id = in.readLong();
                Serializable value = (Serializable)in.readObject();
                in.endPacket();
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " queryGet " + value + " {id:" + id + ", to:" + to + ", from:" + from + "}");
                }
                actorStream.queryGet(id, to, from, value);
                break;
            }
            case QUERY_SET: {
                long id = in.readLong();
                Serializable value = (Serializable)in.readObject();
                in.endPacket();
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " querySet " + value + " {id:" + id + ", to:" + to + ", from:" + from + "}");
                }
                actorStream.querySet(id, to, from, value);
                break;
            }
            case QUERY_RESULT: {
                long id = in.readLong();
                Serializable value = (Serializable)in.readObject();
                in.endPacket();
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " queryResult " + value + " {id:" + id + ", to:" + to + ", from:" + from + "}");
                }
                actorStream.queryResult(id, to, from, value);
                break;
            }
            case QUERY_ERROR: {
                long id = in.readLong();
                Serializable value = (Serializable)in.readObject();
                ActorError error = in.readObject(ActorError.class);
                in.endPacket();
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " queryError " + error + " " + value + " {id:" + id + ", to:" + to + ", from:" + from + "}");
                }
                actorStream.queryError(id, to, from, value, error);
                break;
            }
            default: {
                throw new UnsupportedOperationException("ERROR: " + type);
            }
        }
        return true;
    }

    public String readString() throws IOException {
        int ch;
        InputStream is = this._is;
        if (is == null) {
            return null;
        }
        while ((ch = is.read()) >= 0 && Character.isWhitespace(ch) && ch != 255) {
        }
        if (ch < 0 || ch == 255) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append((char)ch);
        while ((ch = is.read()) >= 0 && !Character.isWhitespace(ch) && ch != 255) {
            sb.append((char)ch);
        }
        return sb.toString();
    }

    public boolean startPacket() throws IOException {
        int ch;
        if (this._is == null) {
            return false;
        }
        while ((ch = this._is.read()) >= 0 && Character.isWhitespace((char)ch)) {
        }
        if (ch < 0) {
            return false;
        }
        if (ch == 0) {
            return true;
        }
        throw new IOException("0x" + Integer.toHexString(ch) + " is an illegal JmtpPacket start");
    }

    public void close() {
        try {
            JsonInput in = this._in;
            this._in = null;
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    protected Class getPayloadClass(String type) {
        if ("String".equals(type)) {
            return null;
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName(type, false, loader);
            return cl;
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._is + "]";
    }

    static {
        _typeMap.put("message", HmtpPacketType.MESSAGE);
        _typeMap.put("message_error", HmtpPacketType.MESSAGE_ERROR);
        _typeMap.put("get", HmtpPacketType.QUERY_GET);
        _typeMap.put("set", HmtpPacketType.QUERY_SET);
        _typeMap.put("result", HmtpPacketType.QUERY_RESULT);
        _typeMap.put("query_error", HmtpPacketType.QUERY_ERROR);
    }
}

