/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmtp;

import com.caucho.bam.Actor;
import com.caucho.bam.ActorStream;
import com.caucho.config.ConfigException;
import com.caucho.jmtp.JmtpReader;
import com.caucho.jmtp.JmtpWriter;
import com.caucho.servlet.JanusContext;
import com.caucho.servlet.JanusListener;
import com.caucho.servlet.JanusServletRequest;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class JmtpServlet
extends GenericServlet {
    private static final L10N L = new L10N(JmtpServlet.class);
    private static final Logger log = Logger.getLogger(JmtpServlet.class.getName());
    private Class _actorClass;

    public void setActorClass(Class actorClass) {
        this._actorClass = actorClass;
    }

    public void init() {
        if (this._actorClass == null) {
            throw new ConfigException(L.l("JmtpServlet requires an actor"));
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        Actor actor;
        JanusServletRequest wsRequest = (JanusServletRequest)request;
        try {
            actor = (Actor)this._actorClass.newInstance();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        Listener listener = new Listener(actor);
        wsRequest.startWebSocket(listener);
    }

    static class Listener
    implements JanusListener {
        private Actor _actor;
        private ActorStream _actorStream;
        private InputStream _is;
        private OutputStream _os;
        private JmtpReader _jmtpReader;
        private JmtpWriter _jmtpWriter;

        Listener(Actor actor) {
            this._actor = actor;
        }

        public void onStart(JanusContext context) throws IOException {
            this._is = context.openMessageInputStream();
            this._os = context.openMessageOutputStream();
            this._jmtpReader = new JmtpReader(this._is);
            this._jmtpWriter = new JmtpWriter(this._os);
            this._actor.setLinkStream(this._jmtpWriter);
            this._actorStream = this._actor.getActorStream();
        }

        public void onMessage(JanusContext context) throws IOException {
            this._jmtpReader.readPacket(this._actorStream);
        }

        public void onComplete(JanusContext context) throws IOException {
        }

        public void onTimeout(JanusContext context) throws IOException {
        }
    }
}

