/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.application;

import com.caucho.jsf.cfg.NavigationRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;

public class NavigationHandlerImpl
extends NavigationHandler {
    private static final Logger log = Logger.getLogger(NavigationHandlerImpl.class.getName());
    private ArrayList<NavigationRule> _ruleList = new ArrayList();
    private HashMap<String, NavigationRule[]> _ruleMap = new HashMap();

    public void addRule(NavigationRule rule) {
        this._ruleList.add(rule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        NavigationRule[] ruleList;
        if (outcome == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Jsf[" + context.getViewRoot().getViewId() + "] action " + fromAction + " has no outcome");
            }
            return;
        }
        HashMap<String, NavigationRule[]> hashMap = this._ruleMap;
        synchronized (hashMap) {
            String viewId = context.getViewRoot().getViewId();
            ruleList = this._ruleMap.get(viewId);
            if (ruleList == null) {
                ruleList = this.findRuleList(viewId);
            }
            this._ruleMap.put(viewId, ruleList);
        }
        for (int i = 0; i < ruleList.length; ++i) {
            if (!ruleList[i].handleNavigation(context, fromAction, outcome)) continue;
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Jsf[" + context.getViewRoot().getViewId() + "] action:" + fromAction + " outcome:" + outcome + " has no matching navigation rule");
        }
    }

    private NavigationRule[] findRuleList(String viewId) {
        ArrayList<NavigationRule> ruleList = new ArrayList<NavigationRule>();
        for (int i = 0; i < this._ruleList.size(); ++i) {
            NavigationRule rule = this._ruleList.get(i);
            if (!rule.isMatch(viewId)) continue;
            ruleList.add(rule);
        }
        Object[] rules = new NavigationRule[ruleList.size()];
        ruleList.toArray(rules);
        Arrays.sort(rules);
        return rules;
    }

    public String toString() {
        return "NavigationHandlerImpl[]";
    }
}

