/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.cfg;

import com.caucho.config.ConfigException;
import com.caucho.jsf.cfg.AbstractValue;
import com.caucho.jsf.cfg.BeanProgram;
import com.caucho.util.L10N;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayPropertyBeanProgram
extends BeanProgram {
    private static final Logger log = Logger.getLogger(ArrayPropertyBeanProgram.class.getName());
    private static final L10N L = new L10N(ArrayPropertyBeanProgram.class);
    private Method _getter;
    private Method _setter;
    private List<AbstractValue> _values;
    private Class _baseType;
    private String _propertyName;

    public ArrayPropertyBeanProgram(Method getter, Method setter, List<AbstractValue> values, String propertyName) {
        this._getter = getter;
        this._setter = setter;
        this._values = values;
        this._propertyName = propertyName;
        this._baseType = getter != null ? getter.getReturnType().getComponentType() : setter.getParameterTypes()[0].getComponentType();
    }

    @Override
    public void configure(FacesContext context, Object bean) throws ConfigException {
        try {
            int length;
            Object list = null;
            if (this._setter == null) {
                if (log.isLoggable(Level.CONFIG)) {
                    log.log(Level.CONFIG, L.l("Setter for {0} not found in type {1}", (Object)this._propertyName, bean.getClass().getName()));
                }
                return;
            }
            if (this._getter != null) {
                list = this._getter.invoke(bean, new Object[0]);
            }
            if (list != null) {
                length = Array.getLength(list);
                Object newList = Array.newInstance(this._baseType, length + this._values.size());
                System.arraycopy(list, 0, newList, 0, length);
                list = newList;
            } else {
                length = 0;
                list = Array.newInstance(this._baseType, this._values.size());
            }
            for (int i = 0; i < this._values.size(); ++i) {
                AbstractValue value = this._values.get(i);
                Array.set(list, length + i, value.getValue(context));
            }
            this._setter.invoke(bean, list);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }
}

