/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.util.L10N;
import java.lang.reflect.Constructor;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;

public class FactoryConfig {
    private static final L10N L = new L10N(FactoryConfig.class);
    private String _id;
    private Class _applicationFactory;
    private Class _facesContextFactory;
    private Class _lifecycleFactory;
    private Class _renderKitFactory;

    public void setId(String id) {
        this._id = id;
    }

    public void setApplicationFactory(Class factory) throws ConfigException {
        if (!ApplicationFactory.class.isAssignableFrom(factory)) {
            throw new ConfigException(L.l("application-factory '{0}' class must extend ApplicationFactory.", factory.getName()));
        }
        if (!this.hasConstructor(factory, ApplicationFactory.class)) {
            throw new ConfigException(L.l("application-factory class '{0}' must either have an (ApplicationFactory) constructor or a null-arg constructor.", factory.getName()));
        }
        this._applicationFactory = factory;
    }

    private Class getApplicationFactory() throws ConfigException {
        return this._applicationFactory;
    }

    public void setFacesContextFactory(Class factory) throws ConfigException {
        if (!FacesContextFactory.class.isAssignableFrom(factory)) {
            throw new ConfigException(L.l("faces-context-factory '{0}' class must extend FacesContextFactory.", factory.getName()));
        }
        if (!this.hasConstructor(factory, FacesContextFactory.class)) {
            throw new ConfigException(L.l("faces-context-factory class '{0}' must either have an (FacesContextFactory) constructor or a null-arg constructor.", factory.getName()));
        }
        this._facesContextFactory = factory;
    }

    private Class getFacesContextFactory() throws ConfigException {
        return this._facesContextFactory;
    }

    public void setLifecycleFactory(Class factory) throws ConfigException {
        if (!LifecycleFactory.class.isAssignableFrom(factory)) {
            throw new ConfigException(L.l("lifecycle-factory '{0}' class must extend LifecycleFactory.", factory.getName()));
        }
        if (!this.hasConstructor(factory, LifecycleFactory.class)) {
            throw new ConfigException(L.l("lifecycle-factory class '{0}' must either have an (LifecycleFactory) constructor or a null-arg constructor.", factory.getName()));
        }
        this._lifecycleFactory = factory;
    }

    private Class getLifecycleFactory() throws ConfigException {
        return this._lifecycleFactory;
    }

    public void setRenderKitFactory(Class factory) throws ConfigException {
        if (!RenderKitFactory.class.isAssignableFrom(factory)) {
            throw new ConfigException(L.l("render-kit-factory '{0}' class must extend RenderKitFactory.", factory.getName()));
        }
        if (!this.hasConstructor(factory, RenderKitFactory.class)) {
            throw new ConfigException(L.l("render-kit-factory class '{0}' must either have an (RenderKitFactory) constructor or a null-arg constructor.", factory.getName()));
        }
        this._renderKitFactory = factory;
    }

    private Class getRenderKitFactory() throws ConfigException {
        return this._renderKitFactory;
    }

    public void setFactoryExtension(ConfigProgram program) throws ConfigException {
    }

    void init() {
        try {
            if (this._applicationFactory != null) {
                FactoryFinder.setFactory((String)"javax.faces.application.ApplicationFactory", (String)this._applicationFactory.getName());
            }
            if (this._facesContextFactory != null) {
                FactoryFinder.setFactory((String)"javax.faces.context.FacesContextFactory", (String)this._facesContextFactory.getName());
            }
            if (this._lifecycleFactory != null) {
                FactoryFinder.setFactory((String)"javax.faces.lifecycle.LifecycleFactory", (String)this._lifecycleFactory.getName());
            }
            if (this._renderKitFactory != null) {
                FactoryFinder.setFactory((String)"javax.faces.render.RenderKitFactory", (String)this._renderKitFactory.getName());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    private boolean hasConstructor(Class factoryClass, Class api) {
        Constructor ctor;
        try {
            ctor = factoryClass.getConstructor(api);
            if (ctor != null) {
                return true;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            ctor = factoryClass.getConstructor(new Class[0]);
            if (ctor != null) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }
}

