/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.cfg;

import com.caucho.config.types.DescriptionGroupConfig;
import com.caucho.jsf.cfg.AbstractValueConfig;
import com.caucho.jsf.cfg.BeanProgram;
import com.caucho.jsf.cfg.ListEntries;
import com.caucho.jsf.cfg.MappedEntries;
import com.caucho.jsf.cfg.NullValue;
import com.caucho.jsf.cfg.PropertyBeanProgram;
import com.caucho.jsf.cfg.ValueConfig;
import com.caucho.util.L10N;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedProperty
extends DescriptionGroupConfig {
    private static final L10N L = new L10N(ManagedProperty.class);
    protected static final Logger log = Logger.getLogger(ManagedProperty.class.getName());
    private String _id;
    private String _name;
    private AbstractValueConfig _value = NullValue.NULL;

    public String getName() {
        return this._name;
    }

    @Override
    public void setId(String id) {
        this._id = id;
    }

    public void setPropertyName(String name) {
        this._name = name;
    }

    public void setNullValue(NullValue value) {
        this._value = NullValue.NULL;
    }

    public void setValue(String value) {
        this._value = new ValueConfig(value);
    }

    public void setMapEntries(MappedEntries entries) {
        this._value = entries;
    }

    public void setListEntries(ListEntries entries) {
        this._value = entries;
    }

    public void setPropertyClass(Class type) {
    }

    public Class getPropertyClass() {
        return null;
    }

    public void addProgram(ArrayList<BeanProgram> program, Class type) {
        if (this._value instanceof MappedEntries) {
            ((MappedEntries)this._value).addProgram(program, this._name, type);
            return;
        }
        if (this._value instanceof ListEntries) {
            ((ListEntries)this._value).addProgram(program, this._name, type);
            return;
        }
        String name = "set" + Character.toUpperCase(this._name.charAt(0)) + this._name.substring(1);
        Method setter = ManagedProperty.findSetter(type, name);
        if (setter == null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(L.l("'{0}' is unknown property of '{1}'", (Object)this._name, type.getName()));
            }
            program.add(new PropertyBeanProgram(this._name, false));
        } else {
            Class<?> propType = setter.getParameterTypes()[0];
            program.add(new PropertyBeanProgram(setter, this._value.getValue(propType)));
        }
    }

    private static Method findSetter(Class type, String name) {
        if (type == null) {
            return null;
        }
        while (!Object.class.equals((Object)type)) {
            for (Method method : type.getDeclaredMethods()) {
                if (!method.getName().equals(name) || method.getParameterTypes().length != 1 || Modifier.isStatic(method.getModifiers())) continue;
                return method;
            }
            type = type.getSuperclass();
        }
        return null;
    }
}

