/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.cfg;

import com.caucho.config.ConfigException;
import com.caucho.jsf.cfg.AbstractValue;
import com.caucho.jsf.cfg.BeanProgram;
import com.caucho.jsf.cfg.PropertyBeanProgram;
import com.caucho.util.L10N;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPropertyBeanProgram
extends BeanProgram {
    private static final Logger log = Logger.getLogger(PropertyBeanProgram.class.getName());
    private static final L10N L = new L10N(PropertyBeanProgram.class);
    private Method _getter;
    private Method _setter;
    private List<AbstractValue> _keys;
    private List<AbstractValue> _values;
    private String _propertyName;

    public MapPropertyBeanProgram(Method getter, Method setter, List<AbstractValue> keys, List<AbstractValue> values, String propertyName) {
        this._getter = getter;
        this._setter = setter;
        this._keys = keys;
        this._values = values;
        this._propertyName = propertyName;
    }

    @Override
    public void configure(FacesContext context, Object bean) throws ConfigException {
        try {
            boolean newMap = false;
            HashMap<Object, Object> map = null;
            if (this._getter != null) {
                map = (HashMap<Object, Object>)this._getter.invoke(bean, new Object[0]);
            }
            if (map == null) {
                if (this._setter == null) {
                    if (log.isLoggable(Level.CONFIG)) {
                        log.log(Level.CONFIG, L.l("Setter for {0} not found in type {1}", (Object)this._propertyName, bean.getClass().getName()));
                    }
                    return;
                }
                newMap = true;
                map = new HashMap<Object, Object>();
            }
            for (int i = 0; i < this._keys.size(); ++i) {
                AbstractValue key = this._keys.get(i);
                AbstractValue value = this._values.get(i);
                map.put(key.getValue(context), value.getValue(context));
            }
            if (newMap) {
                this._setter.invoke(bean, map);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }
}

