/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.cfg;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.types.DescriptionGroupConfig;
import com.caucho.jsf.cfg.DummyFacesContext;
import com.caucho.jsf.cfg.RendererConfig;
import com.caucho.util.L10N;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;

public class RenderKitConfig
extends DescriptionGroupConfig {
    private static final L10N L = new L10N(RenderKitConfig.class);
    private String _name = "HTML_BASIC";
    private Class _class;
    private RenderKit _renderKit;
    private ArrayList<RendererConfig> _rendererList = new ArrayList();

    public void setName(String name) {
        this._name = name;
    }

    public void setRenderKitId(String name) {
        this.setName(name);
    }

    public void setClass(Class cl) {
        Config.validate(cl, RenderKit.class);
        this._class = cl;
    }

    public void setRenderKitClass(Class cl) {
        this.setClass(cl);
    }

    public void addRenderer(RendererConfig renderer) {
        this._rendererList.add(renderer);
    }

    @PostConstruct
    public void init() throws InstantiationException, IllegalAccessException {
        if (this._class != null) {
            this._renderKit = (RenderKit)this._class.newInstance();
        }
    }

    public void configure() {
        RenderKit oldRenderKit;
        RenderKitFactory factory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        DummyFacesContext context = new DummyFacesContext();
        RenderKit renderKit = oldRenderKit = factory.getRenderKit((FacesContext)context, this._name);
        if (this._class != null) {
            if (oldRenderKit != null) {
                try {
                    Constructor ctor = this._class.getConstructor(RenderKit.class);
                    renderKit = (RenderKit)ctor.newInstance(oldRenderKit);
                }
                catch (NoSuchMethodException e) {
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw ConfigException.create(e);
                }
            }
            try {
                renderKit = (RenderKit)this._class.newInstance();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
            if (this._name == null) {
                throw new ConfigException(L.l("'{0}' is an unknown render-kit-id.", this._name));
            }
            factory.addRenderKit(this._name, renderKit);
        }
        if (renderKit == null) {
            throw new ConfigException(L.l("'{0}' is an unknown render-kit-id.", this._name));
        }
        for (RendererConfig renderer : this._rendererList) {
            renderer.configure(renderKit);
        }
    }
}

