/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.context;

import com.caucho.jsp.BodyResponseStream;
import com.caucho.server.http.AbstractResponseStream;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.CauchoResponseWrapper;
import com.caucho.server.http.ResponseWriter;
import com.caucho.server.http.ServletOutputStreamImpl;
import com.caucho.vfs.FlushBuffer;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspResponseWrapper
extends CauchoResponseWrapper {
    private static final Logger log = Logger.getLogger(JspResponseWrapper.class.getName());
    private boolean _hasError;
    private BodyResponseStream _bodyStream;
    private AbstractResponseStream _stream;
    private HttpServletResponse _response;
    private TempStream _tempStream = new TempStream();
    private WriteStream _out;
    private FlushBuffer _flushBuffer;
    private ResponseWriter _writer = new ResponseWriter();
    private ServletOutputStreamImpl _os = new ServletOutputStreamImpl();

    public void init(HttpServletResponse response) {
        this._bodyStream = new BodyResponseStream();
        this._stream = this._bodyStream;
        this._out = new WriteStream(this._tempStream);
        this._bodyStream.setWriter(this._out.getPrintWriter());
        this.setResponse(response);
        this._response = response;
        this._os.init(this._stream);
        this._writer.init(this._stream);
        this._hasError = false;
    }

    @Override
    public void setResponseStream(AbstractResponseStream stream) {
        try {
            this._stream.flushBuffer();
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        this._stream = stream;
        this._os.init(stream);
        this._writer.init(stream);
    }

    @Override
    public AbstractResponseStream getResponseStream() {
        return this._stream;
    }

    @Override
    public boolean isCauchoResponseStream() {
        return true;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return this._os;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return this._writer;
    }

    protected OutputStream getStream() throws IOException {
        return this._response.getOutputStream();
    }

    public void setFlushBuffer(FlushBuffer flushBuffer) {
        this._flushBuffer = flushBuffer;
    }

    public FlushBuffer getFlushBuffer() {
        return this._flushBuffer;
    }

    @Override
    public void flushBuffer() throws IOException {
    }

    @Override
    public void resetBuffer() {
        if (this._stream != null) {
            this._stream.clearBuffer();
        }
    }

    public void clearBuffer() {
        this.resetBuffer();
    }

    @Override
    public void setLocale(Locale locale) {
        this._response.setLocale(locale);
        try {
            this._stream.setLocale(this._response.getLocale());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public String getHeader(String key) {
        return null;
    }

    public boolean disableHeaders(boolean disable) {
        return false;
    }

    public int getRemaining() {
        return this._stream.getRemaining();
    }

    @Override
    public void setForbidForward(boolean forbid) {
    }

    @Override
    public boolean getForbidForward() {
        return false;
    }

    @Override
    public void setHasError(boolean hasError) {
        this._hasError = hasError;
    }

    @Override
    public String getStatusMessage() {
        if (this._response instanceof CauchoResponse) {
            return ((CauchoResponse)this._response).getStatusMessage();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasError() {
        return this._hasError;
    }

    @Override
    public void killCache() {
    }

    @Override
    public void setSessionId(String id) {
    }

    @Override
    public void setPrivateCache(boolean isPrivate) {
    }

    @Override
    public void setNoCache(boolean isPrivate) {
    }

    @Override
    public int getStatus() {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return this._response.getHeaders(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this._response.getHeaderNames();
    }

    @Override
    public void close() throws IOException {
        WriteStream out = this._out;
        this._out = null;
        if (out != null) {
            out.close();
        }
    }

    public void flushResponse() throws IOException {
        int ch;
        this._out.flush();
        ReadStream rs = this._tempStream.openRead();
        PrintWriter out = this._response.getWriter();
        while ((ch = rs.readChar()) >= 0) {
            out.write((char)ch);
        }
        rs.close();
    }

    public String completeJsf() throws IOException {
        int ch;
        WriteStream out = this._out;
        this._out = null;
        if (out != null) {
            out.flush();
        }
        ReadStream rs = this._tempStream.openRead();
        StringBuilder sb = new StringBuilder();
        while ((ch = rs.readChar()) >= 0) {
            sb.append((char)ch);
        }
        rs.close();
        return sb.toString();
    }
}

