/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.html;

import com.caucho.jsf.html.HtmlBooleanCheckboxRenderer;
import com.caucho.jsf.html.HtmlCommandButtonRenderer;
import com.caucho.jsf.html.HtmlCommandLinkRenderer;
import com.caucho.jsf.html.HtmlDataTableRenderer;
import com.caucho.jsf.html.HtmlFormRenderer;
import com.caucho.jsf.html.HtmlGraphicImageRenderer;
import com.caucho.jsf.html.HtmlInputHiddenRenderer;
import com.caucho.jsf.html.HtmlInputSecretRenderer;
import com.caucho.jsf.html.HtmlInputTextRenderer;
import com.caucho.jsf.html.HtmlInputTextareaRenderer;
import com.caucho.jsf.html.HtmlMessageRenderer;
import com.caucho.jsf.html.HtmlMessagesRenderer;
import com.caucho.jsf.html.HtmlOutputFormatRenderer;
import com.caucho.jsf.html.HtmlOutputLabelRenderer;
import com.caucho.jsf.html.HtmlOutputLinkRenderer;
import com.caucho.jsf.html.HtmlOutputTextRenderer;
import com.caucho.jsf.html.HtmlPanelGridRenderer;
import com.caucho.jsf.html.HtmlPanelGroupRenderer;
import com.caucho.jsf.html.HtmlResponseStream;
import com.caucho.jsf.html.HtmlResponseWriter;
import com.caucho.jsf.html.HtmlSelectManyCheckboxRenderer;
import com.caucho.jsf.html.HtmlSelectManyListboxRenderer;
import com.caucho.jsf.html.HtmlSelectManyMenuRenderer;
import com.caucho.jsf.html.HtmlSelectOneListboxRenderer;
import com.caucho.jsf.html.HtmlSelectOneMenuRenderer;
import com.caucho.jsf.html.HtmlSelectOneRadioRenderer;
import com.caucho.jsf.html.ResponseStateManagerImpl;
import com.caucho.util.L10N;
import com.caucho.vfs.Encoding;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;

public class HtmlBasicRenderKit
extends RenderKit {
    private static final L10N L = new L10N(HtmlBasicRenderKit.class);
    private ResponseStateManager _responseStateManager = new ResponseStateManagerImpl();
    private HashMap<Key, Renderer> _rendererMap = new HashMap();
    private Key _key = new Key();

    public HtmlBasicRenderKit() {
        this.addRenderer("javax.faces.Command", "javax.faces.Button", HtmlCommandButtonRenderer.RENDERER);
        this.addRenderer("javax.faces.Command", "javax.faces.Link", HtmlCommandLinkRenderer.RENDERER);
        this.addRenderer("javax.faces.Data", "javax.faces.Table", HtmlDataTableRenderer.RENDERER);
        this.addRenderer("javax.faces.Form", "javax.faces.Form", HtmlFormRenderer.RENDERER);
        this.addRenderer("javax.faces.Graphic", "javax.faces.Image", HtmlGraphicImageRenderer.RENDERER);
        this.addRenderer("javax.faces.Input", "javax.faces.Secret", HtmlInputSecretRenderer.RENDERER);
        this.addRenderer("javax.faces.Input", "javax.faces.Hidden", HtmlInputHiddenRenderer.RENDERER);
        this.addRenderer("javax.faces.Input", "javax.faces.Text", HtmlInputTextRenderer.RENDERER);
        this.addRenderer("javax.faces.Input", "javax.faces.Textarea", HtmlInputTextareaRenderer.RENDERER);
        this.addRenderer("javax.faces.Message", "javax.faces.Message", HtmlMessageRenderer.RENDERER);
        this.addRenderer("javax.faces.Messages", "javax.faces.Messages", HtmlMessagesRenderer.RENDERER);
        this.addRenderer("javax.faces.Output", "javax.faces.Format", HtmlOutputFormatRenderer.RENDERER);
        this.addRenderer("javax.faces.Output", "javax.faces.Label", HtmlOutputLabelRenderer.RENDERER);
        this.addRenderer("javax.faces.Output", "javax.faces.Link", HtmlOutputLinkRenderer.RENDERER);
        this.addRenderer("javax.faces.Output", "javax.faces.Text", HtmlOutputTextRenderer.RENDERER);
        this.addRenderer("javax.faces.Output", "javax.faces.Format", HtmlOutputFormatRenderer.RENDERER);
        this.addRenderer("javax.faces.Panel", "javax.faces.Grid", HtmlPanelGridRenderer.RENDERER);
        this.addRenderer("javax.faces.Panel", "javax.faces.Group", HtmlPanelGroupRenderer.RENDERER);
        this.addRenderer("javax.faces.SelectBoolean", "javax.faces.Checkbox", HtmlBooleanCheckboxRenderer.RENDERER);
        this.addRenderer("javax.faces.SelectMany", "javax.faces.Checkbox", HtmlSelectManyCheckboxRenderer.RENDERER);
        this.addRenderer("javax.faces.SelectMany", "javax.faces.Listbox", HtmlSelectManyListboxRenderer.RENDERER);
        this.addRenderer("javax.faces.SelectMany", "javax.faces.Menu", HtmlSelectManyMenuRenderer.RENDERER);
        this.addRenderer("javax.faces.SelectOne", "javax.faces.Listbox", HtmlSelectOneListboxRenderer.RENDERER);
        this.addRenderer("javax.faces.SelectOne", "javax.faces.Menu", HtmlSelectOneMenuRenderer.RENDERER);
        this.addRenderer("javax.faces.SelectOne", "javax.faces.Radio", HtmlSelectOneRadioRenderer.RENDERER);
    }

    public void addRenderer(String family, String rendererType, Renderer renderer) {
        if (family == null) {
            throw new NullPointerException("family argument is null");
        }
        if (rendererType == null) {
            throw new NullPointerException("rendererType argument is null");
        }
        if (renderer == null) {
            throw new NullPointerException("renderer argument is null");
        }
        this._rendererMap.put(new Key(family, rendererType), renderer);
    }

    public Renderer getRenderer(String family, String rendererType) {
        if (family == null) {
            throw new NullPointerException("family argument is null");
        }
        if (rendererType == null) {
            throw new NullPointerException("rendererType argument is null");
        }
        this._key.init(family, rendererType);
        Renderer renderer = this._rendererMap.get(this._key);
        return renderer;
    }

    public ResponseStateManager getResponseStateManager() {
        return this._responseStateManager;
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String characterEncoding) {
        String contentType = null;
        if (contentTypeList != null) {
            if (contentTypeList.indexOf("text/html") > -1) {
                contentType = "text/html";
            } else if (contentTypeList.indexOf("application/xhtml+xml") > -1 || contentTypeList.indexOf("application/xml") > -1 || contentTypeList.indexOf("text/xml") > -1) {
                contentType = "application/xhtml+xml";
            } else if (contentTypeList.indexOf("*/*") > -1) {
                contentType = "text/html";
            } else {
                throw new IllegalArgumentException(L.l("'{0}' does not have a matching ResponseWriter.", contentTypeList));
            }
        }
        if (characterEncoding != null && Encoding.getWriteEncoding(characterEncoding) == null) {
            throw new IllegalArgumentException(L.l("'{0}' is an unknown character encoding for ResponseWriter.", characterEncoding));
        }
        return new HtmlResponseWriter(writer, contentType, characterEncoding);
    }

    public ResponseStream createResponseStream(OutputStream out) {
        return new HtmlResponseStream(out);
    }

    public String toString() {
        return "HtmlBasicRenderKit[]";
    }

    static final class Key {
        private String _family;
        private String _type;

        Key() {
        }

        Key(String family, String type) {
            this._family = family;
            this._type = type;
        }

        public void init(String family, String type) {
            this._family = family;
            this._type = type;
        }

        public int hashCode() {
            if (this._type != null) {
                return this._family.hashCode() * 65521 + this._type.hashCode();
            }
            return this._family.hashCode();
        }

        public boolean equals(Object o) {
            Key key = (Key)o;
            if (this._type != null) {
                return this._family.equals(key._family) && this._type.equals(key._type);
            }
            return this._family.equals(key._family) && key._type != null;
        }

        public String toString() {
            return "Key[" + this._family + ", " + this._type + "]";
        }
    }
}

