/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.html;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;

class HtmlCommandButtonRenderer
extends Renderer {
    private static final Logger log = Logger.getLogger(HtmlCommandButtonRenderer.class.getName());
    public static final Renderer RENDERER = new HtmlCommandButtonRenderer();

    HtmlCommandButtonRenderer() {
    }

    public boolean getRendersChildren() {
        return false;
    }

    public void decode(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        ExternalContext ext = context.getExternalContext();
        Map paramMap = ext.getRequestParameterMap();
        String value = (String)paramMap.get(clientId);
        if (value != null) {
            String type;
            if (component instanceof HtmlCommandButton) {
                HtmlCommandButton htmlComp = (HtmlCommandButton)component;
                type = htmlComp.getType();
            } else {
                Map attrMap = component.getAttributes();
                type = (String)attrMap.get("type");
            }
            if ("reset".equals(type)) {
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(component + " action " + type);
            }
            ActionEvent event = new ActionEvent(component);
            component.queueEvent((FacesEvent)event);
        } else {
            String valueX = (String)paramMap.get(clientId + ".x");
            String valueY = (String)paramMap.get(clientId + ".y");
            if (valueX != null || valueY != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(component + " action [" + valueX + "," + valueY + "]");
                }
                ActionEvent event = new ActionEvent(component);
                component.queueEvent((FacesEvent)event);
            }
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        Object value;
        String type;
        String title;
        String tabindex;
        String styleClass;
        String style;
        boolean readonly;
        String onselect;
        String onmouseup;
        String onmouseover;
        String onmouseout;
        String onmousemove;
        String onmousedown;
        String onkeyup;
        String onkeypress;
        String onkeydown;
        String onfocus;
        String ondblclick;
        String onclick;
        String onchange;
        String onblur;
        String lang;
        String image;
        boolean disabled;
        String dir;
        String alt;
        String accesskey;
        ResponseWriter out = context.getResponseWriter();
        String id = component.getId();
        if (component instanceof HtmlCommandButton) {
            HtmlCommandButton htmlCommandButton = (HtmlCommandButton)component;
            accesskey = htmlCommandButton.getAccesskey();
            alt = htmlCommandButton.getAlt();
            dir = htmlCommandButton.getDir();
            disabled = htmlCommandButton.isDisabled();
            image = htmlCommandButton.getImage();
            lang = htmlCommandButton.getLang();
            onblur = htmlCommandButton.getOnblur();
            onchange = htmlCommandButton.getOnchange();
            onclick = htmlCommandButton.getOnclick();
            ondblclick = htmlCommandButton.getOndblclick();
            onfocus = htmlCommandButton.getOnfocus();
            onkeydown = htmlCommandButton.getOnkeydown();
            onkeypress = htmlCommandButton.getOnkeypress();
            onkeyup = htmlCommandButton.getOnkeyup();
            onmousedown = htmlCommandButton.getOnmousedown();
            onmousemove = htmlCommandButton.getOnmousemove();
            onmouseout = htmlCommandButton.getOnmouseout();
            onmouseover = htmlCommandButton.getOnmouseover();
            onmouseup = htmlCommandButton.getOnmouseup();
            onselect = htmlCommandButton.getOnselect();
            readonly = htmlCommandButton.isReadonly();
            style = htmlCommandButton.getStyle();
            styleClass = htmlCommandButton.getStyleClass();
            tabindex = htmlCommandButton.getTabindex();
            title = htmlCommandButton.getTitle();
            type = htmlCommandButton.getType();
            value = htmlCommandButton.getValue();
        } else {
            Map attrMap = component.getAttributes();
            accesskey = (String)attrMap.get("accesskey");
            alt = (String)attrMap.get("alt");
            dir = (String)attrMap.get("dir");
            disabled = Boolean.TRUE.equals(attrMap.get("disabled"));
            image = (String)attrMap.get("image");
            lang = (String)attrMap.get("lang");
            onblur = (String)attrMap.get("onblur");
            onchange = (String)attrMap.get("onchange");
            onclick = (String)attrMap.get("onclick");
            ondblclick = (String)attrMap.get("ondblclick");
            onfocus = (String)attrMap.get("onfocus");
            onkeydown = (String)attrMap.get("onkeydown");
            onkeypress = (String)attrMap.get("onkeypress");
            onkeyup = (String)attrMap.get("onkeyup");
            onmousedown = (String)attrMap.get("onmousedown");
            onmousemove = (String)attrMap.get("onmousemove");
            onmouseout = (String)attrMap.get("onmouseout");
            onmouseover = (String)attrMap.get("onmouseover");
            onmouseup = (String)attrMap.get("onmouseup");
            onselect = (String)attrMap.get("onselect");
            readonly = Boolean.TRUE.equals(attrMap.get("readonly"));
            style = (String)attrMap.get("style");
            styleClass = (String)attrMap.get("styleClass");
            tabindex = (String)attrMap.get("tabindex");
            title = (String)attrMap.get("title");
            type = (String)attrMap.get("type");
            value = attrMap.get("value");
        }
        out.startElement("input", component);
        if (image != null && !"".equals(image)) {
            out.writeAttribute("type", (Object)"image", "type");
            ViewHandler view = context.getApplication().getViewHandler();
            String src = view.getResourceURL(context, image);
            ExternalContext extContext = context.getExternalContext();
            out.writeAttribute("src", (Object)extContext.encodeActionURL(src), "src");
        } else {
            if ("reset".equals(type)) {
                out.writeAttribute("type", (Object)"reset", "type");
            } else {
                out.writeAttribute("type", (Object)"submit", "type");
            }
            if (value != null) {
                out.writeAttribute("value", (Object)String.valueOf(value), "value");
            }
        }
        out.writeAttribute("name", (Object)component.getClientId(context), "name");
        if (id != null && !id.startsWith("j_id")) {
            out.writeAttribute("id", (Object)component.getClientId(context), "id");
        }
        if (accesskey != null) {
            out.writeAttribute("accesskey", (Object)accesskey, "accesskey");
        }
        if (alt != null) {
            out.writeAttribute("alt", (Object)alt, "alt");
        }
        if (dir != null) {
            out.writeAttribute("dir", (Object)dir, "dir");
        }
        if (disabled) {
            out.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (lang != null) {
            out.writeAttribute("lang", (Object)lang, "lang");
        }
        if (onblur != null) {
            out.writeAttribute("onblur", (Object)onblur, "onblur");
        }
        if (onchange != null) {
            out.writeAttribute("onchange", (Object)onchange, "onchange");
        }
        if (onclick != null) {
            out.writeAttribute("onclick", (Object)onclick, "onclick");
        }
        if (ondblclick != null) {
            out.writeAttribute("ondblclick", (Object)ondblclick, "ondblclick");
        }
        if (onfocus != null) {
            out.writeAttribute("onfocus", (Object)onfocus, "onfocus");
        }
        if (onkeydown != null) {
            out.writeAttribute("onkeydown", (Object)onkeydown, "onkeydown");
        }
        if (onkeypress != null) {
            out.writeAttribute("onkeypress", (Object)onkeypress, "onkeypress");
        }
        if (onkeyup != null) {
            out.writeAttribute("onkeyup", (Object)onkeyup, "onkeyup");
        }
        if (onmousedown != null) {
            out.writeAttribute("onmousedown", (Object)onmousedown, "onmousedown");
        }
        if (onmousemove != null) {
            out.writeAttribute("onmousemove", (Object)onmousemove, "onmousemove");
        }
        if (onmouseout != null) {
            out.writeAttribute("onmouseout", (Object)onmouseout, "onmouseout");
        }
        if (onmouseover != null) {
            out.writeAttribute("onmouseover", (Object)onmouseover, "onmouseover");
        }
        if (onmouseup != null) {
            out.writeAttribute("onmouseup", (Object)onmouseup, "onmouseup");
        }
        if (onselect != null) {
            out.writeAttribute("onselect", (Object)onselect, "onselect");
        }
        if (readonly) {
            out.writeAttribute("readonly", (Object)"readonly", "readonly");
        }
        if (style != null) {
            out.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            out.writeAttribute("class", (Object)styleClass, "class");
        }
        if (tabindex != null) {
            out.writeAttribute("tabindex", (Object)tabindex, "tabindex");
        }
        if (title != null) {
            out.writeAttribute("title", (Object)title, "title");
        }
        out.endElement("input");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }

    public String toString() {
        return "HtmlInputTextRenderer[]";
    }
}

