/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.html;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlOutputFormat;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.render.Renderer;

class HtmlOutputFormatRenderer
extends Renderer {
    private static final Logger log = Logger.getLogger(HtmlOutputFormatRenderer.class.getName());
    public static final Renderer RENDERER = new HtmlOutputFormatRenderer();

    HtmlOutputFormatRenderer() {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        String title;
        String styleClass;
        String style;
        String lang;
        String dir;
        ResponseWriter out = context.getResponseWriter();
        String id = component.getId();
        if (component instanceof HtmlOutputFormat) {
            HtmlOutputFormat htmlOutput = (HtmlOutputFormat)component;
            dir = htmlOutput.getDir();
            lang = htmlOutput.getLang();
            style = htmlOutput.getStyle();
            styleClass = htmlOutput.getStyleClass();
            title = htmlOutput.getTitle();
        } else {
            Map attrMap = component.getAttributes();
            dir = (String)attrMap.get("dir");
            lang = (String)attrMap.get("lang");
            style = (String)attrMap.get("style");
            styleClass = (String)attrMap.get("styleClass");
            title = (String)attrMap.get("title");
        }
        if (dir == null && lang == null && style == null && styleClass == null) {
            return;
        }
        out.startElement("span", component);
        if (id != null && !id.startsWith("j_id")) {
            out.writeAttribute("id", (Object)component.getClientId(context), "id");
        }
        if (dir != null) {
            out.writeAttribute("dir", (Object)dir, "dir");
        }
        if (lang != null) {
            out.writeAttribute("lang", (Object)lang, "dir");
        }
        if (style != null) {
            out.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            out.writeAttribute("class", (Object)styleClass, "class");
        }
        if (title != null) {
            out.writeAttribute("title", (Object)title, "title");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        if (component instanceof HtmlOutputFormat) {
            HtmlOutputFormat htmlOutput = (HtmlOutputFormat)component;
            Object value = htmlOutput.getValue();
            if (value == null) {
                return;
            }
            ArrayList<Object> paramList = new ArrayList<Object>();
            List children = component.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Object child = children.get(i);
                if (!(child instanceof UIParameter)) continue;
                UIParameter param = (UIParameter)child;
                paramList.add(param.getValue());
            }
            Object[] params = paramList.toArray(new Object[paramList.size()]);
            String pattern = this.toString(context, component, value);
            String string = new MessageFormat(pattern, context.getViewRoot().getLocale()).format(params);
            out.writeText((Object)string, "value");
        } else {
            Map attrMap = component.getAttributes();
            Object value = attrMap.get("value");
            if (value == null) {
                return;
            }
            out.writeText(value, "value");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        if (component instanceof HtmlOutputFormat) {
            HtmlOutputFormat htmlOutput = (HtmlOutputFormat)component;
            if (htmlOutput.getStyleClass() != null || htmlOutput.getStyle() != null || htmlOutput.getDir() != null || htmlOutput.getLang() != null) {
                out.endElement("span");
            }
        } else {
            Map attrMap = component.getAttributes();
            if (attrMap.get("styleClass") != null || attrMap.get("style") != null || attrMap.get("dir") != null || attrMap.get("lang") != null) {
                out.endElement("span");
            }
        }
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIOutput)) continue;
            child.encodeAll(context);
        }
    }

    protected String toString(FacesContext context, UIComponent component, Object value) {
        Converter converter;
        if (component instanceof ValueHolder && (converter = ((ValueHolder)component).getConverter()) != null) {
            String result = converter.getAsString(context, component, value);
            return result;
        }
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    public String toString() {
        return "HtmlOutputFormatRenderer[]";
    }
}

