/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.lifecycle;

import com.caucho.jsf.application.ApplicationImpl;
import com.caucho.util.Alarm;
import com.caucho.util.DisplayableException;
import com.caucho.util.Html;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

public class LifecycleImpl
extends Lifecycle {
    private static final L10N L = new L10N(LifecycleImpl.class);
    private static final Logger log = Logger.getLogger(LifecycleImpl.class.getName());
    private ArrayList<PhaseListener> _phaseList = new ArrayList();
    private PhaseListener[] _phaseListeners = new PhaseListener[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhaseListener(PhaseListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ArrayList<PhaseListener> arrayList = this._phaseList;
        synchronized (arrayList) {
            this._phaseList.add(listener);
            this._phaseListeners = new PhaseListener[this._phaseList.size()];
            this._phaseList.toArray(this._phaseListeners);
        }
    }

    public PhaseListener[] getPhaseListeners() {
        return this._phaseListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePhaseListener(PhaseListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ArrayList<PhaseListener> arrayList = this._phaseList;
        synchronized (arrayList) {
            this._phaseList.remove(listener);
            this._phaseListeners = new PhaseListener[this._phaseList.size()];
            this._phaseList.toArray(this._phaseListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FacesContext context) throws FacesException {
        boolean isFiner = log.isLoggable(Level.FINER);
        if (context.getResponseComplete() || context.getRenderResponse()) {
            return;
        }
        this.beforePhase(context, PhaseId.RESTORE_VIEW);
        try {
            if (isFiner) {
                log.finer("JSF[] before restore view");
            }
            this.restoreView(context);
            Object var4_3 = null;
            this.afterPhase(context, PhaseId.RESTORE_VIEW);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterPhase(context, PhaseId.RESTORE_VIEW);
            throw throwable;
        }
        if (context.getResponseComplete() || context.getRenderResponse()) {
            return;
        }
        UIViewRoot viewRoot = context.getViewRoot();
        this.beforePhase(context, PhaseId.APPLY_REQUEST_VALUES);
        try {
            try {
                if (isFiner) {
                    log.finer(context.getViewRoot() + " before process decodes");
                }
                viewRoot.processDecodes(context);
            }
            catch (RuntimeException e) {
                log.log(Level.WARNING, e.toString(), e);
                Object var6_10 = null;
                this.afterPhase(context, PhaseId.APPLY_REQUEST_VALUES);
            }
            Object var6_9 = null;
            this.afterPhase(context, PhaseId.APPLY_REQUEST_VALUES);
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.afterPhase(context, PhaseId.APPLY_REQUEST_VALUES);
            throw throwable;
        }
        if (context.getResponseComplete() || context.getRenderResponse()) {
            return;
        }
        this.beforePhase(context, PhaseId.PROCESS_VALIDATIONS);
        try {
            if (isFiner) {
                log.finer(context.getViewRoot() + " before process validators");
            }
            viewRoot.processValidators(context);
            Object var8_13 = null;
            this.afterPhase(context, PhaseId.PROCESS_VALIDATIONS);
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            this.afterPhase(context, PhaseId.PROCESS_VALIDATIONS);
            throw throwable;
        }
        if (context.getResponseComplete() || context.getRenderResponse()) {
            return;
        }
        this.beforePhase(context, PhaseId.UPDATE_MODEL_VALUES);
        try {
            try {
                if (isFiner) {
                    log.finer(context.getViewRoot() + " before process updates");
                }
                viewRoot.processUpdates(context);
            }
            catch (RuntimeException e) {
                if (this.sendError(context, "processUpdates", e)) {
                    Object var10_17 = null;
                    this.afterPhase(context, PhaseId.UPDATE_MODEL_VALUES);
                    return;
                }
                Object var10_18 = null;
                this.afterPhase(context, PhaseId.UPDATE_MODEL_VALUES);
            }
            Object var10_16 = null;
            this.afterPhase(context, PhaseId.UPDATE_MODEL_VALUES);
        }
        catch (Throwable throwable) {
            Object var10_19 = null;
            this.afterPhase(context, PhaseId.UPDATE_MODEL_VALUES);
            throw throwable;
        }
        if (context.getResponseComplete() || context.getRenderResponse()) {
            return;
        }
        this.beforePhase(context, PhaseId.INVOKE_APPLICATION);
        try {
            if (isFiner) {
                log.finer(context.getViewRoot() + " before process application");
            }
            viewRoot.processApplication(context);
            Object var12_21 = null;
            this.afterPhase(context, PhaseId.INVOKE_APPLICATION);
        }
        catch (Throwable throwable) {
            Object var12_22 = null;
            this.afterPhase(context, PhaseId.INVOKE_APPLICATION);
            throw throwable;
        }
    }

    private void restoreView(FacesContext context) throws FacesException {
        Application app = context.getApplication();
        if (app instanceof ApplicationImpl) {
            ((ApplicationImpl)app).initRequest();
        }
        ViewHandler view = app.getViewHandler();
        view.initView(context);
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot != null) {
            ExternalContext extContext = context.getExternalContext();
            viewRoot.setLocale(extContext.getRequestLocale());
            this.doSetBindings(context.getELContext(), (UIComponent)viewRoot);
            return;
        }
        String viewId = this.calculateViewId(context);
        String renderKitId = view.calculateRenderKitId(context);
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderKitFactory.getRenderKit(context, renderKitId);
        ResponseStateManager stateManager = renderKit.getResponseStateManager();
        if (stateManager.isPostback(context)) {
            viewRoot = view.restoreView(context, viewId);
            if (viewRoot != null) {
                this.doSetBindings(context.getELContext(), (UIComponent)viewRoot);
            } else {
                context.renderResponse();
                viewRoot = view.createView(context, viewId);
                context.setViewRoot(viewRoot);
            }
            context.setViewRoot(viewRoot);
        } else {
            context.renderResponse();
            viewRoot = view.createView(context, viewId);
            context.setViewRoot(viewRoot);
        }
    }

    private void doSetBindings(ELContext elContext, UIComponent component) {
        if (component == null) {
            return;
        }
        ValueExpression binding = component.getValueExpression("binding");
        if (binding != null) {
            binding.setValue(elContext, (Object)component);
        }
        Iterator iter = component.getFacetsAndChildren();
        while (iter.hasNext()) {
            this.doSetBindings(elContext, (UIComponent)iter.next());
        }
    }

    private String calculateViewId(FacesContext context) {
        Map map = context.getExternalContext().getRequestMap();
        String viewId = (String)map.get("javax.servlet.include.path_info");
        if (viewId == null) {
            viewId = context.getExternalContext().getRequestPathInfo();
        }
        if (viewId == null) {
            viewId = (String)map.get("javax.servlet.include.servlet_path");
        }
        if (viewId == null) {
            viewId = context.getExternalContext().getRequestServletPath();
        }
        return viewId;
    }

    public void render(FacesContext context) throws FacesException {
        if (context.getResponseComplete()) {
            return;
        }
        Application app = context.getApplication();
        ViewHandler view = app.getViewHandler();
        this.beforePhase(context, PhaseId.RENDER_RESPONSE);
        try {
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.finer(context.getViewRoot() + " before render view");
                }
                view.renderView(context, context.getViewRoot());
            }
            catch (IOException e) {
                if (this.sendError(context, "renderView", e)) {
                    Object var6_5 = null;
                    this.afterPhase(context, PhaseId.RENDER_RESPONSE);
                    this.logMessages(context);
                    return;
                }
                throw new FacesException((Throwable)e);
            }
            catch (RuntimeException e) {
                if (this.sendError(context, "renderView", e)) {
                    Object var6_6 = null;
                    this.afterPhase(context, PhaseId.RENDER_RESPONSE);
                    this.logMessages(context);
                    return;
                }
                throw e;
            }
            Object var6_4 = null;
            this.afterPhase(context, PhaseId.RENDER_RESPONSE);
            this.logMessages(context);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.afterPhase(context, PhaseId.RENDER_RESPONSE);
            this.logMessages(context);
            throw throwable;
        }
    }

    private void beforePhase(FacesContext context, PhaseId phase) {
        for (int i = 0; i < this._phaseListeners.length; ++i) {
            PhaseListener listener = this._phaseListeners[i];
            PhaseId id = listener.getPhaseId();
            if (id != phase && id != PhaseId.ANY_PHASE) continue;
            PhaseEvent event = new PhaseEvent(context, phase, (Lifecycle)this);
            listener.beforePhase(event);
        }
    }

    private void afterPhase(FacesContext context, PhaseId phase) {
        for (int i = this._phaseListeners.length - 1; i >= 0; --i) {
            PhaseListener listener = this._phaseListeners[i];
            PhaseId id = listener.getPhaseId();
            if (phase != id && id != PhaseId.ANY_PHASE) continue;
            PhaseEvent event = new PhaseEvent(context, phase, (Lifecycle)this);
            listener.afterPhase(event);
        }
    }

    private void logMessages(FacesContext context) {
        UIViewRoot root = context.getViewRoot();
        String viewId = "";
        if (root != null) {
            viewId = root.getViewId();
        }
        Iterator iter = context.getMessages();
        while (iter != null && iter.hasNext()) {
            FacesMessage msg = (FacesMessage)iter.next();
            if (!log.isLoggable(Level.FINE)) continue;
            if (msg.getDetail() != null) {
                log.fine(viewId + " [ " + msg.getSeverity() + "] " + msg.getSummary() + " " + msg.getDetail());
                continue;
            }
            log.fine(viewId + " [ " + msg.getSeverity() + "] " + msg.getSummary());
        }
    }

    private boolean sendError(FacesContext context, String lifecycle, Exception e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (cause instanceof DisplayableException) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new FacesException((Throwable)e);
            }
            if (cause instanceof ServletException) {
                throw new FacesException((Throwable)e);
            }
            if (!(cause instanceof JspException)) continue;
            throw new FacesException((Throwable)e);
        }
        ExternalContext extContext = context.getExternalContext();
        Object response = extContext.getResponse();
        if (!(response instanceof HttpServletResponse)) {
            context.renderResponse();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        log.log(Level.WARNING, e.toString(), e);
        HttpServletResponse res = (HttpServletResponse)response;
        try {
            context.renderResponse();
            context.responseComplete();
            res.setStatus(500, "JSF Exception");
            res.setContentType("text/html");
            PrintWriter out = res.getWriter();
            out.println("<body>");
            out.println("<h3>JSF exception detected in " + lifecycle + " phase</h3>");
            String msg = e.getMessage();
            out.println("<span style='color:red;font:bold'>" + Html.escapeHtml(msg) + "</span><br/>");
            out.println("<h3>Context: " + context.getViewRoot() + "</h3>");
            out.println("<code><pre>");
            String errorId = null;
            if (e instanceof FacesException && msg.startsWith("id=")) {
                int p = msg.indexOf(32);
                errorId = msg.substring(3, p);
            }
            this.printComponentTree(out, errorId, context, (UIComponent)context.getViewRoot(), 0);
            out.println("</pre></code>");
            if (!Alarm.isTest()) {
                out.println("<h3>Stack Trace</h3>");
                out.println("<pre>");
                if (e.getCause() != null) {
                    e.getCause().printStackTrace(out);
                } else {
                    e.printStackTrace(out);
                }
                out.println("</pre>");
            }
            out.println("</body>");
            Application app = context.getApplication();
            ViewHandler view = app.getViewHandler();
            UIViewRoot viewRoot = context.getViewRoot();
            viewRoot = view.createView(context, viewRoot.getViewId());
            context.setViewRoot(viewRoot);
            return true;
        }
        catch (IOException e1) {
            throw new RuntimeException(e);
        }
    }

    private void printComponentTree(PrintWriter out, String errorId, FacesContext context, UIComponent comp, int depth) {
        int i;
        for (int i2 = 0; i2 < depth; ++i2) {
            out.print(' ');
        }
        boolean isError = false;
        if (errorId != null && errorId.equals(comp.getClientId(context))) {
            isError = true;
            out.print("<span style='color:red'>");
        }
        out.print("&lt;" + comp.getClass().getSimpleName());
        if (comp.getId() != null) {
            out.print(" id=\"" + comp.getId() + "\"");
        }
        for (Method method : comp.getClass().getMethods()) {
            String name;
            if (!method.getName().startsWith("get") && !method.getName().startsWith("is") || method.getParameterTypes().length != 0) continue;
            if (method.getName().startsWith("get")) {
                name = method.getName().substring(3);
            } else {
                if (!method.getName().startsWith("is")) continue;
                name = method.getName().substring(2);
            }
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            ValueExpression expr = comp.getValueExpression(name);
            Class<?> type = method.getReturnType();
            if (expr != null) {
                out.print(" " + name + "=\"" + expr.getExpressionString() + "\"");
                continue;
            }
            if (method.getDeclaringClass().equals(UIComponent.class) || method.getDeclaringClass().equals(UIComponentBase.class) || name.equals("family") || !String.class.equals(type)) continue;
            try {
                Object value = method.invoke((Object)comp, new Object[0]);
                if (value == null) continue;
                out.print(" " + name + "=\"" + value + "\"");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int facetCount = comp.getFacetCount();
        int childCount = comp.getChildCount();
        if (facetCount == 0 && childCount == 0) {
            out.print("/>");
            if (isError) {
                out.print("</span>");
            }
            out.println();
            return;
        }
        out.println(">");
        if (isError) {
            out.print("</span>");
        }
        for (i = 0; i < childCount; ++i) {
            this.printComponentTree(out, errorId, context, (UIComponent)comp.getChildren().get(i), depth + 1);
        }
        for (i = 0; i < depth; ++i) {
            out.print(' ');
        }
        if (isError) {
            out.print("<span style='color:red'>");
        }
        out.println("&lt;/" + comp.getClass().getSimpleName() + ">");
        if (isError) {
            out.print("</span>");
        }
    }

    public String toString() {
        return "DefaultLifecycleImpl[]";
    }
}

