/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.taglib;

import com.caucho.jsp.BundleManager;
import com.caucho.util.L10N;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import javax.servlet.jsp.tagext.TagSupport;

public class LoadBundleTag
extends TagSupport {
    private static final L10N L = new L10N(LoadBundleTag.class);
    private static final Logger log = Logger.getLogger(LoadBundleTag.class.getName());
    private String _var;
    private ValueExpression _basename;

    public void setVar(String var) {
        this._var = var;
    }

    public void setBasename(ValueExpression basename) {
        this._basename = basename;
    }

    public int doStartTag() throws JspException {
        FacesContext context = FacesContext.getCurrentInstance();
        String basename = (String)this._basename.getValue(context.getELContext());
        Locale locale = context.getViewRoot().getLocale();
        BundleManager bundleManager = BundleManager.create();
        LocalizationContext lc = null;
        if (locale != null) {
            lc = bundleManager.getBundle(basename, locale);
        }
        if (lc == null) {
            lc = bundleManager.getBundle(basename);
        }
        if (lc == null) {
            throw new JspException(L.l("'{0}' is an unknown ResourceBundle basename.", basename));
        }
        ResourceBundle bundle = lc.getResourceBundle();
        this.pageContext.getRequest().setAttribute(this._var, (Object)new BundleMap(bundle));
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EntryIterator
    implements Iterator<Map.Entry<String, String>> {
        private ResourceBundle _bundle;
        private ArrayList<String> _keys;
        private Entry _entry = new Entry();
        private int _index;

        EntryIterator(ResourceBundle bundle, ArrayList<String> keys) {
            this._bundle = bundle;
            this._keys = keys;
        }

        @Override
        public boolean hasNext() {
            return this._index < this._keys.size();
        }

        @Override
        public Map.Entry<String, String> next() {
            if (this._index < this._keys.size()) {
                ++this._index;
                return this._entry;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Entry
        implements Map.Entry<String, String> {
            Entry() {
            }

            @Override
            public String getKey() {
                return (String)EntryIterator.this._keys.get(EntryIterator.this._index - 1);
            }

            public String setKey(String key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getValue() {
                return EntryIterator.this._bundle.getString(this.getKey());
            }

            @Override
            public String setValue(String key) {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BundleEntrySet
    extends AbstractSet<Map.Entry<String, String>> {
        private ResourceBundle _bundle;
        private ArrayList<String> _keys = new ArrayList();

        BundleEntrySet(ResourceBundle bundle) {
            this._bundle = bundle;
            Enumeration<String> e = bundle.getKeys();
            while (e.hasMoreElements()) {
                this._keys.add(e.nextElement());
            }
        }

        @Override
        public int size() {
            return this._keys.size();
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new EntryIterator(this._bundle, this._keys);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BundleMap
    extends AbstractMap<String, String> {
        private ResourceBundle _bundle;
        private BundleEntrySet _entrySet;

        BundleMap(ResourceBundle bundle) {
            this._bundle = bundle;
        }

        @Override
        public String get(Object key) {
            try {
                String value = this._bundle.getString(String.valueOf(key));
                if (value != null) {
                    return value;
                }
                return "???" + key + "???";
            }
            catch (MissingResourceException e) {
                log.log(Level.FINER, e.toString(), e);
                return "???" + key + "???";
            }
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            if (this._entrySet == null) {
                this._entrySet = new BundleEntrySet(this._bundle);
            }
            return this._entrySet;
        }
    }
}

