/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.JspManager;
import com.caucho.jsp.Page;
import com.caucho.jsp.PageManager;
import com.caucho.jsp.QJspFactory;
import com.caucho.jsp.XslManager;
import com.caucho.jsp.XtpPage;
import com.caucho.server.webapp.WebApp;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.jsp.JspFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtpManager
extends PageManager {
    private static final Logger log = Logger.getLogger(XtpManager.class.getName());
    private boolean _strictXml;
    private boolean _toLower = true;
    private boolean _entitiesAsText = true;
    private XslManager _xslManager;
    private JspManager _jspManager;
    private String _defaultStylesheet = "default.xsl";

    XtpManager() {
    }

    @Override
    void initWebApp(WebApp context) {
        super.initWebApp(context);
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory((JspFactory)new QJspFactory());
        }
        this._xslManager = new XslManager(context);
        this._jspManager = new JspManager();
        this._jspManager.initWebApp(context);
    }

    public String getDefaultStylesheet() {
        return this._defaultStylesheet;
    }

    public void setDefaultStylesheet(String stylesheet) {
        this._defaultStylesheet = stylesheet;
    }

    public void setStrictXml(boolean strictXml) {
        this._strictXml = strictXml;
    }

    public void setStrictXsl(boolean strictXsl) {
        this._xslManager.setStrictXsl(strictXsl);
    }

    public void setToLower(boolean toLower) {
        this._toLower = toLower;
    }

    public void setEntitiesAsText(boolean entitiesAsText) {
        this._entitiesAsText = entitiesAsText;
    }

    @Override
    Page createPage(Path path, String uri, String className, ServletConfig config, ArrayList<PersistentDependency> dependList) throws Exception {
        if (path == null || !path.canRead() || path.isDirectory()) {
            return null;
        }
        XtpPage xtpPage = new XtpPage(path, uri, className, this._webApp, this._xslManager, this._strictXml);
        xtpPage.setManager(this._jspManager);
        xtpPage.setHtmlToLower(this._toLower);
        return xtpPage;
    }
}

