/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Signature;
import com.caucho.util.L10N;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PostConstruct;
import javax.servlet.jsp.tagext.FunctionInfo;

public class TldFunction {
    private static L10N L = new L10N(TldFunction.class);
    private String _name;
    private Class _functionClass;
    private Signature _signature;
    private String _displayName;
    private String _description;
    private String _example;
    private Method _method;

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setFunctionClass(Class functionClass) {
        this._functionClass = functionClass;
    }

    public Class getFunctionClass() {
        return this._functionClass;
    }

    public void setFunctionSignature(Signature signature) {
        this._signature = signature;
    }

    public Signature getFunctionSignature() {
        return this._signature;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setExample(String example) {
        this._example = example;
    }

    public String getExample() {
        return this._example;
    }

    public Method getMethod() {
        return this._method;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._name == null) {
            throw new ConfigException(L.l("function needs <name>"));
        }
        if (this._signature == null) {
            throw new ConfigException(L.l("function requires <signature>"));
        }
        Method[] methods = this._functionClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isAbstract(method.getModifiers()) || !this._signature.matches(method)) continue;
            this._method = method;
            if (!Modifier.isPublic(this._method.getModifiers())) {
                throw new ConfigException(L.l("function `{0}' must be public", this._method));
            }
            if (!Modifier.isStatic(this._method.getModifiers())) {
                throw new ConfigException(L.l("function `{0}' must be static", this._method));
            }
            if (Modifier.isAbstract(this._method.getModifiers())) {
                throw new ConfigException(L.l("function `{0}' must be concrete", this._method));
            }
            return;
        }
        throw new ConfigException(L.l("No public method in `{0}' matches the signature `{1}'", (Object)this._functionClass.getName(), this._signature.getSignature()));
    }

    public FunctionInfo toFunctionInfo() {
        return new FunctionInfo(this._name, this._functionClass.getName(), this._signature.getSignature());
    }

    public String toString() {
        return "TldFunction[" + this._signature.getSignature() + "]";
    }
}

