/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.cfg;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.DependencyBean;
import com.caucho.config.types.Icon;
import com.caucho.jsp.JspLineParseException;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.cfg.TldAttribute;
import com.caucho.jsp.cfg.TldFragmentAttribute;
import com.caucho.jsp.cfg.TldTaglib;
import com.caucho.jsp.cfg.TldVariable;
import com.caucho.util.L10N;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.PersistentDependency;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.SimpleTag;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TldTag
implements DependencyBean {
    private static final L10N L = new L10N(TldTag.class);
    private static final Logger log = Logger.getLogger(TldTag.class.getName());
    private TldTaglib _taglib;
    private String _name;
    private String _tagClassName;
    private String _teiClassName;
    private String _bodyContent;
    private String _displayName;
    private String _info;
    private String _smallIcon;
    private String _largeIcon;
    private String _description;
    private ArrayList<TagVariableInfo> _variableList = new ArrayList();
    private ArrayList<TagAttributeInfo> _attributeList = new ArrayList();
    private ArrayList<TldFragmentAttribute> _fragmentAttributeList = new ArrayList();
    private boolean _dynamicAttributes;
    private String _dynamicAttributeName;
    private String _example;
    private String _configLocation;
    private JspParseException _configException;
    private ArrayList<Dependency> _dependencyList = new ArrayList();
    private TldTag _baseTag;

    TldTag(TldTaglib taglib) {
        this._taglib = taglib;
    }

    public TldTag() {
    }

    public void setConfigLocation(String filename, int line) {
        this._configLocation = filename + ":" + line + ": ";
    }

    @Override
    public void addDependency(PersistentDependency dependency) {
        this._dependencyList.add(dependency);
    }

    public ArrayList<Dependency> getDependencyList() {
        return this._dependencyList;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setIcon(Icon icon) {
        if (icon != null) {
            this._smallIcon = icon.getSmallIcon();
            this._largeIcon = icon.getLargeIcon();
        }
    }

    public void setTagClass(String tagClassName) throws ConfigException {
        this._tagClassName = tagClassName;
        Class<?> tagClass = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            tagClass = Class.forName(tagClassName, false, loader);
            Config.checkCanInstantiate(tagClass);
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            log.warning(this._configLocation + e);
            if (this._configException == null) {
                this._configException = new JspLineParseException(this._configLocation + e);
            }
            return;
        }
        if (!Tag.class.isAssignableFrom(tagClass) && !SimpleTag.class.isAssignableFrom(tagClass)) {
            throw new ConfigException(L.l("{0} must either implement Tag or SimpleTag.", tagClass.getName()));
        }
    }

    public void setTagclass(String tagClassName) throws ConfigException, InstantiationException, IllegalAccessException {
        this.setTagClass(tagClassName);
    }

    public Class getTagClass() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return Class.forName(this._tagClassName, false, loader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTagClassName() {
        return this._tagClassName;
    }

    public void setTeiClass(String teiClassName) throws ConfigException {
        this._teiClassName = teiClassName;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> teiClass = Class.forName(teiClassName, false, loader);
            Config.validate(teiClass, TagExtraInfo.class);
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            log.warning(this._configLocation + e);
            if (this._configException == null) {
                this._configException = new JspParseException(this._configLocation + e);
            }
            return;
        }
    }

    public void setTeiclass(String teiClassName) throws ConfigException {
        this.setTeiClass(teiClassName);
    }

    public String getTeiClassName() {
        return this._teiClassName;
    }

    public TagExtraInfo getTagExtraInfo() {
        try {
            if (this._teiClassName == null) {
                return null;
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> teiClass = Class.forName(this._teiClassName, false, loader);
            return (TagExtraInfo)teiClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setBodyContent(String bodyContent) {
        this._bodyContent = bodyContent;
    }

    public void setBodycontent(String bodyContent) {
        this.setBodyContent(bodyContent);
    }

    public String getBodyContent() {
        return this._bodyContent;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setInfo(String info) {
        this._info = info;
    }

    public String getInfo() {
        return this._info;
    }

    public void setSmallIcon(String smallIcon) {
        this._smallIcon = smallIcon;
    }

    public String getSmallIcon() {
        return this._smallIcon;
    }

    public void setLargeIcon(String largeIcon) {
        this._largeIcon = largeIcon;
    }

    public String getLargeIcon() {
        return this._largeIcon;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void addVariable(TldVariable variable) throws ConfigException {
        int scope;
        String scopeName = variable.getScope();
        if (scopeName == null) {
            scope = 0;
        } else if (scopeName.equals("NESTED")) {
            scope = 0;
        } else if (scopeName.equals("AT_BEGIN")) {
            scope = 1;
        } else if (scopeName.equals("AT_END")) {
            scope = 2;
        } else {
            throw new ConfigException(L.l("{0} expects a valid scope at `{1}'", (Object)variable.getNameGiven(), scopeName));
        }
        TagVariableInfo varInfo = new TagVariableInfo(variable.getNameGiven(), variable.getNameFromAttribute(), variable.getVariableClass(), variable.getDeclare(), scope);
        this._variableList.add(varInfo);
    }

    public ArrayList<TagVariableInfo> getVariableList() {
        return this._variableList;
    }

    public TagVariableInfo[] getVariables() {
        TagVariableInfo[] variables = new TagVariableInfo[this._variableList.size()];
        return this._variableList.toArray(variables);
    }

    public void addAttribute(TldAttribute attribute) {
        if (attribute.getDeferredValue() != null && this._taglib != null && this._taglib.getJspVersion() != null && this._taglib.getJspVersion().compareTo("2.1") < 0) {
            throw new ConfigException(L.l("<deferred-value> for tag '{0}' requires a taglib with jsp-version 2.1 or later", this.getName()));
        }
        Class type = attribute.getType();
        TagAttributeInfo attrInfo = new TagAttributeInfo(attribute.getName(), attribute.getRequired(), type == null ? null : type.getName(), attribute.getRtexprvalue(), attribute.isFragment(), attribute.getDescription(), attribute.getDeferredValue() != null, attribute.getDeferredMethod() != null, attribute.getExpectedType(), attribute.getDeferredMethodSignature());
        this._attributeList.add(attrInfo);
    }

    public ArrayList getAttributeList() {
        return this._attributeList;
    }

    public TagAttributeInfo[] getAttributes() {
        TagAttributeInfo[] attributes = new TagAttributeInfo[this._attributeList.size()];
        return this._attributeList.toArray(attributes);
    }

    public void addFragmentAttribute(TldFragmentAttribute attribute) {
        this._fragmentAttributeList.add(attribute);
    }

    public ArrayList getFragmentAttributes() {
        return this._fragmentAttributeList;
    }

    public void setExample(String example) {
        this._example = example;
    }

    public boolean getDynamicAttributes() {
        return this._dynamicAttributes;
    }

    public void setDynamicAttributes(boolean dynamicAttributes) {
        this._dynamicAttributes = dynamicAttributes;
    }

    public String getDynamicAttributeName() {
        return this._dynamicAttributeName;
    }

    public void setDynamicAttributeName(String name) {
        this._dynamicAttributeName = name;
    }

    public String getExample() {
        return this._example;
    }

    public void validate() throws JspParseException {
        if (this._configException != null) {
            throw this._configException;
        }
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TldTag)) {
            return false;
        }
        TldTag tag = (TldTag)o;
        return this._name.equals(tag._name);
    }

    public void setBaseTag(TldTag tag) {
        if (tag == this) {
            throw new IllegalStateException();
        }
        this._baseTag = tag;
    }

    public TldTag getBaseTag() {
        return this._baseTag;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getName() + "]";
    }
}

