/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.el;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.PageContext;

public class PageContextAttributeMap
extends AbstractMap {
    private PageContext _pageContext;
    private int _scope;
    private EntrySet _entrySet;

    public PageContextAttributeMap(PageContext pageContext, int scope) {
        this._pageContext = pageContext;
        this._scope = scope;
    }

    public Object get(Object key) {
        return this._pageContext.getAttribute((String)key, this._scope);
    }

    public Object put(Object key, Object value) {
        this._pageContext.setAttribute((String)key, value, this._scope);
        return null;
    }

    public Set entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new EntrySet();
        }
        return this._entrySet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean isFirst = true;
        for (Map.Entry entry : this.entrySet()) {
            if (!isFirst) {
                sb.append(", ");
            }
            isFirst = false;
            sb.append("{");
            sb.append(entry.getKey());
            sb.append(", ");
            sb.append(entry.getValue());
            sb.append("}");
        }
        sb.append("]");
        return sb.toString();
    }

    public class EntryIterator
    implements Iterator,
    Map.Entry {
        Enumeration _e;
        String _name;
        Object _value;

        EntryIterator() {
            this._e = PageContextAttributeMap.this._pageContext.getAttributeNamesInScope(PageContextAttributeMap.this._scope);
        }

        public boolean hasNext() {
            return this._e.hasMoreElements();
        }

        public Object next() {
            this._name = (String)this._e.nextElement();
            this._value = PageContextAttributeMap.this._pageContext.getAttribute(this._name, PageContextAttributeMap.this._scope);
            return this;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object getKey() {
            return this._name;
        }

        public Object getValue() {
            return this._value;
        }

        public Object setValue(Object value) {
            PageContextAttributeMap.this._pageContext.setAttribute(this._name, value, PageContextAttributeMap.this._scope);
            Object oldValue = this._value;
            this._value = value;
            return oldValue;
        }

        public int hashCode() {
            return this._name.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntryIterator)) {
                return false;
            }
            EntryIterator entry = (EntryIterator)obj;
            return this._name.equals(entry._name) && (this._value == null && entry._value == null || this._value != null && this._value.equals(entry._value));
        }
    }

    public class EntrySet
    extends AbstractSet {
        public int size() {
            Enumeration e = PageContextAttributeMap.this._pageContext.getAttributeNamesInScope(PageContextAttributeMap.this._scope);
            int i = 0;
            while (e.hasMoreElements()) {
                e.nextElement();
                ++i;
            }
            return i;
        }

        public Iterator iterator() {
            return new EntryIterator();
        }
    }
}

