/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.VersionFactory;
import com.caucho.config.types.Signature;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.ParseTagManager;
import com.caucho.jsp.TempTagInfo;
import com.caucho.jsp.cfg.TldAttribute;
import com.caucho.jsp.cfg.TldTag;
import com.caucho.jsp.cfg.TldVariable;
import com.caucho.jsp.java.JavaJspGenerator;
import com.caucho.jsp.java.JspDeclaration;
import com.caucho.jsp.java.JspJavaWriter;
import com.caucho.jsp.java.JspNode;
import com.caucho.jsp.java.TagInfoExt;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTagGenerator
extends JavaJspGenerator {
    static final L10N L = new L10N(JavaTagGenerator.class);
    static final Logger log = Logger.getLogger(JavaTagGenerator.class.getName());
    private static HashSet<String> _reserved = new HashSet();
    private String _description = null;
    private String _displayName = null;
    private String _smallIcon = null;
    private String _largeIcon = null;
    private String _example = null;
    private String _bodyContent = null;
    private String _dynamicAttributes = null;
    private ArrayList<TldAttribute> _attributes = new ArrayList();
    private ArrayList<TldVariable> _variables = new ArrayList();
    private TempTagInfo _tagInfo = new TempTagInfo();

    public JavaTagGenerator(ParseTagManager tagManager) {
        super(tagManager);
        this.setOmitXmlDeclaration(true);
    }

    @Override
    public void init() {
        super.init();
        this.setOmitXmlDeclaration(true);
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setSmallIcon(String smallIcon) {
        this._smallIcon = smallIcon;
    }

    public String getSmallIcon() {
        return this._smallIcon;
    }

    public void setLargeIcon(String largeIcon) {
        this._largeIcon = largeIcon;
    }

    public String getLargeIcon() {
        return this._largeIcon;
    }

    public void setExample(String example) {
        this._example = example;
    }

    public String getExample() {
        return this._example;
    }

    public void setBodyContent(String bodyContent) {
        this._bodyContent = bodyContent;
    }

    public String getBodyContent() {
        return this._bodyContent;
    }

    public void setDynamicAttributes(String dynamicAttributes) {
        this._dynamicAttributes = dynamicAttributes;
    }

    public String getDynamicAttributes() {
        return this._dynamicAttributes;
    }

    public void addAttribute(TldAttribute attribute) {
        this._attributes.add(attribute);
    }

    public ArrayList<TldAttribute> getAttributes() {
        return this._attributes;
    }

    public TldAttribute findAttribute(String name) {
        for (int i = 0; i < this._attributes.size(); ++i) {
            TldAttribute attr = this._attributes.get(i);
            if (!name.equals(attr.getName())) continue;
            return attr;
        }
        return null;
    }

    public void addVariable(TldVariable var) {
        this._variables.add(var);
    }

    public TldVariable findVariable(String name) {
        for (int i = 0; i < this._variables.size(); ++i) {
            TldVariable var = this._variables.get(i);
            if (!name.equals(var.getNameGiven()) && !name.equals(var.getAlias())) continue;
            return var;
        }
        return null;
    }

    public TldVariable findNameFromAttributeVariable(String name) {
        for (int i = 0; i < this._variables.size(); ++i) {
            TldVariable var = this._variables.get(i);
            if (!name.equals(var.getNameFromAttribute())) continue;
            return var;
        }
        return null;
    }

    public ArrayList<TldVariable> getVariables() {
        return this._variables;
    }

    @Override
    public boolean isTag() {
        return true;
    }

    @Override
    boolean isXml() {
        return this._parseState.isXml();
    }

    @Override
    protected void generate(JspJavaWriter out) throws Exception {
        out.setLineMap(this._lineMap);
        this.generateClassHeader(out);
        this.generateAttributes(out);
        if (this._dynamicAttributes != null) {
            this.generateDynamicAttributes(out);
        }
        this.generateDoTag(out, this._rootNode);
        this.generateDoTagImpl(out, this._rootNode);
        this.generateTagInfo(out);
        this.generateClassFooter(out);
    }

    protected boolean isStaticDoTag() {
        return false;
    }

    @Override
    protected void generateClassHeader(JspJavaWriter out) throws IOException, JspParseException {
        int i;
        out.println("/*");
        out.println(" * JSP-Tag generated by " + VersionFactory.getFullVersion());
        out.println(" */");
        out.println();
        if (this._pkg != null && !this._pkg.equals("")) {
            out.println("package " + this._pkg + ";");
        }
        out.println("import javax.servlet.*;");
        out.println("import javax.servlet.jsp.*;");
        out.println("import javax.servlet.http.*;");
        this.fillSingleTaglibImports();
        ArrayList<String> imports = this._parseState.getImportList();
        for (i = 0; i < imports.size(); ++i) {
            String name = imports.get(i);
            out.print("import ");
            out.print(name);
            out.println(";");
        }
        this._parseState.addImport("javax.servlet.*");
        this._parseState.addImport("javax.servlet.jsp.*");
        this._parseState.addImport("javax.servlet.http.*");
        this._parseState.addImport("java.lang.*");
        out.println();
        out.print("public class ");
        out.print(this._className);
        if (this.hasScripting()) {
            out.print(" extends com.caucho.jsp.java.JspTagSupport");
        } else {
            out.print(" extends com.caucho.jsp.java.JspTagFileSupport");
        }
        if (this._dynamicAttributes != null) {
            out.print(" implements javax.servlet.jsp.tagext.DynamicAttributes");
        }
        out.println(" {");
        out.pushDepth();
        if (this._rootNode != null && this._rootNode.hasCustomTag()) {
            out.println("public static final boolean _caucho_hasCustomTag = true;");
        } else {
            out.println("public static final boolean _caucho_hasCustomTag = false;");
        }
        out.print("static ");
        out.println("private final java.util.HashMap<String,java.lang.reflect.Method> _jsp_functionMap = new java.util.HashMap<String,java.lang.reflect.Method>();");
        out.println("private static com.caucho.jsp.PageManager _jsp_pageManager;");
        out.println("private boolean _caucho_isDead;");
        out.println("private boolean _caucho_isNotModified;");
        for (i = 0; i < this._declarations.size(); ++i) {
            JspDeclaration decl = (JspDeclaration)this._declarations.get(i);
            out.println();
            decl.generateDeclaration(out);
        }
    }

    protected void generateAttributes(JspJavaWriter out) throws IOException, JspParseException {
        for (int i = 0; i < this._attributes.size(); ++i) {
            TldAttribute attr = this._attributes.get(i);
            String name = attr.getName();
            char ch = name.charAt(0);
            String upperName = Character.toUpperCase(ch) + name.substring(1);
            Class<String> cl = attr.getType();
            if (cl == null) {
                cl = String.class;
            }
            String type = cl.getName();
            String isSetName = "_jsp_" + name + "_isSet";
            String fieldName = this.toFieldName(name);
            out.println();
            out.print("private ");
            out.printClass(cl);
            out.println(" " + fieldName + ";");
            out.println("private boolean " + isSetName + ";");
            out.println();
            out.print("public void set" + upperName + "(");
            out.printClass(cl);
            out.println(" value)");
            out.println("{");
            out.pushDepth();
            out.println("this." + isSetName + " = true;");
            out.println("this." + fieldName + " = value;");
            out.popDepth();
            out.println("}");
        }
    }

    protected void generateDynamicAttributes(JspJavaWriter out) throws IOException, JspParseException {
        String dyn = this.toFieldName(this._dynamicAttributes);
        out.println();
        out.println("java.util.HashMap " + dyn + " = new java.util.HashMap();");
        out.println();
        out.println("public void setDynamicAttribute(String uri, String localName, Object value)");
        out.println("  throws javax.servlet.jsp.JspException");
        out.println("{");
        out.println("  if (uri == null || \"\".equals(uri))");
        out.println("    " + dyn + ".put(localName, value);");
        out.println("}");
    }

    protected void generateDoTag(JspJavaWriter out, JspNode node) throws Exception {
        out.println();
        out.println("public void doTag()");
        out.println("  throws javax.servlet.jsp.JspException, java.io.IOException");
        out.println("{");
        out.pushDepth();
        out.println("javax.servlet.jsp.JspContext _jsp_parentContext = getJspContext();");
        out.println("com.caucho.jsp.PageContextWrapper pageContext = _jsp_pageManager.createPageContextWrapper(_jsp_parentContext);");
        out.println("setJspContext(pageContext);");
        out.println("com.caucho.jsp.PageContextWrapper jspContext = pageContext;");
        out.println("javax.el.ELContext _jsp_env = pageContext.getELContext();");
        out.println("javax.servlet.jsp.JspWriter out = pageContext.getOut();");
        out.println("try {");
        out.pushDepth();
        out.println("doTag(_jsp_parentContext, pageContext, out, null, this);");
        out.popDepth();
        out.println("} catch (Throwable e) {");
        out.println("  if (e instanceof java.io.IOException)");
        out.println("    throw (java.io.IOException) e;");
        out.println("  throw com.caucho.jsp.QJspException.createJspException(e);");
        out.println("}");
        if (this.hasScripting() && this._variables.size() > 0) {
            out.println("finally {");
            out.pushDepth();
            out.println("setJspContext(_jsp_parentContext);");
            out.println("_jsp_pageManager.freePageContextWrapper(pageContext);");
            out.popDepth();
            out.println("}");
        }
        out.popDepth();
        out.println("}");
    }

    protected void generateTagAttributes(JspJavaWriter out) throws IOException, JspParseException {
        for (int i = 0; i < this._attributes.size(); ++i) {
            TldAttribute attr = this._attributes.get(i);
            String name = attr.getName();
            char ch = name.charAt(0);
            String upperName = Character.toUpperCase(ch) + name.substring(1);
            Class<String> cl = attr.getType();
            if (cl == null) {
                cl = String.class;
            }
            String type = cl.getName();
            String isSetName = "_jsp_" + name + "_isSet";
            String fieldName = this.toFieldName(name);
            out.println("if (" + isSetName + ")");
            out.println("  pageContext.setAttribute(\"" + name + "\", " + JspNode.toELObject(fieldName, cl) + ");");
        }
        if (this._dynamicAttributes != null) {
            out.println("pageContext.setAttribute(\"" + this._dynamicAttributes + "\"," + this.toFieldName(this._dynamicAttributes) + ");");
        }
    }

    protected void generateDoTagImpl(JspJavaWriter out, JspNode node) throws Exception {
        out.println();
        out.println("public void doTag(javax.servlet.jsp.JspContext _jsp_parentContext,");
        out.println("                         com.caucho.jsp.PageContextWrapper pageContext,");
        out.println("                         javax.servlet.jsp.JspWriter out,");
        out.println("                         javax.servlet.jsp.tagext.JspFragment _jspBody,");
        out.println("                         javax.servlet.jsp.tagext.JspTag jsp_parent_tag)");
        out.println("  throws Throwable");
        out.println("{");
        out.pushDepth();
        out.println("javax.el.ELContext _jsp_env = pageContext.getELContext();");
        if (node.hasScripting()) {
            out.println("javax.servlet.http.HttpServletRequest request = (javax.servlet.http.HttpServletRequest) pageContext.getRequest();");
            out.println("javax.servlet.http.HttpServletResponse response = (javax.servlet.http.HttpServletResponse) pageContext.getResponse();");
            out.println("javax.servlet.http.HttpSession session = pageContext.getSession();");
            out.println("javax.servlet.ServletContext application = pageContext.getServletContext();");
            out.println("javax.servlet.ServletConfig config = pageContext.getServletConfig();");
            out.println("com.caucho.jsp.PageContextWrapper jspContext = pageContext;");
        }
        out.println("TagState _jsp_state = new TagState();");
        out.println("javax.servlet.jsp.tagext.JspTag _jsp_parent_tag = jsp_parent_tag;");
        this.generateTagAttributes(out);
        this.generatePrologue(out);
        node.generate(out);
        this.generateTagVariablesAtEnd(out);
        out.popDepth();
        out.println("}");
    }

    protected void generatePrologue(JspJavaWriter out) throws Exception {
        this._rootNode.generatePrologue(out);
        for (int i = 0; i < this._variables.size(); ++i) {
            TldVariable var = this._variables.get(i);
            if (var.getNameFromAttribute() != null) {
                out.print("String _jsp_var_from_attribute_" + i + " = (String) ");
                out.println("pageContext.getAttribute(\"" + var.getNameFromAttribute() + "\");");
            }
            if ("AT_END".equals(var.getScope())) continue;
            String srcName = var.getNameGiven();
            if (srcName == null) {
                srcName = var.getAlias();
            }
            String dstName = var.getNameGiven() != null ? "\"" + var.getNameGiven() + "\"" : "_jsp_var_from_attribute_" + i;
            if (!"NESTED".equals(var.getScope())) continue;
            out.print("Object _jsp_nested_var_" + i + " = ");
            out.println("_jsp_parentContext.getAttribute(" + dstName + ");");
        }
    }

    protected void generateTagVariablesAtEnd(JspJavaWriter out) throws IOException, JspParseException {
        for (int i = 0; i < this._variables.size(); ++i) {
            TldVariable var = this._variables.get(i);
            String srcName = var.getNameGiven();
            if (srcName == null) {
                srcName = var.getAlias();
            }
            String dstName = var.getNameGiven() != null ? "\"" + var.getNameGiven() + "\"" : "_jsp_var_from_attribute_" + i;
            if ("NESTED".equals(var.getScope())) {
                out.println("_jsp_parentContext.setAttribute(" + dstName + ", _jsp_nested_var_" + i + ");");
                continue;
            }
            out.print("_jsp_parentContext.setAttribute(" + dstName + ",");
            out.println("pageContext.getAttribute(\"" + srcName + "\"));");
        }
    }

    @Override
    public TagInfo generateTagInfo(String className, TagLibraryInfo taglib) {
        int i;
        this.init(className);
        TldTag tag = new TldTag();
        for (i = 0; i < this._attributes.size(); ++i) {
            TldAttribute attr = this._attributes.get(i);
            tag.addAttribute(attr);
        }
        for (i = 0; i < this._variables.size(); ++i) {
            TldVariable var = this._variables.get(i);
            try {
                tag.addVariable(var);
                continue;
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        String bodyContent = this._bodyContent;
        if (bodyContent == null) {
            bodyContent = "scriptless";
        }
        return new TagInfoExt(tag.getName(), this._fullClassName, bodyContent, this.getDescription(), taglib, null, tag.getAttributes(), this.getDisplayName(), this.getSmallIcon(), this.getLargeIcon(), tag.getVariables(), this._dynamicAttributes != null, this._dynamicAttributes, null);
    }

    protected void generateTagInfo(JspJavaWriter out) throws IOException, JspParseException {
        Object type;
        int i;
        out.println();
        out.println("public javax.servlet.jsp.tagext.TagInfo _caucho_getTagInfo(javax.servlet.jsp.tagext.TagLibraryInfo taglib)");
        out.println("  throws com.caucho.config.ConfigException");
        out.println("{");
        out.pushDepth();
        out.println("com.caucho.jsp.cfg.TldTag tag = new com.caucho.jsp.cfg.TldTag();");
        out.println("tag.setName(\"test\");");
        out.println("com.caucho.jsp.cfg.TldAttribute attr;");
        for (i = 0; i < this._attributes.size(); ++i) {
            TldAttribute attr = this._attributes.get(i);
            out.println("attr = new com.caucho.jsp.cfg.TldAttribute();");
            out.println("attr.setName(\"" + attr.getName() + "\");");
            type = attr.getType();
            if (type != null) {
                out.print("attr.setType(");
                out.printClass((Class)type);
                out.println(".class);");
            }
            out.println("attr.setRtexprvalue(" + attr.getRtexprvalue() + ");");
            out.println("attr.setRequired(" + attr.getRequired() + ");");
            if (attr.getDeferredValue() != null) {
                out.println("attr.setDeferredValue(new com.caucho.jsp.cfg.TldAttribute.DeferredValue());");
                if (attr.getDeferredValue().getType() != null) {
                    out.print("attr.getDeferredValue().setType(\"");
                    out.printJavaString(attr.getDeferredValue().getType());
                    out.println("\");");
                }
            }
            if (attr.getDeferredMethod() != null) {
                out.println("attr.setDeferredMethod(new com.caucho.jsp.cfg.TldAttribute.DeferredMethod());");
                Signature sig = attr.getDeferredMethod().getMethodSignature();
                if (sig != null) {
                    out.print("attr.getDeferredMethod().setMethodSignature(");
                    out.print("new com.caucho.config.types.Signature(\"");
                    out.printJavaString(sig.getSignature());
                    out.println("\"));");
                }
            }
            out.println("tag.addAttribute(attr);");
        }
        out.println("com.caucho.jsp.cfg.TldVariable var;");
        for (i = 0; i < this._variables.size(); ++i) {
            TldVariable var = this._variables.get(i);
            out.println("var = new com.caucho.jsp.cfg.TldVariable();");
            if (var.getNameGiven() != null) {
                out.println("var.setNameGiven(\"" + var.getNameGiven() + "\");");
            }
            if (var.getNameFromAttribute() != null) {
                out.println("var.setNameFromAttribute(\"" + var.getNameFromAttribute() + "\");");
            }
            if ((type = var.getVariableClass()) != null) {
                out.println("var.setVariableClass(\"" + (String)type + "\");");
            }
            out.println("var.setDeclare(" + var.getDeclare() + ");");
            if (var.getScope() != null) {
                out.println("var.setScope(\"" + var.getScope() + "\");");
            }
            out.println("tag.addVariable(var);");
        }
        String bodyContent = this._bodyContent;
        if (bodyContent == null) {
            bodyContent = "scriptless";
        }
        out.println("return new com.caucho.jsp.java.TagInfoExt(tag.getName(),");
        out.println("                   getClass().getName(),");
        out.println("                   \"" + bodyContent + "\",");
        out.print("                   \"");
        if (this._description != null) {
            out.printJavaString(this._description);
        } else {
            out.printJavaString("A simple tag");
        }
        out.println("\",");
        out.println("                   taglib,");
        out.println("                   null,");
        out.println("                   tag.getAttributes(),");
        if (this._displayName != null) {
            out.print("                   \"");
            out.printJavaString(this._displayName);
            out.println("\",");
        } else {
            out.println("                   null,");
        }
        if (this._smallIcon != null) {
            out.print("                   \"");
            out.printJavaString(this._smallIcon);
            out.println("\",");
        } else {
            out.println("                   null,");
        }
        if (this._largeIcon != null) {
            out.print("                   \"");
            out.printJavaString(this._largeIcon);
            out.println("\",");
        } else {
            out.println("                   null,");
        }
        out.println("                   tag.getVariables(),");
        out.println("                   " + (this._dynamicAttributes != null) + ",");
        if (this._dynamicAttributes != null) {
            out.println("                   \"" + this._dynamicAttributes + "\",");
        } else {
            out.println("                   null,");
        }
        out.println("                   _caucho_depends.getDependencies());");
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public String _caucho_getDynamicAttributes()");
        out.println("{");
        out.pushDepth();
        if (this._dynamicAttributes != null) {
            out.println("return \"" + this._dynamicAttributes + "\";");
        } else {
            out.println("return null;");
        }
        out.popDepth();
        out.println("}");
        this.generateTagLibrary(out);
    }

    protected void generateTagLibrary(JspJavaWriter out) throws IOException, JspParseException {
        out.println();
        out.println("private javax.servlet.jsp.tagext.TagLibraryInfo _caucho_getTagLibrary()");
        out.println("  throws com.caucho.config.ConfigException");
        out.println("{");
        out.pushDepth();
        out.println("return new com.caucho.jsp.java.TagTaglib(\"x\", \"http://test.com\");");
        out.popDepth();
        out.println("}");
    }

    private String toFieldName(String name) {
        if (!_reserved.contains(name)) {
            return name;
        }
        return "_" + name;
    }

    static {
        _reserved.add("public");
        _reserved.add("private");
        _reserved.add("protected");
        _reserved.add("static");
        _reserved.add("final");
        _reserved.add("class");
        _reserved.add("module");
        _reserved.add("interface");
        _reserved.add("extends");
        _reserved.add("implements");
        _reserved.add("package");
        _reserved.add("import");
        _reserved.add("new");
        _reserved.add("if");
        _reserved.add("else");
        _reserved.add("for");
        _reserved.add("do");
        _reserved.add("while");
        _reserved.add("break");
        _reserved.add("continue");
        _reserved.add("switch");
        _reserved.add("case");
        _reserved.add("default");
        _reserved.add("throw");
        _reserved.add("enum");
        _reserved.add("throws");
        _reserved.add("void");
        _reserved.add("boolean");
        _reserved.add("byte");
        _reserved.add("char");
        _reserved.add("short");
        _reserved.add("int");
        _reserved.add("long");
        _reserved.add("float");
        _reserved.add("true");
        _reserved.add("false");
        _reserved.add("null");
    }
}

