/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.jsp.JspLineParseException;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.Namespace;
import com.caucho.jsp.ParseState;
import com.caucho.jsp.TagInstance;
import com.caucho.jsp.java.CustomSimpleTag;
import com.caucho.jsp.java.CustomTag;
import com.caucho.jsp.java.JavaJspGenerator;
import com.caucho.jsp.java.JavaTagGenerator;
import com.caucho.jsp.java.JspAttribute;
import com.caucho.jsp.java.JspFragmentNode;
import com.caucho.jsp.java.JspJavaWriter;
import com.caucho.jsp.java.JspParam;
import com.caucho.jsp.java.JspSegmentNode;
import com.caucho.jsp.java.StaticText;
import com.caucho.util.CharBuffer;
import com.caucho.util.CompileException;
import com.caucho.util.L10N;
import com.caucho.util.LineCompileException;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.QName;
import com.caucho.xml.XmlChar;
import com.caucho.xpath.Expr;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.XPath;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.TagAttributeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JspNode {
    static final L10N L = new L10N(JspNode.class);
    private static final Logger log = Logger.getLogger(JspNode.class.getName());
    static final String JSP_NS = "http://java.sun.com/JSP/Page";
    protected Path _sourcePath;
    protected String _filename;
    protected int _startLine;
    protected int _endAttributeLine;
    protected int _endLine;
    protected Namespace _ns;
    protected JavaJspGenerator _gen;
    protected ParseState _parseState;
    protected QName _name;
    protected JspNode _parent;

    protected JspNode() {
    }

    public void setGenerator(JavaJspGenerator gen) {
        this._gen = gen;
    }

    public void setParseState(ParseState parseState) {
        this._parseState = parseState;
    }

    public QName getQName() {
        return this._name;
    }

    public void setQName(QName name) {
        this._name = name;
    }

    public String getTagName() {
        if (this._name != null) {
            return this._name.getName();
        }
        return "jsp:unknown";
    }

    public JspNode getParent() {
        return this._parent;
    }

    public void setParent(JspNode parent) {
        this._parent = parent;
    }

    public void setStartLocation(Path sourcePath, String filename, int line) {
        this._sourcePath = sourcePath;
        this._filename = filename;
        this._startLine = line;
        this._endAttributeLine = line;
    }

    public void setEndAttributeLocation(String filename, int line) {
        if (this._filename != null && this._filename.equals(filename)) {
            this._endAttributeLine = line;
        }
    }

    public void setEndLocation(String filename, int line) {
        if (this._filename != null && this._filename.equals(filename)) {
            this._endLine = line;
        }
    }

    public String getFilename() {
        return this._filename;
    }

    public int getStartLine() {
        return this._startLine;
    }

    public int getEndAttributeLine() {
        return this._endAttributeLine;
    }

    public int getEndLine() {
        return this._endLine;
    }

    public boolean isStatic() {
        return false;
    }

    public boolean isJstl() {
        return false;
    }

    public boolean isJsp21() {
        return true;
    }

    public String getStaticText() {
        CharBuffer cb = CharBuffer.allocate();
        this.getStaticText(cb);
        return cb.close();
    }

    public void getStaticText(CharBuffer cb) {
    }

    public boolean hasScripting() {
        return false;
    }

    public boolean hasScriptingElement() {
        return false;
    }

    public JspNode findScriptingNode() {
        if (this.hasScripting()) {
            return this;
        }
        return null;
    }

    public String getBodyContent() {
        return "jsp";
    }

    public boolean hasCustomTag() {
        return false;
    }

    public boolean hasTag() {
        return this.hasCustomTag();
    }

    public String getCustomTagName() {
        return null;
    }

    public boolean isSimpleTag() {
        return false;
    }

    public JspNode getParentTagNode() {
        if (this.getCustomTagName() != null) {
            return this;
        }
        JspNode parent = this.getParent();
        if (parent != null) {
            return parent.getParentTagNode();
        }
        return null;
    }

    public String getParentTagName() {
        if (this.getCustomTagName() != null) {
            return this.getCustomTagName();
        }
        JspNode parent = this.getParent();
        if (parent != null) {
            return parent.getParentTagName();
        }
        return null;
    }

    public boolean hasNamespace(String prefix, String uri) {
        if (this._parent == null) {
            return false;
        }
        return this._parent.hasNamespace(prefix, uri);
    }

    public final void addNamespace(String prefix, String value) {
        this.addNamespaceRec(prefix, value);
    }

    public final void setNamespace(Namespace ns) {
        this._ns = ns;
    }

    public final NamespaceContext getNamespaceContext() {
        NamespaceContext ns = null;
        for (Namespace ptr = this._ns; ptr != null; ptr = ptr.getNext()) {
            if ("".equals(ptr.getPrefix())) continue;
            ns = new NamespaceContext(ns, ptr.getPrefix(), ptr.getURI());
        }
        return ns;
    }

    public void addNamespaceRec(String prefix, String value) {
        if (this._parent != null) {
            this._parent.addNamespaceRec(prefix, value);
        }
    }

    public String getNamespacePrefix(String uri) {
        if (this._parent != null) {
            return this._parent.getNamespacePrefix(uri);
        }
        return null;
    }

    public boolean hasNamespace(QName name) {
        return this.hasNamespace(name.getPrefix(), name.getNamespaceURI());
    }

    public void addAttribute(QName name, String value) throws JspParseException {
        throw this.error(L.l("attribute '{0}' is not allowed in <{1}>.", (Object)name.getName(), this.getTagName()));
    }

    public void addAttribute(QName name, JspAttribute value) throws JspParseException {
        if (!value.isStatic()) {
            throw this.error(L.l("attribute '{0}' is not allowed in <{1}>.", (Object)name.getName(), this.getTagName()));
        }
        this.addAttribute(name, value.getStaticText().trim());
    }

    public void endAttributes() throws JspParseException {
    }

    public JspNode addText(String text) throws JspParseException {
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (XmlChar.isWhitespace(ch)) continue;
            throw this.error(L.l("Text is not allowed in <{0}> at '{1}'.", (Object)this._name.getName(), text));
        }
        return null;
    }

    public void addChild(JspNode node) throws JspParseException {
        node.setParent(this);
        if (!(node instanceof JspAttribute || node instanceof StaticText && ((StaticText)node).isWhitespace())) {
            throw node.error(L.l("<{0}> does not allow any child elements at {1}", (Object)this.getTagName(), node.getTagName()));
        }
    }

    public void addChildEnd(JspNode node) throws JspParseException {
        if (node instanceof JspAttribute) {
            JspAttribute attr = (JspAttribute)node;
            QName name = attr.getName();
            this.addAttribute(name, attr);
        }
    }

    public void endElement() throws Exception {
    }

    public ArrayList<JspNode> getChildren() {
        return null;
    }

    public TagInstance getTag() {
        JspNode parent = this.getParent();
        if (parent != null) {
            return parent.getTag();
        }
        return this._gen.getRootTag();
    }

    public boolean isPre21Taglib() {
        return false;
    }

    public abstract void printXml(WriteStream var1) throws IOException;

    public void printJspId(WriteStream os) throws IOException {
        os.print(" jsp:id=\"" + this._gen.generateJspId() + "\"");
    }

    public void printXmlText(WriteStream os, String text) throws IOException {
        os.print(this.xmlText(text));
    }

    public void printXmlAttribute(WriteStream os, String name, String text) throws IOException {
        os.print(" ");
        os.print(name);
        os.print("=\"");
        if (text.startsWith("<%=") && text.endsWith("%>")) {
            os.print("%=");
            os.print(this.xmlAttrText(text.substring(3, text.length() - 2)));
            os.print("%");
        } else {
            os.print(this.xmlAttrText(text));
        }
        os.print("\"");
    }

    public String xmlText(String text) {
        if (text == null) {
            return "";
        }
        CharBuffer cb = new CharBuffer();
        block6: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    cb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    cb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    cb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    cb.append("&quot;");
                    continue block6;
                }
                default: {
                    cb.append(ch);
                }
            }
        }
        return cb.toString();
    }

    public String xmlAttrText(String text) {
        if (text == null) {
            return "";
        }
        CharBuffer cb = new CharBuffer();
        block7: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '&': {
                    cb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    cb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    cb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    cb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    cb.append("&apos;");
                    continue block7;
                }
                default: {
                    cb.append(ch);
                }
            }
        }
        return cb.toString();
    }

    public void generateStartLocation(JspJavaWriter out) throws IOException {
        out.setLocation(this._filename, this._startLine);
    }

    public void generateEndLocation(JspJavaWriter out) throws IOException {
        out.setLocation(this._filename, this._endLine);
    }

    public void generatePrologue(JspJavaWriter out) throws Exception {
        this.generatePrologueChildren(out);
    }

    public void generatePrologueDeclare(JspJavaWriter out) throws Exception {
    }

    public void generatePrologueChildren(JspJavaWriter out) throws Exception {
    }

    public void generateDeclaration(JspJavaWriter out) throws IOException {
        this.generateDeclarationChildren(out);
    }

    public void generateDeclarationChildren(JspJavaWriter out) throws IOException {
    }

    public void generateTagState(JspJavaWriter out) throws Exception {
        this.generateTagStateChildren(out);
    }

    public void generateTagStateChildren(JspJavaWriter out) throws Exception {
    }

    public void generateTagRelease(JspJavaWriter out) throws Exception {
        this.generateTagReleaseChildren(out);
    }

    public void generateTagReleaseChildren(JspJavaWriter out) throws Exception {
    }

    public abstract void generate(JspJavaWriter var1) throws Exception;

    public void generateChildren(JspJavaWriter out) throws Exception {
    }

    public void generateClassEpilogue(JspJavaWriter out) throws IOException {
        this.generateClassEpilogueChildren(out);
    }

    public void generateClassEpilogueChildren(JspJavaWriter out) throws IOException {
    }

    public void generateStatic(JspJavaWriter out) throws Exception {
    }

    public void generateEmpty() throws Exception {
        this.generateChildrenEmpty();
    }

    public void generateChildrenEmpty() throws Exception {
    }

    protected boolean attributeToBoolean(String attr, String value) throws JspParseException {
        if (value.equals("yes") || value.equals("true")) {
            return true;
        }
        if (value.equals("no") || value.equals("false")) {
            return false;
        }
        throw this.error(L.l("'{0}' is an unknown value for {1}.  'true' or 'false' are the expected values.", (Object)value, attr));
    }

    public boolean isInFragment() {
        for (JspNode node = this.getParent(); node != null; node = node.getParent()) {
            if (!(node instanceof JspAttribute) && !(node instanceof CustomSimpleTag)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    void generateSetParameter(JspJavaWriter out, String obj, Object objValue, Method method, boolean allowRtexpr, String contextVar, boolean isParentSimpleTag, boolean isFragment, TagAttributeInfo attrInfo) throws Exception {
        String strValue;
        String convValue;
        Class<?> type = method.getParameterTypes()[0];
        if (isFragment || JspFragment.class.equals(type)) {
            this.generateFragmentParameter(out, obj, objValue, method, allowRtexpr, contextVar, isParentSimpleTag);
            return;
        }
        if (objValue instanceof JspAttribute) {
            JspAttribute attr = (JspAttribute)objValue;
            if (!attr.isStatic()) {
                String str = "_jsp_str_" + this._gen.uniqueId();
                out.println("String " + str + " = " + attr.generateValue() + ";");
                out.println(obj + "." + method.getName() + "(" + this.stringToValue(type, str) + ");");
                return;
            }
            objValue = attr.getStaticText();
        } else if (objValue instanceof JspNode) {
            throw this.error(L.l("jsp:attribute may not set this attribute."));
        }
        if ((convValue = this.generateParameterValue(type, strValue = (String)objValue, allowRtexpr, attrInfo, this._parseState.isELIgnored())) != null) {
            out.println(obj + "." + method.getName() + "(" + convValue + ");");
            return;
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor == null) throw this.error(L.l("expected '<%= ... %>' at '{0}' for tag attribute setter '{1}'.  Tag attributes which can't be converted from strings must use a runtime attribute expression.", (Object)strValue, method.getName() + "(" + type.getName() + ")"));
        this.generateSetParameter(out, obj, strValue, method, editor.getClass());
    }

    void generateSetParameter(JspJavaWriter out, String obj, String value, Method method, Class<?> editorClass) throws Exception {
        Class<?> type = method.getParameterTypes()[0];
        String name = "_jsp_editor" + this._gen.uniqueId();
        out.print("java.beans.PropertyEditor " + name + " = new " + editorClass.getName() + "();");
        out.println(name + ".setAsText(\"" + JspNode.escapeJavaString(value) + "\");");
        out.println(obj + "." + method.getName() + "((" + type.getName() + ") " + name + ".getValue());");
    }

    void generateFragmentParameter(JspJavaWriter out, Object obj, Object objValue, Method method, boolean allowRtexpr, String contextVar, boolean isParentSimpleTag) throws Exception {
        out.print(obj + "." + method.getName() + "(");
        if (objValue instanceof JspFragmentNode) {
            this.generateFragment(out, (JspFragmentNode)objValue, contextVar, isParentSimpleTag);
        } else if (objValue instanceof String) {
            String string = (String)objValue;
            int index = this._gen.addExpr(string);
            out.print("new com.caucho.jsp.ELExprFragment(pageContext, _caucho_expr_" + index + ")");
        } else {
            throw this.error(L.l("can't handle fragment '{0}' of type {1}", objValue, objValue.getClass()));
        }
        out.println(");");
    }

    String generateFragmentParameter(String string, boolean allowRtexpr) throws Exception {
        int index = this._gen.addExpr(string);
        return "new com.caucho.jsp.ELExprFragment(pageContext, _caucho_expr_" + index + ")";
    }

    public JspSegmentNode getSegment() {
        JspNode parent = this.getParent();
        if (parent != null) {
            return parent.getSegment();
        }
        return null;
    }

    void generateFragment(JspJavaWriter out, JspFragmentNode frag, String contextVar, boolean isParentSimpleTag) throws Exception {
        out.print(this.generateFragment(frag, contextVar));
    }

    void generateParentTag(JspJavaWriter out, TagInstance parent) throws IOException {
        String parentId = parent.getId();
        if (parentId == null || parentId.startsWith("top_")) {
            out.print("null");
        } else if (parent.isSimpleTag()) {
            out.print("(" + parentId + "_adapter != null ? ");
            out.print(parentId + "_adapter : ");
            out.print("(" + parentId + "_adapter = new javax.servlet.jsp.tagext.TagAdapter(" + parentId + ")))");
        } else {
            out.print(parentId);
        }
    }

    String generateRTValue(Class<?> type, Object value) throws Exception {
        if (value instanceof String) {
            return this.generateParameterValue(type, (String)value, true, null, this._parseState.isELIgnored());
        }
        JspAttribute attr = (JspAttribute)value;
        return this.stringToValue(type, attr.generateValue());
    }

    protected String invokeFragment(JspFragmentNode frag) throws Exception {
        return frag.generateValue();
    }

    protected String generateFragment(JspFragmentNode frag, String contextVar) throws Exception {
        int index = this._gen.addFragment(frag);
        StringBuffer cb = new StringBuffer();
        if (frag.isStatic()) {
            String fragmentVar = frag.getFragmentName();
            cb.append(fragmentVar + " = com.caucho.jsp.StaticJspFragmentSupport.create(" + fragmentVar + ", " + contextVar + ", \"");
            cb.append(JspNode.escapeJavaString(frag.getStaticText()));
            cb.append("\")");
            return cb.toString();
        }
        String fragmentVar = frag.getFragmentName();
        JspNode parentTag = this.getParentTagNode();
        boolean isParentSimpleTag = parentTag instanceof CustomSimpleTag;
        if (!isParentSimpleTag) {
            cb.append(fragmentVar + " = createFragment(" + fragmentVar + ", " + index + ", _jsp_parentContext" + ", " + contextVar + ", ");
        } else {
            cb.append(fragmentVar + " = createFragment(null" + ", " + index + ", _jsp_parentContext" + ", " + contextVar + ", ");
        }
        if (parentTag == null) {
            cb.append("null");
        } else if (frag.hasCustomTag() && parentTag instanceof CustomSimpleTag) {
            cb.append(parentTag.getCustomTagName() + "_adapter");
        } else {
            cb.append(parentTag.getCustomTagName());
        }
        if (this._gen instanceof JavaTagGenerator) {
            JavaTagGenerator tagGen = (JavaTagGenerator)this._gen;
            if (tagGen.isStaticDoTag()) {
                cb.append(", _jspBody");
            } else {
                cb.append(", getJspBody()");
            }
        } else {
            cb.append(", null");
        }
        cb.append(", _jsp_state");
        cb.append(", _jsp_pageManager");
        cb.append(")");
        return cb.toString();
    }

    protected String generateParentTag(TagInstance parent) throws IOException {
        String parentId = parent.getId();
        if (parent.isTop()) {
            return "null";
        }
        if (parent.isSimpleTag()) {
            CharBuffer cb = CharBuffer.allocate();
            cb.append("(" + parentId + "_adapter != null ? ");
            cb.append(parentId + "_adapter : ");
            cb.append("(" + parentId + "_adapter = new javax.servlet.jsp.tagext.TagAdapter(" + parentId + ")))");
            return cb.close();
        }
        return parentId;
    }

    public String getJsfVar() {
        if (this._parent != null) {
            return this._parent.getJsfVar();
        }
        return null;
    }

    public String getJsfBodyVar() {
        if (this._parent != null) {
            return this._parent.getJsfBodyVar();
        }
        return null;
    }

    public boolean isJsfParentRequired() {
        return false;
    }

    void generateIncludeParams(JspJavaWriter out, ArrayList params) throws Exception {
        boolean hasQuery = false;
        for (int i = 0; i < params.size(); ++i) {
            JspParam param = (JspParam)params.get(i);
            String value = param.getValue();
            if (hasQuery) {
                out.print("+ \"&\" + ");
            }
            hasQuery = true;
            out.print("\"" + param.getName() + "=\"");
            String outValue = this.generateParameterValue(String.class, value);
            if (outValue.equals("null")) continue;
            if (outValue.startsWith("\"")) {
                out.print(" + (" + outValue + ")");
                continue;
            }
            out.print(" + com.caucho.el.Expr.toString(" + outValue + ", null)");
        }
    }

    protected void generateIncludeUrl(JspJavaWriter out, String page, ArrayList<JspParam> params) throws Exception {
        int i;
        if (params != null) {
            for (i = 0; i < params.size(); ++i) {
                out.print("pageContext.encode(");
            }
            out.print("pageContext.encode(");
        }
        if (this.hasRuntimeAttribute(page)) {
            out.print(this.getRuntimeAttribute(page));
        } else {
            out.print(this.generateParameterValue(String.class, page));
        }
        if (params != null) {
            out.print(")");
            for (i = 0; i < params.size(); ++i) {
                if (i > 0) {
                    out.print(".append('&')");
                }
                out.print(", ");
                this.generateIncludeParam(out, params.get(i));
                out.print(")");
            }
            out.print(".toString()");
        }
    }

    void generateIncludeParam(JspJavaWriter out, JspParam param) throws Exception {
        String value = param.getValue();
        out.print("\"" + param.getName() + "=\"");
        String outValue = this.generateParameterValue(String.class, value);
        if (!outValue.equals("null")) {
            if (outValue.startsWith("\"")) {
                out.print(" + (" + outValue + ")");
            } else {
                out.print(" + com.caucho.el.Expr.toString(" + outValue + ", null)");
            }
        }
    }

    String generateJstlValue(Class type, String value) throws Exception {
        return this.generateParameterValue(type, value, true, null, false);
    }

    String generateValue(Class type, String value) throws Exception {
        return this.generateParameterValue(type, value, true, null, this._parseState.isELIgnored());
    }

    String generateParameterValue(Class<?> type, String value) throws Exception {
        return this.generateParameterValue(type, value, true, null, this._parseState.isELIgnored());
    }

    String generateParameterValue(Class<?> type, String value, boolean rtexpr, TagAttributeInfo attrInfo, boolean isELIgnored) throws Exception {
        boolean isEmpty;
        if (this.isJstl()) {
            isELIgnored = false;
        }
        boolean bl = isEmpty = value == null || value.equals("");
        if (isEmpty) {
            value = "0";
        }
        try {
            boolean isMethodDeferred;
            String typeName = attrInfo != null ? attrInfo.getExpectedTypeName() : "";
            boolean isValueDeferred = attrInfo != null && attrInfo.isDeferredValue() || typeName != null && !"".equals(typeName);
            boolean bl2 = isMethodDeferred = attrInfo != null && attrInfo.isDeferredMethod();
            if (JspFragment.class.equals(type)) {
                return this.generateFragmentParameter(value, rtexpr);
            }
            if (type.equals(ValueExpression.class)) {
                int exprIndex = isEmpty ? this._gen.addValueExpr("", typeName) : this._gen.addValueExpr(value, typeName);
                if (isValueDeferred && value.indexOf("#{") < 0 && value.indexOf("${") >= 0) {
                    throw this.error(L.l("ValueExpression '{0}' must use deferred syntax '#{...}'", value));
                }
                if (!isValueDeferred && value.indexOf("#{") >= 0 && value.indexOf("${") < 0) {
                    throw this.error(L.l("Deferred syntax '#{...}' is not allowed for '{0}'", value));
                }
                if (value.indexOf("#{") < 0 && value.indexOf("${") < 0) {
                    return "_caucho_value_expr_" + exprIndex;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("pageContext.createExpr(_caucho_value_expr_");
                sb.append(exprIndex);
                sb.append(", \"");
                sb.append(JspNode.escapeJavaString(value));
                sb.append("\", ");
                if (null == typeName || "".equals(typeName)) {
                    sb.append("java.lang.Object.class)");
                } else {
                    sb.append(JspNode.escapeJavaString(typeName));
                    sb.append(".class)");
                }
                return sb.toString();
            }
            if (type.equals(MethodExpression.class)) {
                String sig = attrInfo != null ? attrInfo.getMethodSignature() : "java.lang.String misc()";
                int exprIndex = isEmpty ? this._gen.addMethodExpr("", sig) : this._gen.addMethodExpr(value, sig);
                if (value.indexOf("${") >= 0) {
                    throw this.error(L.l("MethodExpression '{0}' must use deferred syntax '$#{...}'", value));
                }
                return "_caucho_method_expr_" + exprIndex;
            }
            if (!isValueDeferred && !this._gen.getParseState().isDeferredSyntaxAllowedAsLiteral() && value.indexOf("#{") >= 0 && value.indexOf("${") < 0 && rtexpr && this.isJsp21()) {
                throw this.error(L.l("deferred expression '{0}' is not allowed here", value));
            }
            if (com.caucho.el.Expr.class.equals(type)) {
                int exprIndex = isEmpty ? this._gen.addExpr("") : this._gen.addExpr(value);
                return "_caucho_expr_" + exprIndex;
            }
            if (Expr.class.equals(type)) {
                Expr expr = isEmpty ? XPath.parseExpr("") : XPath.parseExpr(value, this.getNamespaceContext());
                return this._gen.addXPathExpr(expr);
            }
            if (rtexpr && this.hasRuntimeAttribute(value)) {
                return this.getRuntimeAttribute(value);
            }
            if (rtexpr && this.hasELAttribute(value, isELIgnored)) {
                return this.generateELValue(type, value);
            }
            if (!rtexpr && this.hasELAttribute(value, isELIgnored)) {
                if (String.class.equals(type) && this._gen.isELIgnore()) {
                    return '\"' + JspNode.escapeJavaString(value) + '\"';
                }
                throw this.error(L.l("EL expression '{0}' is only allowed for attributes with rtexprvalue='true'.", value));
            }
            if (rtexpr && this.hasDeferredAttribute(value, false)) {
                if (type.equals(String.class)) {
                    return '\"' + value + '\"';
                }
                return this.generateELValue(type, value);
            }
            if (!rtexpr && this.hasDeferredAttribute(value, isELIgnored) && !this._gen.getParseState().isDeferredSyntaxAllowedAsLiteral()) {
                throw this.error(L.l("Deferred syntax '{0}' is not allowed as a literal.", value));
            }
            if (type.equals(Boolean.TYPE)) {
                return String.valueOf(Boolean.valueOf(isEmpty ? "false" : value));
            }
            if (type.equals(Boolean.class)) {
                if (isEmpty) {
                    return "java.lang.Boolean.FALSE";
                }
                return "new java.lang.Boolean(" + Boolean.valueOf(value) + ")";
            }
            if (type.equals(Byte.TYPE)) {
                return "(byte) " + Byte.valueOf(value);
            }
            if (type.equals(Byte.class)) {
                return "new java.lang.Byte((byte) " + Byte.valueOf(value) + ")";
            }
            if (type.equals(Character.TYPE)) {
                if (isEmpty) {
                    return "'\\0'";
                }
                return "'" + value.charAt(0) + "'";
            }
            if (type.equals(Character.class)) {
                if (isEmpty) {
                    return "new java.lang.Character('\\0')";
                }
                return "new Character('" + value.charAt(0) + "')";
            }
            if (type.equals(Short.TYPE)) {
                return "(short) " + Short.valueOf(value);
            }
            if (type.equals(Short.class)) {
                return "new java.lang.Short((short) " + Short.valueOf(value) + ")";
            }
            if (type.equals(Integer.TYPE)) {
                return String.valueOf(Integer.valueOf(value));
            }
            if (type.equals(Integer.class)) {
                return "new java.lang.Integer(" + Integer.valueOf(value) + ")";
            }
            if (type.equals(Long.TYPE)) {
                return String.valueOf(Long.valueOf(value));
            }
            if (type.equals(Long.class)) {
                return "new java.lang.Long(" + Long.valueOf(value) + ")";
            }
            if (type.equals(Float.TYPE)) {
                return "(float) " + Float.valueOf(value);
            }
            if (type.equals(Float.class)) {
                return "new java.lang.Float((float) " + Float.valueOf(value) + ")";
            }
            if (type.equals(Double.TYPE)) {
                return String.valueOf(Double.valueOf(value));
            }
            if (type.equals(Double.class)) {
                double v = Double.valueOf(value);
                if (Double.isNaN(v)) {
                    return "new java.lang.Double(Double.NaN)";
                }
                return "new java.lang.Double(" + v + ")";
            }
            if (!type.equals(String.class) && !type.equals(Object.class)) {
                return null;
            }
            if (!isEmpty) {
                return '\"' + JspNode.escapeJavaString(value) + '\"';
            }
            return "\"\"";
        }
        catch (NumberFormatException e) {
            throw this.error(L.l("parameter format error: {0}", e.getMessage()), e);
        }
    }

    protected String generateELValue(Class type, String value) throws Exception {
        if (type.equals(com.caucho.el.Expr.class)) {
            int exprIndex = this._gen.addExpr(value);
            return "_caucho_expr_" + exprIndex;
        }
        if (type.equals(ValueExpression.class)) {
            int exprIndex = this._gen.addValueExpr(value, "");
            return "_caucho_value_expr_" + exprIndex;
        }
        if (type.equals(Object.class) && value.contains("#{") && CustomTag.class.equals(this.getClass())) {
            int exprIndex = this._gen.addValueExpr(value, "");
            return "_caucho_value_expr_" + exprIndex;
        }
        if (type.equals(Expr.class)) {
            Expr expr = XPath.parseExpr(value, this.getNamespaceContext());
            return this._gen.addXPathExpr(expr);
        }
        com.caucho.el.Expr expr = this._gen.genExpr(value);
        if (expr.isConstant()) {
            try {
                Object cValue;
                if (expr.evalObject(null) == null) {
                    if (Character.class.isAssignableFrom(type)) {
                        return "new Character((char) 0)";
                    }
                    if (Boolean.class.isAssignableFrom(type)) {
                        return "Boolean.FALSE";
                    }
                    if (String.class.isAssignableFrom(type)) {
                        return "\"\"";
                    }
                    if (BigInteger.class.isAssignableFrom(type)) {
                        return "java.math.BigInteger.ZERO";
                    }
                    if (BigDecimal.class.isAssignableFrom(type)) {
                        return "java.math.BigDecimal.ZERO";
                    }
                    if (Number.class.isAssignableFrom(type)) {
                        return "new " + type.getName() + "((byte) 0)";
                    }
                    if (Object.class.isAssignableFrom(type)) {
                        return "null";
                    }
                }
                if (Boolean.TYPE.equals(type)) {
                    return expr.evalBoolean(null) ? "true" : "false";
                }
                if (Boolean.class.equals((Object)type)) {
                    return expr.evalBoolean(null) ? "java.lang.Boolean.TRUE" : "java.lang.Boolean.FALSE";
                }
                if (Byte.TYPE.equals(type)) {
                    return "(byte) " + expr.evalLong(null);
                }
                if (Byte.class.equals((Object)type)) {
                    return "new java.lang.Byte((byte) " + expr.evalLong(null) + "L)";
                }
                if (Short.TYPE.equals(type)) {
                    return "(short) " + expr.evalLong(null);
                }
                if (Short.class.equals((Object)type)) {
                    return "new java.lang.Short((short) " + expr.evalLong(null) + "L)";
                }
                if (Integer.TYPE.equals(type)) {
                    return "(int) " + expr.evalLong(null);
                }
                if (Integer.class.equals((Object)type)) {
                    return "new java.lang.Integer((int) " + expr.evalLong(null) + "L)";
                }
                if (Long.TYPE.equals(type)) {
                    return "" + expr.evalLong(null) + "L";
                }
                if (Long.class.equals((Object)type)) {
                    return "new java.lang.Long(" + expr.evalLong(null) + "L)";
                }
                if (Float.TYPE.equals(type)) {
                    return "(float) " + expr.evalDouble(null);
                }
                if (Float.class.equals((Object)type)) {
                    return "new java.lang.Float((float) " + expr.evalDouble(null) + ")";
                }
                if (Double.TYPE.equals(type)) {
                    double v = expr.evalDouble(null);
                    if (Double.isNaN(v)) {
                        return "Double.NaN";
                    }
                    return "" + v;
                }
                if (Double.class.equals((Object)type)) {
                    double v = expr.evalDouble(null);
                    if (Double.isNaN(v)) {
                        return "new Double(Double.NaN)";
                    }
                    return "new java.lang.Double(" + v + ")";
                }
                if (Character.TYPE.equals(type)) {
                    return "((char) " + expr.evalCharacter(null) + ")";
                }
                if (Character.class.equals((Object)type)) {
                    return "new Character((char) " + expr.evalCharacter(null) + ")";
                }
                if (String.class.equals((Object)type)) {
                    return "\"" + JspNode.escapeJavaString(expr.evalString(null)) + "\"";
                }
                if (BigInteger.class.equals((Object)type)) {
                    String v = expr.evalBigInteger(null).toString();
                    if (v.equals("") || v.equals("0")) {
                        return "java.math.BigInteger.ZERO";
                    }
                    return "new java.math.BigInteger(\"" + v + "\")";
                }
                if (BigDecimal.class.equals((Object)type)) {
                    String v = expr.evalBigDecimal(null).toString();
                    if (v.equals("") || v.equals("0.0")) {
                        return "java.math.BigDecimal.ZERO";
                    }
                    return "new java.math.BigDecimal(\"" + v + "\")";
                }
                if (Object.class.equals((Object)type)) {
                    cValue = expr.evalObject(null);
                    String result = this.generateObject(cValue);
                    if (result != null) {
                        return result;
                    }
                } else {
                    cValue = expr.evalObject(null);
                    if ("".equals(cValue)) {
                        return "null";
                    }
                }
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
                log.fine(e.getMessage());
            }
        }
        int exprIndex = this._gen.addExpr(value);
        String var = "_caucho_expr_" + exprIndex;
        if (Boolean.TYPE.equals(type)) {
            return var + ".evalBoolean(_jsp_env)";
        }
        if (Boolean.class.equals((Object)type)) {
            return var + ".evalBoolean(_jsp_env) ? java.lang.Boolean.TRUE : java.lang.Boolean.FALSE";
        }
        if (Byte.TYPE.equals(type)) {
            return "(byte) " + var + ".evalLong(_jsp_env)";
        }
        if (Byte.class.equals((Object)type)) {
            return "new java.lang.Byte((byte) " + var + ".evalLong(_jsp_env))";
        }
        if (Short.TYPE.equals(type)) {
            return "(short) " + var + ".evalLong(_jsp_env)";
        }
        if (Short.class.equals((Object)type)) {
            return "new java.lang.Short((short) " + var + ".evalLong(_jsp_env))";
        }
        if (Integer.TYPE.equals(type)) {
            return "(int) " + var + ".evalLong(_jsp_env)";
        }
        if (Integer.class.equals((Object)type)) {
            return "new java.lang.Integer((int) " + var + ".evalLong(_jsp_env))";
        }
        if (Long.TYPE.equals(type)) {
            return var + ".evalLong(_jsp_env)";
        }
        if (Long.class.equals((Object)type)) {
            return "new java.lang.Long(" + var + ".evalLong(_jsp_env))";
        }
        if (Float.TYPE.equals(type)) {
            return "(float) " + var + ".evalDouble(_jsp_env)";
        }
        if (Float.class.equals((Object)type)) {
            return "new java.lang.Float((float) " + var + ".evalDouble(_jsp_env))";
        }
        if (Double.TYPE.equals(type)) {
            return var + ".evalDouble(_jsp_env)";
        }
        if (Double.class.equals((Object)type)) {
            return "new java.lang.Double(" + var + ".evalDouble(_jsp_env))";
        }
        if (BigDecimal.class.equals((Object)type)) {
            return "" + var + ".evalBigDecimal(_jsp_env)";
        }
        if (BigInteger.class.equals((Object)type)) {
            return "" + var + ".evalBigInteger(_jsp_env)";
        }
        if (Character.TYPE.equals(type)) {
            return var + ".evalCharacter(_jsp_env)";
        }
        if (Character.class.equals((Object)type)) {
            return "new Character(" + var + ".evalCharacter(_jsp_env))";
        }
        if (String.class.equals((Object)type)) {
            return var + ".evalString(_jsp_env)";
        }
        if (BigInteger.class.equals((Object)type)) {
            return var + ".evalBigInteger(_jsp_env)";
        }
        if (BigDecimal.class.equals((Object)type)) {
            return var + ".evalBigDecimal(_jsp_env)";
        }
        if (Object.class.equals((Object)type)) {
            return var + ".evalObject(_jsp_env)";
        }
        return "(" + this.classToString(type) + ") " + var + ".evalObject(_jsp_env)";
    }

    public void convertParameterValue(JspJavaWriter out, String type, String value) throws IOException {
        if (type.equals("boolean")) {
            out.print("java.lang.Boolean.TRUE.equals(" + value + ")");
        } else if (type.equals("byte")) {
            out.print("java.lang.Byte.valueOf(" + value + ")");
        } else if (type.equals("char")) {
            out.print("java.lang.Character.valueOf(" + value + ")");
        } else if (type.equals("short")) {
            out.print("java.lang.Short.valueOf(" + value + ")");
        } else if (type.equals("int")) {
            out.print("((java.lang.Integer) " + value + ").intValue()");
        } else if (type.equals("long")) {
            out.print("((java.lang.Long) " + value + ").longValue()");
        } else if (type.equals("float")) {
            out.print("((java.lang.Float) " + value + ").floatValue()");
        } else if (type.equals("double")) {
            out.print("((java.lang.Double) " + value + ").doubleValue()");
        } else {
            out.print("(" + type + ")" + value);
        }
    }

    protected String classToString(Class cl) {
        if (cl.isArray()) {
            return this.classToString(cl.getComponentType()) + "[]";
        }
        return cl.getName();
    }

    public boolean hasRuntimeAttribute(String value) throws JspParseException {
        if (this._parseState.isScriptingInvalid()) {
            return false;
        }
        if (value.startsWith("<%=") && value.endsWith("%>")) {
            return true;
        }
        if (value.startsWith("%=") && value.endsWith("%")) {
            return true;
        }
        if (value.indexOf("<%=") >= 0 && value.indexOf("<%=") < value.indexOf("%>")) {
            throw this.error(L.l("interpolated runtime values are forbidden by the JSP spec at '{0}'", value));
        }
        return false;
    }

    public boolean hasScripting(String value) {
        try {
            return value != null && this.hasRuntimeAttribute(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasScripting(JspAttribute value) {
        return value != null && value.hasScripting();
    }

    public boolean hasELAttribute(String value) {
        return !this._parseState.isELIgnored() && value.indexOf("${") >= 0;
    }

    public boolean hasDeferredAttribute(String value) {
        if (value.indexOf("#{") < 0) {
            return false;
        }
        if (this.isPre21Taglib()) {
            return false;
        }
        return !this._parseState.isELIgnored();
    }

    public boolean hasELAttribute(String value, boolean isELIgnored) {
        return !isELIgnored && value.indexOf("${") >= 0;
    }

    public boolean hasDeferredAttribute(String value, boolean isELIgnored) {
        if (isELIgnored) {
            return false;
        }
        if (value.indexOf("#{") < 0) {
            return false;
        }
        return !this.isPre21Taglib();
    }

    public String getRuntimeAttribute(String value) throws Exception {
        if (value.startsWith("<%=") && value.endsWith("%>")) {
            return value.substring(3, value.length() - 2);
        }
        if (value.startsWith("%=") && value.endsWith("%")) {
            return value.substring(2, value.length() - 1);
        }
        return value;
    }

    String stringToValue(Class type, String obj) {
        if (Boolean.TYPE.equals(type)) {
            return "com.caucho.jsp.PageContextImpl.toBoolean(" + obj + ")";
        }
        if (Boolean.class.equals((Object)type)) {
            return "java.lang.Boolean.valueOf(" + obj + ")";
        }
        if (Byte.TYPE.equals(type)) {
            return "java.lang.Byte.parseByte(" + obj + ")";
        }
        if (Byte.class.equals((Object)type)) {
            return "java.lang.Byte.valueOf(" + obj + ")";
        }
        if (Character.TYPE.equals(type)) {
            return obj + ".charAt(0)";
        }
        if (Character.class.equals((Object)type)) {
            return "new java.lang.Character(" + obj + ".charAt(0))";
        }
        if (Short.TYPE.equals(type)) {
            return "java.lang.Short.parseShort(" + obj + ")";
        }
        if (Short.class.equals((Object)type)) {
            return "java.lang.Short.valueOf(" + obj + ")";
        }
        if (Integer.TYPE.equals(type)) {
            return "java.lang.Integer.parseInt(" + obj + ")";
        }
        if (Integer.class.equals((Object)type)) {
            return "java.lang.Integer.valueOf(" + obj + ")";
        }
        if (Long.TYPE.equals(type)) {
            return "java.lang.Long.parseLong(" + obj + ")";
        }
        if (Long.class.equals((Object)type)) {
            return "java.lang.Long.valueOf(" + obj + ")";
        }
        if (Float.TYPE.equals(type)) {
            return "java.lang.Float.parseFloat(" + obj + ")";
        }
        if (Float.class.equals((Object)type)) {
            return "java.lang.Float.valueOf(" + obj + ")";
        }
        if (Double.TYPE.equals(type)) {
            return "java.lang.Double.parseDouble(" + obj + ")";
        }
        if (Double.class.equals((Object)type)) {
            return "java.lang.Double.valueOf(" + obj + ")";
        }
        if (type.isAssignableFrom(String.class)) {
            return obj;
        }
        return null;
    }

    Object staticStringToValue(Class type, String obj) {
        if (Boolean.TYPE.equals(type) || Boolean.class.equals((Object)type)) {
            return Boolean.valueOf(obj);
        }
        if (Byte.TYPE.equals(type) || Byte.class.equals((Object)type)) {
            return Byte.parseByte(obj);
        }
        if (Character.TYPE.equals(type) || Character.class.equals((Object)type)) {
            return Character.valueOf(obj.charAt(0));
        }
        if (Short.TYPE.equals(type) || Short.class.equals((Object)type)) {
            return Short.parseShort(obj);
        }
        if (Integer.TYPE.equals(type) || Integer.class.equals((Object)type)) {
            return Integer.parseInt(obj);
        }
        if (Long.TYPE.equals(type) || Long.class.equals((Object)type)) {
            return Long.parseLong(obj);
        }
        if (Float.TYPE.equals(type) || Float.class.equals((Object)type)) {
            return Float.valueOf(Float.parseFloat(obj));
        }
        if (Double.TYPE.equals(type) || Double.class.equals((Object)type)) {
            return Double.parseDouble(obj);
        }
        if (type.isAssignableFrom(String.class)) {
            return obj;
        }
        return obj;
    }

    protected String generateObject(Object obj) {
        if (obj instanceof String) {
            return "\"" + JspNode.escapeJavaString((String)obj) + "\"";
        }
        if (obj instanceof Long) {
            return "new java.lang.Long(" + obj + "L)";
        }
        if (obj instanceof Integer) {
            return "new java.lang.Integer((int) " + obj + "L)";
        }
        if (obj instanceof Double) {
            double v = (Double)obj;
            if (Double.isNaN(v)) {
                return "new java.lang.Double(Double.NaN)";
            }
            return "new java.lang.Double(" + v + ")";
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? "java.lang.Boolean.TRUE" : "java.lang.Boolean.FALSE";
        }
        return null;
    }

    public static String toELObject(String expr, Class type) {
        if (Boolean.TYPE.equals(type)) {
            return "((" + expr + ") ? Boolean.TRUE : Boolean.FALSE)";
        }
        if (Byte.TYPE.equals(type)) {
            return "new Long(" + expr + ")";
        }
        if (Short.TYPE.equals(type)) {
            return "new Long(" + expr + ")";
        }
        if (Integer.TYPE.equals(type)) {
            return "new Long(" + expr + ")";
        }
        if (Long.TYPE.equals(type)) {
            return "new Long(" + expr + ")";
        }
        if (Float.TYPE.equals(type)) {
            return "new Double(" + expr + ")";
        }
        if (Double.TYPE.equals(type)) {
            return "new Double(" + expr + ")";
        }
        if (Character.TYPE.equals(type)) {
            return "String.valueOf(" + expr + ")";
        }
        return expr;
    }

    public static String escapeJavaString(String s) {
        if (s == null) {
            return "";
        }
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\\') {
                cb.append("\\\\");
                continue;
            }
            if (s.charAt(i) == '\"') {
                cb.append("\\\"");
                continue;
            }
            if (s.charAt(i) == '\n') {
                cb.append("\\n");
                continue;
            }
            if (s.charAt(i) == '\r') {
                cb.append("\\r");
                continue;
            }
            cb.append(s.charAt(i));
        }
        return cb.close();
    }

    protected Class loadClass(String type) throws JspParseException {
        if (type == null) {
            return null;
        }
        try {
            return this._gen.getBeanClass(type);
        }
        catch (Exception e) {
            throw new JspParseException(e);
        }
    }

    protected JspParseException error(String msg) {
        return this.error(msg, null);
    }

    protected JspParseException error(String msg, Throwable e) {
        if (this._filename != null) {
            String lines = this._gen.getSourceLines(this._sourcePath, this._startLine);
            return new JspLineParseException(this._filename + ":" + this._startLine + ": " + msg + lines, e);
        }
        return new JspParseException(msg, e);
    }

    protected JspParseException error(Throwable e) {
        if (e instanceof JspLineParseException) {
            return (JspParseException)((Object)e);
        }
        if (this._filename == null || e instanceof LineCompileException) {
            return new JspLineParseException(e);
        }
        String msg = e instanceof CompileException ? e.getMessage() : String.valueOf(e);
        String lines = this._gen.getSourceLines(this._sourcePath, this._startLine);
        return new JspLineParseException(this._filename + ":" + this._startLine + ": " + msg + lines, e);
    }

    public String toString() {
        if (this._name == null) {
            return "<" + this.getClass().getName() + ">";
        }
        return "<" + this._name.getName() + ">";
    }
}

