/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.jsp.JspParseException;
import com.caucho.jsp.java.JspContainerNode;
import com.caucho.jsp.java.JspJavaWriter;
import com.caucho.jsp.java.JspNode;
import com.caucho.jsp.java.StaticText;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.QName;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class JspUseBean
extends JspContainerNode {
    private static final QName ID = new QName("id");
    private static final QName TYPE = new QName("type");
    private static final QName CLASS = new QName("class");
    private static final QName BEAN_NAME = new QName("beanName");
    private static final QName SCOPE = new QName("scope");
    private String _id;
    private String _typeName;
    private String _className;
    private String _beanName;
    private String _scope;

    public void addAttribute(QName name, String value) throws JspParseException {
        if (ID.equals(name)) {
            this._id = value;
        } else if (TYPE.equals(name)) {
            this._typeName = value;
        } else if (CLASS.equals(name)) {
            this._className = value;
        } else if (BEAN_NAME.equals(name)) {
            this._beanName = value;
        } else if (SCOPE.equals(name)) {
            this._scope = value;
        } else {
            throw this.error(L.l("'{0}' is an invalid attribute in <jsp:useBean>", name.getName()));
        }
    }

    public JspNode addText(String text) throws JspParseException {
        StaticText node = new StaticText(this._gen, text, this);
        this.addChild(node);
        return node;
    }

    public void printXml(WriteStream os) throws IOException {
        os.print("<jsp:userBean");
        if (this._id != null) {
            this.printXmlAttribute(os, "id", this._id);
        }
        if (this._typeName != null) {
            this.printXmlAttribute(os, "type", this._typeName);
        }
        if (this._className != null) {
            this.printXmlAttribute(os, "class", this._className);
        }
        if (this._beanName != null) {
            this.printXmlAttribute(os, "beanName", this._beanName);
        }
        if (this._scope != null) {
            this.printXmlAttribute(os, "scope", this._scope);
        }
        os.print("/>");
    }

    public void generate(JspJavaWriter out) throws Exception {
        if (this._id == null) {
            throw this.error(L.l("<jsp:useBean> expects an 'id' attribute.  id specifies the variable name for the bean."));
        }
        if (this._typeName == null) {
            this._typeName = this._className;
        }
        if (this._typeName == null) {
            throw this.error(L.l("<jsp:useBean> expects a 'type' or 'class' attribute.  The 'type' specifies the Java type of the bean."));
        }
        this._gen.addBeanClass(this._id, this._typeName);
        String context = null;
        if (this._scope == null || this._scope.equals("page")) {
            context = "pageContext";
        } else if (this._scope.equals("request")) {
            context = "pageContext.getRequest()";
        } else if (this._scope.equals("session")) {
            context = "pageContext.getSession()";
        } else if (this._scope.equals("application")) {
            context = "pageContext.getApplication()";
        } else {
            throw this.error(L.l("Unknown scope '{0}' in <jsp:useBean>.  Scope must be 'page', 'request', 'session', or 'application'.", this._scope));
        }
        out.println(this._typeName + " " + this._id + ";");
        if ("application".equals(this._scope) || "session".equals(this._scope)) {
            out.println("synchronized (" + context + ") {");
            out.pushDepth();
        }
        out.print(this._id + " = (" + this._typeName + ") " + context);
        out.println(".getAttribute(\"" + this._id + "\");");
        out.println("if (" + this._id + " == null) {");
        out.pushDepth();
        boolean canInstantiate = false;
        if (this._className != null) {
            String msg = this.canInstantiateBean(this._className);
            if (msg == null) {
                out.println(this._id + " = new " + this._className + "();");
                canInstantiate = true;
            } else {
                out.println("throw new java.lang.InstantiationException(\"" + msg + "\");");
            }
        } else if (this._beanName == null) {
            out.println("throw new java.lang.InstantiationException(\"jsp:useBean needs 'bean' or 'class'\");");
        } else if (this.hasRuntimeAttribute(this._beanName)) {
            String beanName = this.getRuntimeAttribute(this._beanName);
            out.println(this._id + " = (" + this._typeName + ") java.beans.Beans.instantiate(getClass().getClassLoader(), " + beanName + ");");
            canInstantiate = true;
        } else {
            out.println(this._id + " = (" + this._typeName + ") java.beans.Beans.instantiate(getClass().getClassLoader(), \"" + this._beanName + "\");");
            canInstantiate = true;
        }
        if (canInstantiate) {
            out.println(context + ".setAttribute(\"" + this._id + "\", " + this._id + ");");
        }
        if (canInstantiate) {
            this.generateChildren(out);
        }
        out.popDepth();
        out.println("}");
        if ("application".equals(this._scope) || "session".equals(this._scope)) {
            out.popDepth();
            out.println("}");
        }
    }

    private String canInstantiateBean(String className) throws Exception {
        try {
            Class cl = this._gen.getBeanClass(className);
            int modifiers = cl.getModifiers();
            if (Modifier.isInterface(modifiers)) {
                return L.l("'{0}' is an interface", className);
            }
            if (Modifier.isAbstract(modifiers)) {
                return L.l("'{0}' is abstract", className);
            }
            if (!Modifier.isPublic(modifiers)) {
                return L.l("'{0}' must be public", className);
            }
            Constructor<?>[] constructors = cl.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Class<?>[] param = constructors[i].getParameterTypes();
                if (param.length != 0) continue;
                return null;
            }
        }
        catch (Exception e) {
            throw this.error(e.getMessage());
        }
        return L.l("'{0}' has no public zero-arg constructor", className);
    }
}

