/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.rt;

import com.caucho.el.Expr;
import com.caucho.util.L10N;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class CoreSetTag
extends BodyTagSupport {
    private static L10N L = new L10N(CoreSetTag.class);
    private Object _value;
    private boolean _hasValue;
    private String _var;
    private String _scope;
    private Object _target;
    private String _property;

    public void setValue(Object value) {
        this._value = value;
        this._hasValue = true;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public void setTarget(Object target) {
        this._target = target;
    }

    public void setProperty(String property) {
        this._property = property;
    }

    public int doStartTag() throws JspException {
        if (!this._hasValue) {
            return 2;
        }
        if (this._value instanceof ValueExpression && this._var != null) {
            this.doMapVariable((ValueExpression)this._value);
        } else if (this._var != null) {
            this.doSetValue(this._value);
        } else {
            this.doSetProperty(this._value);
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        BodyContent body = this.getBodyContent();
        if (body != null) {
            String value = body.getString().trim();
            if (this._var != null) {
                this.doSetValue(value);
            } else {
                this.doSetProperty(value);
            }
        }
        return 6;
    }

    private void doMapVariable(ValueExpression valueExpr) {
        VariableMapper mapper = this.pageContext.getELContext().getVariableMapper();
        mapper.setVariable(this._var, valueExpr);
    }

    private void doSetValue(Object value) throws JspException {
        CoreSetTag.setValue(this.pageContext, this._var, this._scope, value);
    }

    private void doSetProperty(Object value) throws JspException {
        Expr.setProperty(this._target, this._property, value);
    }

    public static void setValue(PageContext pageContext, String var, String scope, Object value) throws JspException {
        if (var == null) {
            if (scope != null && !"".equals(scope)) {
                throw new JspException(L.l("var must not be null when scope '{0}' is set.", scope));
            }
        } else {
            if ("".equals(var)) {
                throw new JspException(L.l("var must not be ''"));
            }
            if (scope == null || scope.equals("page")) {
                if (value != null) {
                    pageContext.setAttribute(var, value);
                } else {
                    pageContext.removeAttribute(var);
                }
            } else if (scope.equals("request")) {
                if (value != null) {
                    pageContext.getRequest().setAttribute(var, value);
                } else {
                    pageContext.getRequest().removeAttribute(var);
                }
            } else if (scope.equals("session")) {
                if (value != null) {
                    pageContext.getSession().setAttribute(var, value);
                } else {
                    pageContext.getSession().removeAttribute(var);
                }
            } else if (scope.equals("application")) {
                if (value != null) {
                    pageContext.getServletContext().setAttribute(var, value);
                } else {
                    pageContext.getServletContext().removeAttribute(var);
                }
            } else {
                throw new JspException(L.l("illegal scope value {0}", scope));
            }
        }
    }
}

