/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.util.L10N;
import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CloseListener
implements ClassLoaderListener {
    private static final L10N L = new L10N(CloseListener.class);
    private static final Logger log = Logger.getLogger(CloseListener.class.getName());
    private Object _resource;

    public CloseListener(Object resource) {
        this._resource = resource;
    }

    public void classLoaderInit(DynamicClassLoader loader) {
    }

    public void classLoaderDestroy(DynamicClassLoader loader) {
        Method destroy = CloseListener.getDestroyMethod(this._resource.getClass());
        if (destroy == null) {
            return;
        }
        try {
            destroy.invoke(this._resource, new Object[0]);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public static Method getDestroyMethod(Class cl) {
        if (Closeable.class.isAssignableFrom(cl)) {
            try {
                return Closeable.class.getMethod("close", new Class[0]);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        try {
            return cl.getMethod("destroy", new Class[0]);
        }
        catch (Throwable e) {
            try {
                return cl.getMethod("close", new Class[0]);
            }
            catch (Throwable e2) {
                try {
                    return cl.getMethod("stop", new Class[0]);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        }
    }

    public String toString() {
        return "CloseListener[" + this._resource + "]";
    }
}

