/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Loader;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configurable
public class SimpleLoader
extends Loader {
    private static final Logger log = Logger.getLogger(SimpleLoader.class.getName());
    private Path _path;
    private String _prefix;
    private String _pathPrefix;
    private CodeSource _codeSource;

    public SimpleLoader() {
    }

    public SimpleLoader(ClassLoader loader) {
        super(loader);
    }

    public SimpleLoader(DynamicClassLoader loader, Path path) {
        this(loader);
        this.setPath(path);
    }

    public SimpleLoader(DynamicClassLoader loader, Path path, String prefix) {
        this(loader);
        this.setPath(path);
        this.setPrefix(prefix);
    }

    public static DynamicClassLoader create(ClassLoader parent, Path path, String prefix) {
        DynamicClassLoader loader = new DynamicClassLoader(parent, false);
        SimpleLoader simpleLoader = new SimpleLoader(loader, path, prefix);
        simpleLoader.init();
        loader.addLoader(simpleLoader);
        loader.init();
        return loader;
    }

    public static DynamicClassLoader create(ClassLoader parent, Path path) {
        DynamicClassLoader loader = new DynamicClassLoader(parent, false);
        loader.addLoader(new SimpleLoader(loader, path));
        loader.init();
        return loader;
    }

    public static DynamicClassLoader create(Path path) {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        return SimpleLoader.create(parent, path);
    }

    public void setPath(Path path) {
        if (path.getPath().endsWith(".jar") || path.getPath().endsWith(".zip")) {
            path = JarPath.create(path);
        }
        this._path = path;
    }

    public Path getPath() {
        return this._path;
    }

    public void setPrefix(String prefix) {
        this._prefix = prefix;
        if (prefix != null) {
            this._pathPrefix = prefix.replace('.', '/');
        }
    }

    public String getPrefix() {
        return this._prefix;
    }

    @Override
    public void setLoader(DynamicClassLoader loader) {
        super.setLoader(loader);
    }

    @Override
    @PostConstruct
    public void init() throws ConfigException {
        try {
            this._codeSource = new CodeSource(new URL(this._path.getURL()), (Certificate[])null);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        super.init();
        this.getClassLoader().addURL(this._path);
    }

    @Override
    public Path getPath(String name) {
        if (this._prefix != null && this._pathPrefix == null) {
            this._pathPrefix = this._prefix.replace('.', '/');
        }
        if (this._pathPrefix != null && !name.startsWith(this._pathPrefix)) {
            return null;
        }
        if (name.startsWith("/")) {
            return this._path.lookup("." + name);
        }
        return this._path.lookup(name);
    }

    @Override
    protected CodeSource getCodeSource(Path path) {
        return this._codeSource;
    }

    @Override
    protected void buildClassPath(ArrayList<String> pathList) {
        String path = null;
        if (this._path instanceof JarPath) {
            path = ((JarPath)this._path).getContainer().getNativePath();
        } else if (this._path.isDirectory()) {
            path = this._path.getNativePath();
        }
        if (path != null && !pathList.contains(path)) {
            pathList.add(path);
        }
    }

    public String toString() {
        if (this._prefix != null) {
            return this.getClass().getSimpleName() + "[" + this._path + ",prefix=" + this._prefix + "]";
        }
        return this.getClass().getSimpleName() + "[" + this._path + "]";
    }
}

