/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.util.L10N;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StartListener
implements EnvironmentListener {
    private static final L10N L = new L10N(StartListener.class);
    private static final Logger log = Logger.getLogger(StartListener.class.getName());
    private Object _resource;

    public StartListener(Object resource) {
        this._resource = resource;
    }

    public void environmentConfigure(EnvironmentClassLoader loader) {
    }

    public void environmentBind(EnvironmentClassLoader loader) {
    }

    public void environmentStart(EnvironmentClassLoader loader) {
        Method start = StartListener.getStartMethod(this._resource.getClass());
        if (start == null) {
            return;
        }
        try {
            start.invoke(this._resource, new Object[0]);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void environmentStop(EnvironmentClassLoader loader) {
        Method stop = StartListener.getStopMethod(this._resource.getClass());
        if (stop == null) {
            return;
        }
        try {
            stop.invoke(this._resource, new Object[0]);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public static Method getStartMethod(Class cl) {
        try {
            return cl.getMethod("start", new Class[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Method getStopMethod(Class cl) {
        try {
            return cl.getMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

