/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.JarEntry;
import com.caucho.loader.JarListLoader;
import com.caucho.util.L10N;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

@Configurable
public class TreeLoader
extends JarListLoader
implements Dependency {
    private static final L10N L = new L10N(TreeLoader.class);
    private Path _dir;

    public TreeLoader() {
    }

    public TreeLoader(ClassLoader loader) {
        super(loader);
    }

    public TreeLoader(ClassLoader loader, Path dir) {
        super(loader);
        this._dir = dir;
        this.init();
    }

    public void setPath(Path path) {
        this._dir = path;
    }

    public Path getPath() {
        return this._dir;
    }

    public static DynamicClassLoader create(ClassLoader parent, Path dir) {
        DynamicClassLoader loader = new DynamicClassLoader(parent);
        TreeLoader treeLoader = new TreeLoader(loader, dir);
        loader.addLoader(treeLoader);
        loader.init();
        return loader;
    }

    @PostConstruct
    public void init() {
        super.init();
        if (this._dir == null) {
            throw new ConfigException(L.l("<tree-loader> requires a 'path' attribute"));
        }
        this._dir.getLastModified();
        try {
            this._dir.list();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.fillJars();
        for (int i = 0; i < this._jarList.size(); ++i) {
            this.getClassLoader().addURL(((JarEntry)this._jarList.get(i)).getJarPath());
        }
    }

    public boolean logModified(Logger log) {
        if (this.isModified()) {
            log.info(this._dir.getNativePath() + " has modified jar files");
            return true;
        }
        return false;
    }

    private void fillJars() {
        this.clearJars();
        this.fillJars(this._dir);
    }

    private void fillJars(Path dir) {
        try {
            String[] list = dir.list();
            for (int j = 0; list != null && j < list.length; ++j) {
                Path path = dir.lookup(list[j]);
                if (list[j].endsWith(".jar") || list[j].endsWith(".zip")) {
                    this.addJar(path);
                    continue;
                }
                if (!path.isDirectory()) continue;
                this.fillJars(path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Path getCodePath() {
        return this._dir;
    }

    protected void destroy() {
        super.destroy();
        this.clearJars();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._dir + "]";
    }
}

