/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.enhancer;

import com.caucho.bytecode.ByteCodeParser;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaClassLoader;
import com.caucho.inject.Module;
import com.caucho.java.WorkDir;
import com.caucho.java.gen.GenClass;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.SimpleLoader;
import com.caucho.loader.enhancer.ClassEnhancer;
import com.caucho.loader.enhancer.EnhancerFixup;
import com.caucho.loader.enhancer.EnhancerPrepare;
import com.caucho.loader.enhancer.EnhancerRuntimeException;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class EnhancerManager
implements ClassFileTransformer {
    private static final L10N L = new L10N(EnhancerManager.class);
    private static final Logger log = Log.open(EnhancerManager.class);
    private static EnvironmentLocal<EnhancerManager> _localEnhancer = new EnvironmentLocal();
    private DynamicClassLoader _loader;
    private Path _workPath;
    private JavaClassLoader _jClassLoader = new JavaClassLoader();
    private JavaClassGenerator _javaGen = new JavaClassGenerator();
    private ArrayList<ClassEnhancer> _classEnhancerList = new ArrayList();

    private EnhancerManager(ClassLoader loader) {
        while (loader != null && !(loader instanceof DynamicClassLoader)) {
            loader = loader.getParent();
        }
        this._loader = (DynamicClassLoader)loader;
        if (loader != null) {
            EnhancerManager.getLocalEnhancer(loader.getParent());
        }
    }

    public static EnhancerManager create() {
        return EnhancerManager.create(Thread.currentThread().getContextClassLoader());
    }

    public static EnhancerManager create(ClassLoader loader) {
        EnhancerManager enhancer = _localEnhancer.getLevel(loader);
        if (enhancer == null) {
            enhancer = new EnhancerManager(loader);
            _localEnhancer.set(enhancer, loader);
            while (loader != null) {
                if (loader instanceof DynamicClassLoader) {
                    ((DynamicClassLoader)loader).addTransformer(enhancer);
                    break;
                }
                loader = loader.getParent();
            }
        }
        return enhancer;
    }

    public static EnhancerManager getLocalEnhancer(ClassLoader loader) {
        return _localEnhancer.get(loader);
    }

    public JavaClassLoader getJavaClassLoader() {
        return this._jClassLoader;
    }

    public Path getWorkPath() {
        if (this._workPath != null) {
            return this._workPath;
        }
        return WorkDir.getLocalWorkDir(this._loader);
    }

    public void setWorkPath(Path workPath) {
        this._workPath = workPath;
    }

    public final Path getPreWorkPath() {
        return this.getWorkPath().lookup("pre-enhance");
    }

    public final Path getPostWorkPath() {
        return this.getWorkPath().lookup("post-enhance");
    }

    public void addClassEnhancer(ClassEnhancer classEnhancer) {
        this._classEnhancerList.add(classEnhancer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> oldClass, ProtectionDomain domain, byte[] buffer) {
        if (this.isClassMatch(className)) {
            try {
                boolean isModified;
                block12: {
                    ClassLoader tempLoader = ((DynamicClassLoader)loader).getNewTempClassLoader();
                    DynamicClassLoader workLoader = SimpleLoader.create(tempLoader, this.getPostWorkPath());
                    workLoader.setServletHack(true);
                    isModified = true;
                    Thread thread = Thread.currentThread();
                    ClassLoader oldLoader = thread.getContextClassLoader();
                    try {
                        try {
                            Class<?> cl = Class.forName(className.replace('/', '.'), false, workLoader);
                            thread.setContextClassLoader(tempLoader);
                            Method init = cl.getMethod("_caucho_init", Path.class);
                            Method modified = cl.getMethod("_caucho_is_modified", new Class[0]);
                            init.invoke(null, Vfs.lookup());
                            isModified = (Boolean)modified.invoke(null, new Object[0]);
                        }
                        catch (Exception e) {
                            log.log(Level.FINEST, e.toString(), e);
                            Object var15_20 = null;
                            thread.setContextClassLoader(oldLoader);
                            break block12;
                        }
                        catch (Throwable e) {
                            log.log(Level.FINER, e.toString(), e);
                            Object var15_21 = null;
                            thread.setContextClassLoader(oldLoader);
                        }
                        Object var15_19 = null;
                        thread.setContextClassLoader(oldLoader);
                    }
                    catch (Throwable throwable) {
                        Object var15_22 = null;
                        thread.setContextClassLoader(oldLoader);
                        throw throwable;
                    }
                }
                if (!isModified) {
                    try {
                        return this.load(className);
                    }
                    catch (Exception e) {
                        log.log(Level.FINER, e.toString(), e);
                    }
                }
                ByteCodeParser parser = new ByteCodeParser();
                parser.setClassLoader(this._jClassLoader);
                ByteArrayInputStream is = new ByteArrayInputStream(buffer, 0, buffer.length);
                JavaClass jClass = parser.parse(is);
                return this.enhance(jClass);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EnhancerRuntimeException(e);
            }
        }
        return null;
    }

    public byte[] enhance(JClass jClass) throws ClassNotFoundException {
        String className = jClass.getName().replace('/', '.');
        String extClassName = className + "__ResinExt";
        try {
            EnhancerPrepare prepare = new EnhancerPrepare();
            prepare.setWorkPath(this.getWorkPath());
            prepare.setClassLoader(this._loader);
            for (ClassEnhancer enhancer : this._classEnhancerList) {
                if (!enhancer.shouldEnhance(className)) continue;
                prepare.addEnhancer(enhancer);
            }
            prepare.renameClass(className, className);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            throw new ClassNotFoundException(e.toString());
        }
        boolean hasEnhancer = false;
        GenClass genClass = new GenClass(extClassName);
        genClass.setSuperClassName(className);
        for (ClassEnhancer enhancer : this._classEnhancerList) {
            if (!enhancer.shouldEnhance(className)) continue;
            try {
                hasEnhancer = true;
                enhancer.enhance(genClass, jClass, extClassName);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            if (hasEnhancer) {
                this._javaGen.setWorkDir(this.getPreWorkPath());
                this._javaGen.generate(genClass);
                this._javaGen.compilePendingJava();
            }
            EnhancerFixup fixup = new EnhancerFixup();
            fixup.setJavaClassLoader(this._jClassLoader);
            fixup.setClassLoader(this._loader);
            fixup.setWorkPath(this.getWorkPath());
            for (ClassEnhancer enhancer : this._classEnhancerList) {
                if (!enhancer.shouldEnhance(className)) continue;
                fixup.addEnhancer(enhancer);
            }
            fixup.fixup(className, extClassName);
            return this.load(className);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            throw new ClassNotFoundException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] load(String className) throws IOException {
        Path path = this.getPostWorkPath().lookup(className.replace('.', '/') + ".class");
        int length = (int)path.getLength();
        if (length < 0) {
            throw new FileNotFoundException(L.l("Can't find class file '{0}'", path.getNativePath()));
        }
        byte[] buffer = new byte[length];
        ReadStream is = path.openRead();
        try {
            is.readAll(buffer, 0, buffer.length);
            Object var7_6 = null;
            is.close();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            is.close();
            throw throwable;
        }
        return buffer;
    }

    public boolean isClassMatch(String className) {
        if (className.lastIndexOf(36) >= 0) {
            int p = className.lastIndexOf(36);
            int ch = 0;
            if (p + 1 < className.length()) {
                ch = className.charAt(p + 1);
            }
            if (48 <= ch && ch <= 57) {
                return false;
            }
        } else if (className.indexOf(43) > 0 || className.indexOf(45) > 0) {
            return false;
        }
        for (int i = 0; i < this._classEnhancerList.size(); ++i) {
            if (!this._classEnhancerList.get(i).shouldEnhance(className)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._classEnhancerList + "]";
    }
}

