/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.ivy;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IvyPattern {
    private static final L10N L = new L10N(IvyPattern.class);
    private String _pattern;
    private ArrayList<Segment> _segments = new ArrayList();

    public IvyPattern(String pattern) {
        this._pattern = pattern;
        this.parse(pattern);
    }

    public String resolve(Map<String, String> props) {
        StringBuilder sb = new StringBuilder();
        for (Segment segment : this._segments) {
            segment.resolve(sb, props);
        }
        return sb.toString();
    }

    public String resolveRevisionPath(Map<String, String> props) {
        StringBuilder sb = new StringBuilder();
        for (Segment segment : this._segments) {
            if (segment instanceof VarSegment && "revision".equals(((VarSegment)segment).getVar())) {
                sb.append("[revision]");
                continue;
            }
            segment.resolve(sb, props);
        }
        return sb.toString();
    }

    private void parse(String pattern) {
        int len = pattern.length();
        int i = 0;
        while (i < len) {
            int head = pattern.indexOf(91, i);
            if (head < 0) {
                this._segments.add(new TextSegment(pattern.substring(i)));
                return;
            }
            int tail = pattern.indexOf(93, head);
            if (tail < 0) {
                throw new ConfigException(L.l("'{0}' is an invalid ivy pattern", pattern));
            }
            this._segments.add(new TextSegment(pattern.substring(i, head)));
            this._segments.add(new VarSegment(pattern.substring(head + 1, tail)));
            i = tail + 1;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._pattern + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VarSegment
    extends Segment {
        private final String _var;

        VarSegment(String var) {
            this._var = var;
        }

        String getVar() {
            return this._var;
        }

        @Override
        public void resolve(StringBuilder sb, Map<String, String> props) {
            sb.append(props.get(this._var));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TextSegment
    extends Segment {
        private final String _text;

        TextSegment(String text) {
            this._text = text;
        }

        @Override
        public void resolve(StringBuilder sb, Map<String, String> props) {
            sb.append(this._text);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Segment {
        Segment() {
        }

        public abstract void resolve(StringBuilder var1, Map<String, String> var2);
    }
}

