/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigELContext;
import com.caucho.config.ConfigException;
import com.caucho.config.scope.ThreadRequestFactory;
import com.caucho.config.types.RawString;
import com.caucho.el.AbstractVariableResolver;
import com.caucho.el.ELParser;
import com.caucho.el.Expr;
import com.caucho.log.MessageFormatter;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import java.util.AbstractMap;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.annotation.PostConstruct;
import javax.el.ELContext;
import javax.el.ELException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ELFormatter
extends MessageFormatter {
    private static final L10N L = new L10N(ELFormatter.class);
    private static final ThreadLocal<LogRecord> _threadLogRecord = new ThreadLocal();
    private final FreeList<ELContext> _freeContextList = new FreeList(8);
    private String _format;
    private Expr _expr;

    public void setFormat(RawString format) {
        this._format = format.getValue();
    }

    public String getFormat() {
        return this._format;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._format != null) {
            try {
                ELParser elParser = new ELParser(new ConfigELContext(), this._format);
                this._expr = elParser.parse();
            }
            catch (Exception ex) {
                throw ConfigException.create(ex);
            }
        }
    }

    public String format(LogRecord logRecord) {
        String ret;
        if (this._expr == null) {
            return super.format(logRecord);
        }
        if (this._expr == null) {
            ret = super.format(logRecord);
        } else {
            LogRecord oldLogRecord = _threadLogRecord.get();
            try {
                try {
                    _threadLogRecord.set(logRecord);
                    ELContext context = this._freeContextList.allocate();
                    if (context == null) {
                        ELFormatterVariableResolver vr = new ELFormatterVariableResolver();
                        context = new ConfigELContext(vr);
                    }
                    ret = this._expr.evalString(context);
                    this._freeContextList.free(context);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                Object var7_7 = null;
                _threadLogRecord.set(oldLogRecord);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                _threadLogRecord.set(oldLogRecord);
                throw throwable;
            }
        }
        return ret;
    }

    public static class CookieMap
    extends AbstractMap {
        private Cookie[] _cookies;

        CookieMap(Cookie[] cookies) {
            this._cookies = cookies;
        }

        public Object get(Object key) {
            for (Cookie cookie : this._cookies) {
                if (!cookie.getName().equals(key)) continue;
                return cookie;
            }
            return null;
        }

        public int size() {
            return this._cookies.length;
        }

        public Set entrySet() {
            return null;
        }
    }

    public class ELFormatterLogRecord {
        public String getMessage() {
            return ELFormatter.this.formatMessage(this.getLogRecord());
        }

        public String getName() {
            return this.getLogRecord().getLoggerName();
        }

        public String getLoggerName() {
            return this.getLogRecord().getLoggerName();
        }

        public String getShortName() {
            int index;
            String name = this.getLogRecord().getLoggerName();
            if (name != null && (index = name.lastIndexOf(46) + 1) > 0 && index < name.length()) {
                name = name.substring(index);
            }
            return name;
        }

        public Level getLevel() {
            return this.getLogRecord().getLevel();
        }

        public long getMillis() {
            return this.getLogRecord().getMillis();
        }

        public int getThreadID() {
            return this.getLogRecord().getThreadID();
        }

        public Throwable getThrown() {
            return this.getLogRecord().getThrown();
        }

        public long getSequenceNumber() {
            return this.getLogRecord().getSequenceNumber();
        }

        public String getSourceClassName() {
            return this.getLogRecord().getSourceClassName();
        }

        public String getShortSourceClassName() {
            int index;
            String name = this.getLogRecord().getSourceClassName();
            if (name != null && (index = name.lastIndexOf(46) + 1) > 0 && index < name.length()) {
                name = name.substring(index);
            }
            return name;
        }

        public String getSourceMethodName() {
            return this.getLogRecord().getSourceMethodName();
        }

        public String getRawMessage() {
            return this.getLogRecord().getMessage();
        }

        public ResourceBundle getResourceBundle() {
            return this.getLogRecord().getResourceBundle();
        }

        public String getResourceBundleName() {
            return this.getLogRecord().getResourceBundleName();
        }

        public Object[] getParameters() {
            return this.getLogRecord().getParameters();
        }

        private LogRecord getLogRecord() {
            return (LogRecord)_threadLogRecord.get();
        }
    }

    class ELFormatterVariableResolver
    extends AbstractVariableResolver {
        private ELFormatterLogRecord _logRecord;

        ELFormatterVariableResolver() {
            this._logRecord = new ELFormatterLogRecord();
        }

        public Object getValue(ELContext env, Object base, Object property) throws ELException {
            if (base != null || !(property instanceof String)) {
                return null;
            }
            if ("log".equals(property)) {
                env.setPropertyResolved(true);
                return this._logRecord;
            }
            if ("request".equals(property)) {
                env.setPropertyResolved(true);
                return ThreadRequestFactory.getCurrentHttpRequest();
            }
            if ("cookie".equals(property)) {
                Cookie[] cookies;
                env.setPropertyResolved(true);
                HttpServletRequest req = ThreadRequestFactory.getCurrentHttpRequest();
                if (req != null && (cookies = req.getCookies()) != null) {
                    return new CookieMap(cookies);
                }
                return null;
            }
            if ("session".equals(property)) {
                env.setPropertyResolved(true);
                HttpServletRequest req = ThreadRequestFactory.getCurrentHttpRequest();
                if (req != null) {
                    HttpSession session = req.getSession(false);
                    return session;
                }
                return null;
            }
            return null;
        }
    }
}

