/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.cfg.BeanConfig;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.Period;
import com.caucho.config.types.RawString;
import com.caucho.loader.CloseListener;
import com.caucho.loader.Environment;
import com.caucho.log.ELFormatter;
import com.caucho.log.EnvironmentLogger;
import com.caucho.log.PathHandler;
import com.caucho.log.TimestampFormatter;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

@Configurable
public class LogHandlerConfig
extends BeanConfig {
    private static final L10N L = new L10N(LogHandlerConfig.class);
    private Level _level;
    private Formatter _formatter;
    private Filter _filter;
    private Handler _handler;
    private String _timestamp = "[%Y/%m/%d %H:%M:%S.%s] {%{thread}} ";
    private PathHandler _pathHandler;

    public LogHandlerConfig() {
        this.setBeanConfigClass(Handler.class);
    }

    protected String getDefaultScope() {
        return null;
    }

    protected String getCdiNamed() {
        return null;
    }

    public void setId(String name) {
        if (name.equals("/")) {
            name = "";
        }
        this.setName(name);
    }

    public void setPath(Path path) {
        if (this._pathHandler == null) {
            this._pathHandler = new PathHandler();
        }
        this._pathHandler.setPath(path);
    }

    public void setPathFormat(String pathFormat) {
        if (this._pathHandler == null) {
            this._pathHandler = new PathHandler();
        }
        this._pathHandler.setPathFormat(pathFormat);
    }

    public void setArchiveFormat(String archiveFormat) {
        if (this._pathHandler == null) {
            this._pathHandler = new PathHandler();
        }
        this._pathHandler.setArchiveFormat(archiveFormat);
    }

    public void setRolloverPeriod(Period rolloverPeriod) {
        if (this._pathHandler == null) {
            this._pathHandler = new PathHandler();
        }
        this._pathHandler.setRolloverPeriod(rolloverPeriod);
    }

    public void setRolloverSize(Bytes size) {
        if (this._pathHandler == null) {
            this._pathHandler = new PathHandler();
        }
        this._pathHandler.setRolloverSize(size);
    }

    public void setRolloverCount(int count) {
        if (this._pathHandler == null) {
            this._pathHandler = new PathHandler();
        }
        this._pathHandler.setRolloverCount(count);
    }

    public void setUseParentHandlers(boolean useParentHandlers) throws ConfigException {
    }

    public void setLevel(Level level) throws ConfigException {
        this._level = level;
    }

    public String getLevel() {
        if (this._level != null) {
            return this._level.getName();
        }
        return Level.ALL.getName();
    }

    public void setTimestamp(String timestamp) {
        this._timestamp = timestamp;
    }

    public void setFormat(RawString format) {
        if (this._formatter == null) {
            this._formatter = new ELFormatter();
        }
        if (this._formatter instanceof ELFormatter) {
            ((ELFormatter)this._formatter).setFormat(format);
        }
    }

    public String getFormat() {
        if (this._formatter != null && this._formatter instanceof ELFormatter) {
            return ((ELFormatter)this._formatter).getFormat();
        }
        return null;
    }

    public void setFormatter(Formatter formatter) {
        this._formatter = formatter;
    }

    public void setFilter(Filter filter) {
        this._filter = filter;
    }

    public String getTagName() {
        return "log-handler";
    }

    @Configurable
    public void add(Handler handler) {
        this._handler = handler;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._handler == null && this._pathHandler == null) {
            super.init();
            this._handler = (Handler)this.getObject();
        }
        if (this._formatter instanceof ELFormatter) {
            ((ELFormatter)this._formatter).init();
        }
        if (this._timestamp != null) {
            if (this._pathHandler != null) {
                this._pathHandler.setTimestamp(this._timestamp);
            } else if (this._formatter == null) {
                TimestampFormatter formatter = new TimestampFormatter();
                this._formatter = formatter;
                formatter.setTimestamp(this._timestamp);
            }
        }
        if (this._pathHandler != null) {
            this._pathHandler.init();
            this._handler = this._pathHandler;
        }
        if (this._handler == null) {
            throw new ConfigException(L.l("<log-handler> requires a configured log handler"));
        }
        Logger logger = Logger.getLogger(this.getName());
        if (!(logger instanceof EnvironmentLogger)) {
            CloseListener listener = new CloseListener(this._handler);
            Environment.addClassLoaderListener(listener);
        }
        if (this._level != null) {
            this._handler.setLevel(this._level);
        }
        if (this._formatter != null) {
            this._handler.setFormatter(this._formatter);
        }
        if (this._filter != null) {
            this._handler.setFilter(this._filter);
        }
        logger.addHandler(this._handler);
    }

    static Level toLevel(String level) throws ConfigException {
        if (level.equals("off")) {
            return Level.OFF;
        }
        if (level.equals("severe")) {
            return Level.SEVERE;
        }
        if (level.equals("warning")) {
            return Level.WARNING;
        }
        if (level.equals("info")) {
            return Level.INFO;
        }
        if (level.equals("config")) {
            return Level.CONFIG;
        }
        if (level.equals("fine")) {
            return Level.FINE;
        }
        if (level.equals("finer")) {
            return Level.FINER;
        }
        if (level.equals("finest")) {
            return Level.FINEST;
        }
        if (level.equals("all")) {
            return Level.ALL;
        }
        try {
            return Level.parse(level);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(L.l("`{0}' is an unknown log level.  Log levels are:\noff - disable logging\nsevere - severe errors only\nwarning - warnings\ninfo - information\nconfig - configuration\nfine - fine debugging\nfiner - finer debugging\nfinest - finest debugging\nall - all debugging\n[-]?[0-9]+ - custom level", level));
        }
    }
}

