/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.EnvironmentLogger;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.LogManager;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogManagerImpl
extends LogManager {
    private static final String LOG_LOCAL = "caucho.log.manager";
    private static final HashMap<String, SoftReference<EnvironmentLogger>> _envLoggers = new HashMap();
    private static final EnvironmentLocal<HashMap<String, Logger>> _localLoggers = new EnvironmentLocal();

    @Override
    public synchronized boolean addLogger(Logger logger) {
        String name = logger.getName();
        EnvironmentLogger envLogger = null;
        SoftReference<EnvironmentLogger> loggerRef = _envLoggers.get(name);
        if (loggerRef != null) {
            envLogger = loggerRef.get();
        }
        if (envLogger == null) {
            envLogger = new EnvironmentLogger(name, logger.getResourceBundleName());
            _envLoggers.put(name, new SoftReference<EnvironmentLogger>(envLogger));
            EnvironmentLogger parent = this.buildParentTree(name);
            if (parent != null) {
                envLogger.setParent(parent);
            }
        }
        if (!logger.getClass().equals(Logger.class)) {
            return envLogger.addCustomLogger(logger);
        }
        return false;
    }

    private EnvironmentLogger buildParentTree(String childName) {
        if (childName == null || childName.equals("")) {
            return null;
        }
        int p = childName.lastIndexOf(46);
        String parentName = p > 0 ? childName.substring(0, p) : "";
        EnvironmentLogger parent = null;
        SoftReference<EnvironmentLogger> parentRef = _envLoggers.get(parentName);
        if (parentRef != null) {
            parent = parentRef.get();
        }
        if (parent != null) {
            return parent;
        }
        parent = new EnvironmentLogger(parentName, null);
        _envLoggers.put(parentName, new SoftReference<EnvironmentLogger>(parent));
        EnvironmentLogger grandparent = this.buildParentTree(parentName);
        if (grandparent != null) {
            parent.setParent(grandparent);
        }
        return parent;
    }

    @Override
    public synchronized Logger getLogger(String name) {
        SoftReference<EnvironmentLogger> envLoggerRef = _envLoggers.get(name);
        EnvironmentLogger envLogger = null;
        if (envLoggerRef != null) {
            envLogger = envLoggerRef.get();
        }
        if (envLogger == null) {
            return null;
        }
        Logger customLogger = envLogger.getLogger();
        if (customLogger != null) {
            return customLogger;
        }
        return envLogger;
    }

    @Override
    public Enumeration<String> getLoggerNames() {
        return Collections.enumeration(_envLoggers.keySet());
    }

    @Override
    public void reset() {
    }
}

