/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class LoggerConfig {
    private static final L10N L = new L10N(LoggerConfig.class);
    private Logger _logger;
    private Level _level = Level.INFO;
    private Boolean _useParentHandlers;
    private Filter _filter;
    private ArrayList<Handler> _handlerList = new ArrayList();

    public void setName(String name) {
        this._logger = Logger.getLogger(name);
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this._useParentHandlers = new Boolean(useParentHandlers);
    }

    public void setLevel(String level) throws ConfigException {
        if (level.equals("off")) {
            this._level = Level.OFF;
        } else if (level.equals("severe")) {
            this._level = Level.SEVERE;
        } else if (level.equals("warning")) {
            this._level = Level.WARNING;
        } else if (level.equals("info")) {
            this._level = Level.INFO;
        } else if (level.equals("config")) {
            this._level = Level.CONFIG;
        } else if (level.equals("fine")) {
            this._level = Level.FINE;
        } else if (level.equals("finer")) {
            this._level = Level.FINER;
        } else if (level.equals("finest")) {
            this._level = Level.FINEST;
        } else if (level.equals("all")) {
            this._level = Level.ALL;
        } else {
            try {
                this._level = Level.parse(level);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigException(L.l("`{0}' is an unknown log level.  Log levels are:\noff - disable logging\nsevere - severe errors only\nwarning - warnings\ninfo - information\nconfig - configuration\nfine - fine debugging\nfiner - finer debugging\nfinest - finest debugging\nall - all debugging\n[-]?[0-9]+ - custom level", level));
            }
        }
    }

    public void add(Handler handler) {
        this._handlerList.add(handler);
    }

    public void add(Filter filter) {
        this._filter = filter;
    }

    @PostConstruct
    public void init() {
        if (this._logger == null) {
            throw new ConfigException(L.l("<logger> requires a 'name' attribute."));
        }
        if (this._level != null) {
            this._logger.setLevel(this._level);
        }
        if (this._useParentHandlers != null) {
            this._logger.setUseParentHandlers(this._useParentHandlers);
        }
        for (Handler handler : this._handlerList) {
            this._logger.addHandler(handler);
        }
        if (this._filter != null) {
            this._logger.setFilter(this._filter);
        }
    }
}

