/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.Period;
import com.caucho.log.AbstractRolloverLog;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.WeakAlarm;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RotateStream
extends StreamImpl
implements AlarmListener {
    private static final Logger log = Logger.getLogger(RotateStream.class.getName());
    private static HashMap<Path, WeakReference<RotateStream>> _streams = new HashMap();
    private static HashMap<String, WeakReference<RotateStream>> _formatStreams = new HashMap();
    private final AbstractRolloverLog _rolloverLog = new AbstractRolloverLog();
    private final Alarm _alarm = new WeakAlarm(this);
    private volatile boolean _isInit;
    private volatile boolean _isClosed;

    private RotateStream(Path path) {
        this._rolloverLog.setPath(path);
    }

    private RotateStream(String formatPath) throws ConfigException {
        this._rolloverLog.setPathFormat(formatPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RotateStream create(Path path) {
        HashMap<Path, WeakReference<RotateStream>> hashMap = _streams;
        synchronized (hashMap) {
            RotateStream stream;
            WeakReference<RotateStream> ref = _streams.get(path);
            RotateStream rotateStream = stream = ref != null ? (RotateStream)ref.get() : null;
            if (stream == null) {
                stream = new RotateStream(path);
                _streams.put(path, new WeakReference<RotateStream>(stream));
            }
            return stream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RotateStream create(String path) throws ConfigException {
        HashMap<String, WeakReference<RotateStream>> hashMap = _formatStreams;
        synchronized (hashMap) {
            RotateStream stream;
            WeakReference<RotateStream> ref = _formatStreams.get(path);
            RotateStream rotateStream = stream = ref != null ? (RotateStream)ref.get() : null;
            if (stream == null) {
                stream = new RotateStream(path);
                _formatStreams.put(path, new WeakReference<RotateStream>(stream));
            }
            return stream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        RotateStream stream;
        HashMap<Object, WeakReference<RotateStream>> hashMap = _streams;
        synchronized (hashMap) {
            for (WeakReference<RotateStream> streamRef : _streams.values()) {
                try {
                    stream = (RotateStream)streamRef.get();
                    if (stream == null) continue;
                    stream.closeImpl();
                }
                catch (Throwable e) {}
            }
            _streams.clear();
        }
        hashMap = _formatStreams;
        synchronized (hashMap) {
            for (WeakReference<RotateStream> streamRef : _formatStreams.values()) {
                try {
                    stream = (RotateStream)streamRef.get();
                    if (stream == null) continue;
                    stream.closeImpl();
                }
                catch (Throwable throwable) {}
            }
            _formatStreams.clear();
        }
    }

    public AbstractRolloverLog getRolloverLog() {
        return this._rolloverLog;
    }

    public void setMaxRolloverCount(int count) {
        this._rolloverLog.setRolloverCount(count);
    }

    public void setRolloverPeriod(long period) {
        this._rolloverLog.setRolloverPeriod(new Period(period));
    }

    public void setRolloverSize(long size) {
        this._rolloverLog.setRolloverSize(new Bytes(size));
    }

    public void setArchiveFormat(String format) {
        this._rolloverLog.setArchiveFormat(format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        RotateStream rotateStream = this;
        synchronized (rotateStream) {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
        }
        this._rolloverLog.init();
        this._alarm.queueAt(this._rolloverLog.getNextRolloverCheckTime());
    }

    public Path getPath() {
        return this._rolloverLog.getPath();
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] buffer, int offset, int length, boolean isEnd) throws IOException {
        this._rolloverLog.rollover();
        this._rolloverLog.write(buffer, offset, length);
        this._rolloverLog.rollover();
    }

    public WriteStream getStream() {
        return new WriteStream(this);
    }

    public void flush() throws IOException {
        this._rolloverLog.flush();
        this._rolloverLog.rollover();
        this._alarm.queueAt(this._rolloverLog.getNextRolloverCheckTime());
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleAlarm(Alarm alarm) {
        long now22;
        try {
            try {
                this._rolloverLog.flush();
                this._rolloverLog.rollover();
            }
            catch (Throwable e) {
                long now22;
                e.printStackTrace();
                log.log(Level.FINE, e.toString(), e);
                Object var4_3 = null;
                if (this._isClosed) return;
                long nextTime = this._rolloverLog.getNextRolloverCheckTime();
                long delta = nextTime - (now22 = Alarm.getCurrentTime());
                if (delta < 60000L) {
                    delta = 60000L;
                }
                this._alarm.queue(delta);
                return;
            }
            Object var4_2 = null;
            if (this._isClosed) return;
        }
        catch (Throwable throwable) {
            long now22;
            Object var4_4 = null;
            if (this._isClosed) throw throwable;
            long nextTime = this._rolloverLog.getNextRolloverCheckTime();
            long delta = nextTime - (now22 = Alarm.getCurrentTime());
            if (delta < 60000L) {
                delta = 60000L;
            }
            this._alarm.queue(delta);
            throw throwable;
        }
        long nextTime = this._rolloverLog.getNextRolloverCheckTime();
        long delta = nextTime - (now22 = Alarm.getCurrentTime());
        if (delta < 60000L) {
            delta = 60000L;
        }
        this._alarm.queue(delta);
    }

    private void closeImpl() {
        try {
            this._isClosed = true;
            this._rolloverLog.close();
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void finalize() {
        this.closeImpl();
    }
}

