/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.make;

import com.caucho.loader.DynamicClassLoader;
import com.caucho.util.Alarm;
import com.caucho.vfs.Dependency;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyContainer
implements Dependency {
    private static Logger _log;
    private ArrayList<Dependency> _dependencyList = new ArrayList();
    private volatile boolean _isModified;
    private boolean _isModifiedLog;
    private long _checkInterval = 2000L;
    private volatile long _checkExpiresTime = 0L;
    private final AtomicBoolean _isChecking = new AtomicBoolean();

    public DependencyContainer() {
        this._checkInterval = DynamicClassLoader.getGlobalDependencyCheckInterval();
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof DynamicClassLoader)) continue;
            this._checkInterval = ((DynamicClassLoader)loader).getDependencyCheckInterval();
            break;
        }
    }

    public DependencyContainer add(Dependency dependency) {
        if (dependency == this) {
            throw new IllegalArgumentException("Can't add self as a dependency.");
        }
        if (!this._dependencyList.contains(dependency)) {
            this._dependencyList.add(dependency);
        }
        return this;
    }

    public DependencyContainer addAll(DependencyContainer container) {
        for (Dependency depend : container._dependencyList) {
            this.add(depend);
        }
        return this;
    }

    public DependencyContainer addAll(ArrayList<Dependency> dependencyList) {
        for (Dependency depend : dependencyList) {
            this.add(depend);
        }
        return this;
    }

    public ArrayList<Dependency> getDependencies() {
        return this._dependencyList;
    }

    public DependencyContainer remove(Dependency dependency) {
        if (dependency == this) {
            throw new IllegalArgumentException("Can't remove self as a dependency.");
        }
        this._dependencyList.remove(dependency);
        return this;
    }

    public int size() {
        return this._dependencyList.size();
    }

    public void setCheckInterval(long checkInterval) {
        this._checkInterval = checkInterval < 0L || checkInterval > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : checkInterval;
        this._checkExpiresTime = 0L;
    }

    public long getCheckInterval() {
        return this._checkInterval;
    }

    public void setModified(boolean isModified) {
        this._isModified = isModified;
        this._checkExpiresTime = this._isModified ? 0x3FFFFFFFFFFFFFFFL : Alarm.getCurrentTime() + this._checkInterval;
        if (!isModified) {
            this._isModifiedLog = false;
        }
    }

    public void resetDependencyCheckInterval() {
        this._checkExpiresTime = 0L;
    }

    public void clearModified() {
        this.setModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isModified() {
        boolean bl;
        long now = Alarm.getCurrentTime();
        if (now < this._checkExpiresTime) {
            return this._isModified;
        }
        if (this._isChecking.getAndSet(true)) {
            return this._isModified;
        }
        try {
            this._checkExpiresTime = now + this._checkInterval;
            for (int i = this._dependencyList.size() - 1; i >= 0; --i) {
                Dependency dependency = this._dependencyList.get(i);
                if (!dependency.isModified()) continue;
                this.setModified(true);
                boolean bl2 = this._isModified;
                Object var7_5 = null;
                this._isChecking.set(false);
                return bl2;
            }
            bl = this._isModified;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this._isChecking.set(false);
            throw throwable;
        }
        Object var7_6 = null;
        this._isChecking.set(false);
        return bl;
    }

    @Override
    public boolean logModified(Logger log) {
        if (this._isModifiedLog) {
            return true;
        }
        for (int i = this._dependencyList.size() - 1; i >= 0; --i) {
            Dependency dependency = this._dependencyList.get(i);
            if (!dependency.logModified(log)) continue;
            this._isModifiedLog = true;
            return true;
        }
        return false;
    }

    public boolean isModifiedNow() {
        this._checkExpiresTime = 0L;
        return this.isModified();
    }

    private Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(DependencyContainer.class.getName());
        }
        return _log;
    }

    public String toString() {
        return "DependencyContainer" + this._dependencyList;
    }
}

