/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.env.service.AbstractResinService;
import com.caucho.env.service.ResinSystem;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.network.listen.SocketLinkListener;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenService
extends AbstractResinService {
    private static final L10N L = new L10N(ListenService.class);
    private static final Logger log = Logger.getLogger(ListenService.class.getName());
    public static final int START_PRIORITY_LISTEN = 2000;
    public static final int START_PRIORITY_CLUSTER = 2100;
    private final ResinSystem _server;
    private final ArrayList<SocketLinkListener> _listeners = new ArrayList();
    private final ContainerProgram _listenDefaults = new ContainerProgram();
    private final Lifecycle _lifecycle = new Lifecycle();
    private AtomicBoolean _isStartedListeners = new AtomicBoolean();

    public ListenService(ResinSystem server) {
        this._server = server;
    }

    public SocketLinkListener createListener() {
        SocketLinkListener listener = new SocketLinkListener();
        this.applyListenerDefaults(listener);
        return listener;
    }

    public void addListener(SocketLinkListener listener) {
        try {
            if (this._listeners.contains(listener)) {
                throw new IllegalStateException(L.l("listener '{0}' has already been registered", listener));
            }
            this._listeners.add(listener);
            if (this._lifecycle.getState().isAfterStarting()) {
                listener.bind();
                listener.start();
            }
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public Collection<SocketLinkListener> getListeners() {
        return Collections.unmodifiableList(this._listeners);
    }

    private void applyListenerDefaults(SocketLinkListener port) {
        this._listenDefaults.configure(port);
    }

    @Override
    public int getStartPriority() {
        return 2000;
    }

    @Override
    public void start() throws Exception {
        this.bindListeners();
        this.startListeners();
    }

    @Override
    public void stop() throws Exception {
        ArrayList<SocketLinkListener> listeners = this._listeners;
        for (int i = 0; i < listeners.size(); ++i) {
            SocketLinkListener listener = listeners.get(i);
            try {
                listener.close();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindListeners() throws Exception {
        if (this._isStartedListeners.getAndSet(true)) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._server.getClassLoader());
            ArrayList<SocketLinkListener> listeners = this._listeners;
            boolean isFirst = true;
            for (int i = 0; i < listeners.size(); ++i) {
                SocketLinkListener listener = listeners.get(i);
                if (listener.isAfterBind()) continue;
                if (isFirst) {
                    log.info("");
                    isFirst = false;
                }
                listener.bind();
            }
            if (!isFirst) {
                log.info("");
            }
            Object var8_7 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startListeners() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._server.getClassLoader());
            ArrayList<SocketLinkListener> listeners = this._listeners;
            for (int i = 0; i < listeners.size(); ++i) {
                SocketLinkListener listener = listeners.get(i);
                listener.start();
            }
            Object var7_6 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }
}

