/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.inject.Module;
import com.caucho.network.listen.AsyncController;
import com.caucho.network.listen.SocketLinkDuplexListener;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.util.Alarm;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
public class SocketLinkDuplexController
extends AsyncController {
    private static final L10N L = new L10N(SocketLinkDuplexController.class);
    private static final Logger log = Logger.getLogger(SocketLinkDuplexController.class.getName());
    private ClassLoader _loader;
    private TcpSocketLink _conn;
    private ReadStream _is;
    private WriteStream _os;
    private SocketLinkDuplexListener _listener;
    private String _readThreadName;

    public SocketLinkDuplexController(TcpSocketLink conn, SocketLinkDuplexListener handler) {
        if (handler == null) {
            throw new NullPointerException(L.l("handler is a required argument"));
        }
        this._conn = conn;
        this._listener = handler;
        this._loader = Thread.currentThread().getContextClassLoader();
        this._is = this._conn.getReadStream();
        this._os = this._conn.getWriteStream();
        this._readThreadName = "resin-" + this._listener.getClass().getSimpleName() + "-read-" + conn.getId();
    }

    public boolean isDuplex() {
        return true;
    }

    public void setIdleTimeMax(long idleTime) {
        TcpSocketLink conn;
        if (idleTime < 0L || 0x3FFFFFFFFFFFFFFFL < idleTime) {
            idleTime = 0x3FFFFFFFFFFFFFFFL;
        }
        if ((conn = this._conn) != null) {
            conn.setIdleTimeout(idleTime);
        }
    }

    public long getIdleTimeMax() {
        TcpSocketLink conn = this._conn;
        if (conn != null) {
            return conn.getIdleTimeout();
        }
        return -1L;
    }

    public TcpSocketLink getSocketLink() {
        return this._conn;
    }

    public ReadStream getReadStream() {
        return this._is;
    }

    public WriteStream getWriteStream() {
        return this._os;
    }

    public SocketLinkDuplexListener getHandler() {
        return this._listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean serviceRead() {
        Thread thread = Thread.currentThread();
        boolean isValid = false;
        String oldName = thread.getName();
        try {
            thread.setName(this._readThreadName);
            thread.setContextClassLoader(this._loader);
            TcpSocketLink conn = this._conn;
            ReadStream is = this._is;
            SocketLinkDuplexListener handler = this._listener;
            if (conn == null || is == null || handler == null) {
                boolean bl = false;
                return bl;
            }
            if (is.getAvailable() > 0) {
                isValid = true;
                handler.onRead(this);
                boolean bl = true;
                return bl;
            }
            handler.onComplete(this);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            thread.setName(oldName);
            if (!isValid) {
                this.close();
            }
        }
        return true;
    }

    public void complete() {
        this.close();
    }

    public void close() {
        this.closeImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeImpl() {
        ReadStream is = this._is;
        this._is = null;
        TcpSocketLink conn = this._conn;
        this._conn = null;
        SocketLinkDuplexListener listener = this._listener;
        this._listener = null;
        ClassLoader loader = this._loader;
        this._loader = null;
        this._os = null;
        IoUtil.close(is);
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        super.closeImpl();
        if (listener != null) {
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(loader);
                listener.onComplete(this);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
        }
    }

    public String toString() {
        TcpSocketLink conn = this._conn;
        if (conn == null) {
            return this.getClass().getSimpleName() + "[" + this._listener + ",closed]";
        }
        if (Alarm.isTest()) {
            return this.getClass().getSimpleName() + "[" + this._listener + "]";
        }
        return this.getClass().getSimpleName() + "[" + conn.getId() + "," + this._listener + "]";
    }
}

