/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.types.Period;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.thread.TaskWorker;
import com.caucho.env.thread.ThreadPool;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.management.server.PortMXBean;
import com.caucho.management.server.TcpConnectionInfo;
import com.caucho.network.listen.AbstractSelectManager;
import com.caucho.network.listen.AsyncController;
import com.caucho.network.listen.Protocol;
import com.caucho.network.listen.SocketLinkAdmin;
import com.caucho.network.listen.SocketPollService;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.network.listen.Throttle;
import com.caucho.server.cluster.Server;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.vfs.JsseSSLFactory;
import com.caucho.vfs.QJniServerSocket;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.SSLFactory;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

@Configurable
public class SocketLinkListener
extends TaskWorker
implements Runnable {
    private static final L10N L = new L10N(SocketLinkListener.class);
    private static final Logger log = Logger.getLogger(SocketLinkListener.class.getName());
    private final AtomicInteger _connectionCount = new AtomicInteger();
    private FreeList<TcpSocketLink> _idleConn = new FreeList(32);
    private ThreadPool _threadPool = ThreadPool.getThreadPool();
    private ClassLoader _classLoader = Thread.currentThread().getContextClassLoader();
    private String _serverId = "";
    private String _address;
    private int _port = -1;
    private String _url;
    private Protocol _protocol;
    private SSLFactory _sslFactory;
    private boolean _isSecure;
    private InetAddress _socketAddress;
    private int _idleThreadMin = 2;
    private int _idleThreadMax = 20;
    private int _acceptListenBacklog = 1000;
    private int _connectionMax = 0x100000;
    private int _keepaliveMax = -1;
    private long _keepaliveTimeMax = 600000L;
    private long _keepaliveTimeout = 120000L;
    private boolean _isKeepaliveSelectEnable = true;
    private long _keepaliveSelectThreadTimeout = 1000L;
    private long _socketTimeout = 120000L;
    private long _suspendReaperTimeout = 60000L;
    private long _suspendTimeMax = 600000L;
    private long _suspendCloseTimeMax = 120000L;
    private boolean _tcpNoDelay = true;
    private boolean _isEnableJni = true;
    private String _virtualHost;
    private final SocketLinkAdmin _admin = new SocketLinkAdmin(this);
    private QServerSocket _serverSocket;
    private Throttle _throttle;
    private AbstractSelectManager _selectManager;
    private Set<TcpSocketLink> _activeConnectionSet = Collections.synchronizedSet(new HashSet());
    private final AtomicInteger _activeConnectionCount = new AtomicInteger();
    private Set<TcpSocketLink> _suspendConnectionSet = Collections.synchronizedSet(new HashSet());
    private final AtomicInteger _idleThreadCount = new AtomicInteger();
    private final AtomicInteger _startThreadCount = new AtomicInteger();
    private final AtomicInteger _shutdownRequestCount = new AtomicInteger();
    private Alarm _suspendAlarm;
    private final AtomicInteger _threadCount = new AtomicInteger();
    private volatile long _lifetimeRequestCount;
    private volatile long _lifetimeKeepaliveCount;
    private volatile long _lifetimeClientDisconnectCount;
    private volatile long _lifetimeRequestTime;
    private volatile long _lifetimeReadBytes;
    private volatile long _lifetimeWriteBytes;
    private AtomicInteger _keepaliveAllocateCount = new AtomicInteger();
    private AtomicInteger _keepaliveThreadCount = new AtomicInteger();
    private final AtomicBoolean _isBind = new AtomicBoolean();
    private final AtomicBoolean _isPostBind = new AtomicBoolean();
    private final Lifecycle _lifecycle = new Lifecycle();

    public SocketLinkListener() {
        if ("64".equals(System.getProperty("sun.arch.data.model"))) {
            this._keepaliveSelectThreadTimeout = 60000L;
        }
    }

    @Deprecated
    public void setId(String id) {
    }

    public String getDebugId() {
        return this.getUrl();
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public PortMXBean getAdmin() {
        return this._admin;
    }

    public void setProtocol(Protocol protocol) throws ConfigException {
        this._protocol = protocol;
    }

    public Protocol getProtocol() {
        return this._protocol;
    }

    public String getProtocolName() {
        if (this._protocol != null) {
            return this._protocol.getProtocolName();
        }
        return null;
    }

    @Configurable
    public void setAddress(String address) throws UnknownHostException {
        if ("*".equals(address)) {
            address = null;
        }
        this._address = address;
        if (address != null) {
            this._socketAddress = InetAddress.getByName(address);
        }
    }

    public String getAddress() {
        return this._address;
    }

    public void setHost(String address) throws UnknownHostException {
        this.setAddress(address);
    }

    @Configurable
    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public int getLocalPort() {
        if (this._serverSocket != null) {
            return this._serverSocket.getLocalPort();
        }
        return this._port;
    }

    @Configurable
    public void setVirtualHost(String host) {
        this._virtualHost = host;
    }

    public String getVirtualHost() {
        return this._virtualHost;
    }

    public void setSSL(SSLFactory factory) {
        this._sslFactory = factory;
    }

    @Configurable
    public SSLFactory createOpenssl() throws ConfigException {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName("com.caucho.vfs.OpenSSLFactory", false, loader);
            this._sslFactory = (SSLFactory)cl.newInstance();
            return this._sslFactory;
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.log(Level.FINER, e.toString(), e);
            throw new ConfigException(L.l("<openssl> requires Resin Professional.  See http://www.caucho.com for more information."), e);
        }
    }

    public JsseSSLFactory createJsse() {
        return new JsseSSLFactory();
    }

    public void setJsseSsl(JsseSSLFactory factory) {
        this._sslFactory = factory;
    }

    public SSLFactory getSSL() {
        return this._sslFactory;
    }

    public boolean isSSL() {
        return this._sslFactory != null;
    }

    @Configurable
    public void setSecure(boolean isSecure) {
        this._isSecure = isSecure;
    }

    public boolean isSecure() {
        return this._isSecure || this._sslFactory != null;
    }

    public void setServerSocket(QServerSocket socket) {
        this._serverSocket = socket;
    }

    @Configurable
    public void setAcceptThreadMin(int minSpare) throws ConfigException {
        if (minSpare < 1) {
            throw new ConfigException(L.l("accept-thread-min must be at least 1."));
        }
        this._idleThreadMin = minSpare;
    }

    public int getAcceptThreadMin() {
        return this._idleThreadMin;
    }

    @Configurable
    public void setAcceptThreadMax(int maxSpare) throws ConfigException {
        if (maxSpare < 1) {
            throw new ConfigException(L.l("accept-thread-max must be at least 1."));
        }
        this._idleThreadMax = maxSpare;
    }

    public int getAcceptThreadMax() {
        return this._idleThreadMax;
    }

    @Configurable
    public void setAcceptListenBacklog(int listen) throws ConfigException {
        if (listen < 1) {
            throw new ConfigException(L.l("accept-listen-backlog must be at least 1."));
        }
        this._acceptListenBacklog = listen;
    }

    public int getAcceptListenBacklog() {
        return this._acceptListenBacklog;
    }

    @Configurable
    public void setConnectionMax(int max) {
        this._connectionMax = max;
    }

    public int getConnectionMax() {
        return this._connectionMax;
    }

    @Configurable
    public void setSocketTimeout(Period period) {
        this._socketTimeout = period.getPeriod();
    }

    public void setSocketTimeoutMillis(long timeout) {
        this._socketTimeout = timeout;
    }

    public long getSocketTimeout() {
        return this._socketTimeout;
    }

    public boolean getTcpNoDelay() {
        return this._tcpNoDelay;
    }

    @Configurable
    public void setTcpNoDelay(boolean tcpNoDelay) {
        this._tcpNoDelay = tcpNoDelay;
    }

    @Configurable
    public void setThrottleConcurrentMax(int max) {
        Throttle throttle = this.createThrottle();
        if (throttle != null) {
            throttle.setMaxConcurrentRequests(max);
        }
    }

    public long getThrottleConcurrentMax() {
        if (this._throttle != null) {
            return this._throttle.getMaxConcurrentRequests();
        }
        return -1L;
    }

    public void setEnableJni(boolean isEnableJni) {
        this._isEnableJni = isEnableJni;
    }

    private Throttle createThrottle() {
        if (this._throttle == null) {
            this._throttle = Throttle.createPro();
            if (this._throttle == null && Server.getCurrent() != null && !Server.getCurrent().isWatchdog()) {
                throw new ConfigException(L.l("throttle configuration requires Resin Professional"));
            }
        }
        return this._throttle;
    }

    public void setKeepaliveMax(int max) {
        this._keepaliveMax = max;
    }

    public int getKeepaliveMax() {
        return this._keepaliveMax;
    }

    public void setKeepaliveConnectionTimeMax(Period period) {
        this._keepaliveTimeMax = period.getPeriod();
    }

    public long getKeepaliveConnectionTimeMax() {
        return this._keepaliveTimeMax;
    }

    protected void setKeepaliveConnectionTimeMaxMillis(long timeout) {
        this._keepaliveTimeMax = timeout;
    }

    public long getSuspendTimeMax() {
        return this._suspendTimeMax;
    }

    public void setSuspendTimeMax(Period period) {
        this._suspendTimeMax = period.getPeriod();
    }

    public void setKeepaliveTimeout(Period period) {
        this._keepaliveTimeout = period.getPeriod();
    }

    public long getKeepaliveTimeout() {
        return this._keepaliveTimeout;
    }

    protected void setKeepaliveTimeoutMillis(long timeout) {
        this._keepaliveTimeout = timeout;
    }

    public boolean isKeepaliveSelectEnabled() {
        return this._isKeepaliveSelectEnable;
    }

    public void setKeepaliveSelectEnabled(boolean isKeepaliveSelect) {
        this._isKeepaliveSelectEnable = isKeepaliveSelect;
    }

    public void setKeepaliveSelectEnable(boolean isKeepaliveSelect) {
        this.setKeepaliveSelectEnabled(isKeepaliveSelect);
    }

    public void setKeepaliveSelectMax(int max) {
    }

    public long getKeepaliveSelectThreadTimeout() {
        return this._keepaliveSelectThreadTimeout;
    }

    public void setKeepaliveSelectThreadTimeout(Period period) {
        this.setKeepaliveSelectThreadTimeoutMillis(period.getPeriod());
    }

    public void setKeepaliveSelectThreadTimeoutMillis(long timeout) {
        this._keepaliveSelectThreadTimeout = timeout;
    }

    public long getBlockingTimeoutForSelect() {
        long timeout = this._keepaliveSelectThreadTimeout;
        if (timeout <= 10L) {
            return timeout;
        }
        if (this._threadPool.getFreeThreadCount() < 64) {
            return 10L;
        }
        return timeout;
    }

    public int getKeepaliveSelectMax() {
        if (this.getSelectManager() != null) {
            return this.getSelectManager().getSelectMax();
        }
        return -1;
    }

    @Configurable
    public void addContentProgram(ConfigProgram program) {
    }

    public int getThreadCount() {
        return this._threadCount.get();
    }

    public int getActiveThreadCount() {
        return this._threadCount.get() - this._idleThreadCount.get();
    }

    public int getIdleThreadCount() {
        return this._idleThreadCount.get();
    }

    public int getStartThreadCount() {
        return this._startThreadCount.get();
    }

    public int getKeepaliveCount() {
        return this._keepaliveAllocateCount.get();
    }

    public Lifecycle getLifecycleState() {
        return this._lifecycle;
    }

    public boolean isAfterBind() {
        return this._isBind.get();
    }

    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    public int getActiveConnectionCount() {
        return this._threadCount.get() - this._idleThreadCount.get();
    }

    public int getKeepaliveConnectionCount() {
        return this.getKeepaliveCount();
    }

    public int getKeepaliveThreadCount() {
        return this._keepaliveThreadCount.get();
    }

    public int getSelectConnectionCount() {
        if (this._selectManager != null) {
            return this._selectManager.getSelectCount();
        }
        return -1;
    }

    private boolean isStartThreadRequired() {
        int shutdownCount;
        int idleCount;
        int startCount = this._startThreadCount.get();
        return startCount + (idleCount = this._idleThreadCount.get()) + (shutdownCount = this._shutdownRequestCount.get()) < this._idleThreadMin;
    }

    public String getServerSocketClassName() {
        QServerSocket ss = this._serverSocket;
        if (ss != null) {
            return ss.getClass().getName();
        }
        return null;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (!this._lifecycle.toInit()) {
            return;
        }
    }

    public String getUrl() {
        if (this._url == null) {
            StringBuilder url = new StringBuilder();
            if (this._protocol != null) {
                url.append(this._protocol.getProtocolName());
            } else {
                url.append("unknown");
            }
            url.append("://");
            if (this.getAddress() != null) {
                url.append(this.getAddress());
            } else {
                url.append("*");
            }
            url.append(":");
            url.append(this.getPort());
            if (this._serverId != null && !"".equals(this._serverId)) {
                url.append("(");
                url.append(this._serverId);
                url.append(")");
            }
            this._url = url.toString();
        }
        return this._url;
    }

    public void bind() throws Exception {
        if (this._isBind.getAndSet(true)) {
            return;
        }
        if (this._protocol == null) {
            throw new IllegalStateException(L.l("'{0}' must have a configured protocol before starting.", this));
        }
        if (this._port < 0) {
            return;
        }
        if (this._throttle == null) {
            this._throttle = new Throttle();
        }
        if (this._serverSocket != null) {
            if (this._address != null) {
                log.info("listening to " + this._address + ":" + this._serverSocket.getLocalPort());
            } else {
                log.info("listening to " + this._serverSocket.getLocalPort());
            }
        } else if (this._sslFactory != null && this._socketAddress != null) {
            this._serverSocket = this._sslFactory.create(this._socketAddress, this._port);
            log.info(this._protocol.getProtocolName() + "s listening to " + this._socketAddress.getHostName() + ":" + this._port);
        } else if (this._sslFactory != null) {
            if (this._address == null) {
                this._serverSocket = this._sslFactory.create(null, this._port);
                log.info(this._protocol.getProtocolName() + "s listening to *:" + this._port);
            } else {
                InetAddress addr = InetAddress.getByName(this._address);
                this._serverSocket = this._sslFactory.create(addr, this._port);
                log.info(this._protocol.getProtocolName() + "s listening to " + this._address + ":" + this._port);
            }
        } else if (this._socketAddress != null) {
            this._serverSocket = QJniServerSocket.create(this._socketAddress, this._port, this._acceptListenBacklog, this._isEnableJni);
            log.info(this._protocol.getProtocolName() + " listening to " + this._socketAddress.getHostName() + ":" + this._serverSocket.getLocalPort());
        } else {
            this._serverSocket = QJniServerSocket.create(null, this._port, this._acceptListenBacklog, this._isEnableJni);
            log.info(this._protocol.getProtocolName() + " listening to *:" + this._serverSocket.getLocalPort());
        }
        assert (this._serverSocket != null);
        this.postBind();
    }

    public void bind(QServerSocket ss) throws Exception {
        if (ss == null) {
            throw new NullPointerException();
        }
        this._isBind.set(true);
        if (this._protocol == null) {
            throw new IllegalStateException(L.l("'{0}' must have a configured protocol before starting.", this));
        }
        if (this._throttle == null) {
            this._throttle = new Throttle();
        }
        this._serverSocket = ss;
        String scheme = this._protocol.getProtocolName();
        if (this._address != null) {
            log.info(scheme + " listening to " + this._address + ":" + this._port);
        } else {
            log.info(scheme + " listening to *:" + this._port);
        }
        if (this._sslFactory != null) {
            this._serverSocket = this._sslFactory.bind(this._serverSocket);
        }
    }

    public void postBind() {
        SocketPollService pollService;
        ResinSystem server;
        if (this._isPostBind.getAndSet(true)) {
            return;
        }
        if (this._serverSocket == null) {
            return;
        }
        if (this._tcpNoDelay) {
            this._serverSocket.setTcpNoDelay(this._tcpNoDelay);
        }
        this._serverSocket.setConnectionSocketTimeout((int)this.getSocketTimeout());
        if (this._serverSocket.isJni() && (server = ResinSystem.getCurrent()) != null && (pollService = server.getService(SocketPollService.class)) != null) {
            this._selectManager = pollService.getSelectManager();
        }
        if (this._keepaliveMax < 0 && this._selectManager != null) {
            this._keepaliveMax = this._selectManager.getSelectMax();
        }
        if (this._keepaliveMax < 0) {
            this._keepaliveMax = 256;
        }
        this._admin.register();
    }

    public QServerSocket bindForWatchdog() throws IOException {
        QServerSocket ss;
        if (this._sslFactory instanceof JsseSSLFactory) {
            if (this._port < 1024) {
                log.warning(this + " cannot bind jsse in watchdog");
            }
            return null;
        }
        if (this._socketAddress != null) {
            ss = QJniServerSocket.createJNI(this._socketAddress, this._port);
            if (ss == null) {
                return null;
            }
            log.fine(this + " watchdog binding to " + this._socketAddress.getHostName() + ":" + this._port);
        } else {
            ss = QJniServerSocket.createJNI(null, this._port);
            if (ss == null) {
                return null;
            }
            log.fine(this + " watchdog binding to *:" + this._port);
        }
        if (!ss.isJni()) {
            ss.close();
            return ss;
        }
        if (this._tcpNoDelay) {
            ss.setTcpNoDelay(this._tcpNoDelay);
        }
        ss.setConnectionSocketTimeout((int)this.getSocketTimeout());
        return ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        if (this._port < 0) {
            return;
        }
        if (!this._lifecycle.toStarting()) {
            return;
        }
        boolean isValid = false;
        try {
            this.bind();
            this.postBind();
            this.enable();
            this.wake();
            this._suspendAlarm = new Alarm(new SuspendReaper());
            this._suspendAlarm.queue(this._suspendReaperTimeout);
            isValid = true;
        }
        finally {
            if (!isValid) {
                this.close();
            }
        }
    }

    void enable() {
        if (this._lifecycle.toActive() && this._serverSocket != null) {
            this._serverSocket.listen(this._acceptListenBacklog);
        }
    }

    void disable() {
        if (this._lifecycle.toStop()) {
            if (this._serverSocket != null) {
                this._serverSocket.listen(0);
            }
            if (this._port >= 0) {
                if (this._address != null) {
                    log.info(this._protocol.getProtocolName() + " disabled " + this._address + ":" + this.getLocalPort());
                } else {
                    log.info(this._protocol.getProtocolName() + " disabled *:" + this.getLocalPort());
                }
            }
        }
    }

    TcpConnectionInfo[] connectionInfo() {
        TcpSocketLink[] connections = new TcpSocketLink[this._activeConnectionSet.size()];
        this._activeConnectionSet.toArray(connections);
        long now = Alarm.getExactTime();
        TcpConnectionInfo[] infoList = new TcpConnectionInfo[connections.length];
        for (int i = 0; i < connections.length; ++i) {
            TcpConnectionInfo info;
            TcpSocketLink conn = connections[i];
            long requestTime = -1L;
            long startTime = conn.getRequestStartTime();
            if (conn.isRequestActive() && startTime > 0L) {
                requestTime = now - startTime;
            }
            infoList[i] = info = new TcpConnectionInfo(conn.getId(), conn.getThreadId(), this.getAddress() + ":" + this.getPort(), conn.getState().toString(), requestTime);
        }
        return infoList;
    }

    public AbstractSelectManager getSelectManager() {
        return this._selectManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(QSocket socket) {
        boolean isDecrementIdle = true;
        try {
            int idleThreadCount = this._idleThreadCount.incrementAndGet();
            while (this._lifecycle.isActive()) {
                idleThreadCount = this._idleThreadCount.get();
                if (this._idleThreadMax < idleThreadCount && this._idleThreadCount.compareAndSet(idleThreadCount, idleThreadCount - 1)) {
                    isDecrementIdle = false;
                    boolean bl = false;
                    return bl;
                }
                Thread.interrupted();
                if (!this._serverSocket.accept(socket)) continue;
                if (this._throttle.accept(socket)) {
                    boolean bl = true;
                    return bl;
                }
                socket.close();
            }
        }
        catch (Throwable e) {
            if (this._lifecycle.isActive() && log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        finally {
            if (isDecrementIdle) {
                this._idleThreadCount.decrementAndGet();
            }
            if (this.isStartThreadRequired()) {
                this.wake();
            }
        }
        return false;
    }

    void closeSocket(QSocket socket) {
        if (this._throttle != null) {
            this._throttle.close(socket);
        }
    }

    void startConnection(TcpSocketLink conn) {
        this._startThreadCount.decrementAndGet();
        if (this.isStartThreadRequired()) {
            this.wake();
        }
    }

    void requestShutdownBegin() {
        this._shutdownRequestCount.incrementAndGet();
    }

    void requestShutdownEnd() {
        this._shutdownRequestCount.decrementAndGet();
        if (this.isStartThreadRequired()) {
            this.wake();
        }
    }

    void threadBegin(TcpSocketLink conn) {
        this._threadCount.incrementAndGet();
    }

    void threadEnd(TcpSocketLink conn) {
        this._threadCount.decrementAndGet();
        this.wake();
    }

    boolean isKeepaliveAllowed(long connectionStartTime) {
        if (!this._lifecycle.isActive()) {
            return false;
        }
        if (connectionStartTime + this._keepaliveTimeMax < Alarm.getCurrentTime()) {
            return false;
        }
        return this._keepaliveMax > this._keepaliveAllocateCount.get();
    }

    void keepaliveAllocate() {
        this._keepaliveAllocateCount.incrementAndGet();
    }

    void keepaliveFree() {
        this._keepaliveAllocateCount.decrementAndGet();
    }

    int keepaliveThreadRead(ReadStream is) throws IOException {
        if (this.isClosed()) {
            return -1;
        }
        int available = is.getBufferAvailable();
        if (available > 0) {
            return available;
        }
        long timeout = this.getKeepaliveTimeout();
        if (this._isKeepaliveSelectEnable && this._selectManager != null) {
            timeout = this.getBlockingTimeoutForSelect();
        }
        if (this.getSocketTimeout() < timeout) {
            timeout = this.getSocketTimeout();
        }
        if (timeout < 0L) {
            timeout = 0L;
        }
        this._keepaliveThreadCount.incrementAndGet();
        try {
            int result;
            int n = result = is.fillWithTimeout(timeout);
            return n;
        }
        catch (IOException e) {
            if (this.isClosed()) {
                log.log(Level.FINEST, e.toString(), e);
                int n = -1;
                return n;
            }
            throw e;
        }
        finally {
            this._keepaliveThreadCount.decrementAndGet();
        }
    }

    void cometSuspend(TcpSocketLink conn) {
        if (conn.isWakeRequested()) {
            conn.toCometResume();
            this._threadPool.schedule(conn.getResumeTask());
        } else {
            this._suspendConnectionSet.add(conn);
        }
    }

    boolean cometDetach(TcpSocketLink conn) {
        return this._suspendConnectionSet.remove(conn);
    }

    boolean cometResume(TcpSocketLink conn) {
        if (this._suspendConnectionSet.remove(conn)) {
            conn.toCometResume();
            this._threadPool.schedule(conn.getResumeTask());
            return true;
        }
        return false;
    }

    void duplexKeepaliveBegin() {
    }

    void duplexKeepaliveEnd() {
    }

    public boolean isClosed() {
        return !this._lifecycle.getState().isRunnable();
    }

    public int getConnectionCount() {
        return this._activeConnectionCount.get();
    }

    public int getCometIdleCount() {
        return this._suspendConnectionSet.size();
    }

    public int getDuplexCount() {
        return 0;
    }

    void addLifetimeRequestCount() {
        ++this._lifetimeRequestCount;
    }

    public long getLifetimeRequestCount() {
        return this._lifetimeRequestCount;
    }

    void addLifetimeKeepaliveCount() {
        ++this._lifetimeKeepaliveCount;
    }

    public long getLifetimeKeepaliveCount() {
        return this._lifetimeKeepaliveCount;
    }

    void addLifetimeClientDisconnectCount() {
        ++this._lifetimeClientDisconnectCount;
    }

    public long getLifetimeClientDisconnectCount() {
        return this._lifetimeClientDisconnectCount;
    }

    void addLifetimeRequestTime(long time) {
        this._lifetimeRequestTime += time;
    }

    public long getLifetimeRequestTime() {
        return this._lifetimeRequestTime;
    }

    void addLifetimeReadBytes(long time) {
        this._lifetimeReadBytes += time;
    }

    public long getLifetimeReadBytes() {
        return this._lifetimeReadBytes;
    }

    void addLifetimeWriteBytes(long time) {
        this._lifetimeWriteBytes += time;
    }

    public long getLifetimeWriteBytes() {
        return this._lifetimeWriteBytes;
    }

    public TcpSocketLink findConnectionByThreadId(long threadId) {
        ArrayList<TcpSocketLink> connList = new ArrayList<TcpSocketLink>(this._activeConnectionSet);
        for (TcpSocketLink conn : connList) {
            if (conn.getThreadId() != threadId) continue;
            return conn;
        }
        return null;
    }

    public long runTask() {
        if (this._lifecycle.isDestroyed()) {
            return -1L;
        }
        try {
            TcpSocketLink startConn = null;
            if (this.isStartThreadRequired() && this._lifecycle.isActive() && this._activeConnectionCount.get() < this._connectionMax) {
                startConn = this._idleConn.allocate();
                if (startConn != null) {
                    startConn.toInit();
                } else {
                    int connId = this._connectionCount.incrementAndGet();
                    QSocket socket = this._serverSocket.createSocket();
                    startConn = new TcpSocketLink(connId, this, socket);
                }
                this._startThreadCount.incrementAndGet();
                this._activeConnectionCount.incrementAndGet();
                this._activeConnectionSet.add(startConn);
                if (!this._threadPool.schedule(startConn.getAcceptTask())) {
                    log.severe(L.l("Schedule failed for {0}", startConn));
                }
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, e.toString(), e);
        }
        return -1L;
    }

    void free(TcpSocketLink conn) {
        this.closeConnection(conn);
        this._idleConn.free(conn);
    }

    void destroy(TcpSocketLink conn) {
        this.closeConnection(conn);
    }

    private void closeConnection(TcpSocketLink conn) {
        this._activeConnectionSet.remove(conn);
        this._activeConnectionCount.decrementAndGet();
        this.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        TcpSocketLink conn;
        HashSet<TcpSocketLink> activeSet;
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " closing");
        }
        super.destroy();
        Alarm suspendAlarm = this._suspendAlarm;
        this._suspendAlarm = null;
        if (suspendAlarm != null) {
            suspendAlarm.dequeue();
        }
        QServerSocket serverSocket = this._serverSocket;
        this._serverSocket = null;
        this._selectManager = null;
        AbstractSelectManager selectManager = null;
        InetAddress localAddress = null;
        int localPort = 0;
        if (serverSocket != null) {
            localAddress = serverSocket.getLocalAddress();
            localPort = serverSocket.getLocalPort();
        }
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                QServerSocket e = serverSocket;
                synchronized (e) {
                    serverSocket.notifyAll();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (selectManager != null) {
            try {
                selectManager.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        Set<TcpSocketLink> set = this._activeConnectionSet;
        synchronized (set) {
            activeSet = new HashSet<TcpSocketLink>(this._activeConnectionSet);
        }
        for (TcpSocketLink conn2 : activeSet) {
            try {
                conn2.destroy();
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
            }
        }
        this.wake();
        if (localPort > 0) {
            int idleCount = this._idleThreadCount.get() + this._startThreadCount.get();
            for (int i = 0; i < idleCount + 10; ++i) {
                InetSocketAddress addr;
                if (localAddress == null || localAddress.getHostAddress().startsWith("0.")) {
                    addr = new InetSocketAddress("127.0.0.1", localPort);
                    this.connectAndClose(addr);
                    addr = new InetSocketAddress("[::1]", localPort);
                    this.connectAndClose(addr);
                    continue;
                }
                addr = new InetSocketAddress(localAddress, localPort);
                this.connectAndClose(addr);
            }
        }
        while ((conn = this._idleConn.allocate()) != null) {
            conn.destroy();
        }
        log.finest(this + " closed");
    }

    private void connectAndClose(InetSocketAddress addr) {
        try {
            Socket socket = new Socket();
            socket.connect(addr, 100);
            socket.close();
        }
        catch (ConnectException e) {
        }
        catch (Throwable e) {
            log.log(Level.FINEST, e.toString(), e);
        }
    }

    public String toURL() {
        return this.getUrl();
    }

    protected String getThreadName() {
        return "resin-port-" + this.getAddress() + ":" + this.getPort();
    }

    public String toString() {
        if (this._url != null) {
            return this.getClass().getSimpleName() + "[" + this._url + "]";
        }
        return this.getClass().getSimpleName() + "[" + this.getAddress() + ":" + this.getPort() + "]";
    }

    public class SuspendReaper
    implements AlarmListener {
        private ArrayList<TcpSocketLink> _suspendSet = new ArrayList();
        private ArrayList<TcpSocketLink> _timeoutSet = new ArrayList();
        private ArrayList<TcpSocketLink> _completeSet = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleAlarm(Alarm alarm) {
            try {
                TcpSocketLink conn;
                int i;
                this._suspendSet.clear();
                this._timeoutSet.clear();
                this._completeSet.clear();
                long now = Alarm.getCurrentTime();
                Set set = SocketLinkListener.this._suspendConnectionSet;
                synchronized (set) {
                    this._suspendSet.addAll(SocketLinkListener.this._suspendConnectionSet);
                }
                for (i = this._suspendSet.size() - 1; i >= 0; --i) {
                    conn = this._suspendSet.get(i);
                    if (conn.getIdleExpireTime() < now) {
                        this._timeoutSet.add(conn);
                        continue;
                    }
                    long idleStartTime = conn.getIdleStartTime();
                    if (idleStartTime + SocketLinkListener.this._suspendCloseTimeMax >= now || !conn.isReadEof()) continue;
                    this._completeSet.add(conn);
                }
                for (i = this._timeoutSet.size() - 1; i >= 0; --i) {
                    conn = this._timeoutSet.get(i);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this + " suspend idle timeout " + conn);
                    }
                    conn.toCometTimeout();
                }
                for (i = this._completeSet.size() - 1; i >= 0; --i) {
                    AsyncController async;
                    conn = this._completeSet.get(i);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(this + " async end-of-file " + conn);
                    }
                    if ((async = conn.getAsyncController()) == null) continue;
                    async.complete();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                if (!SocketLinkListener.this.isClosed()) {
                    alarm.queue(SocketLinkListener.this._suspendReaperTimeout);
                }
            }
        }
    }
}

