/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.inject.Module;
import com.caucho.network.listen.TcpSocketLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
enum SocketLinkState {
    INIT{

        SocketLinkState toInit() {
            return INIT;
        }

        SocketLinkState toAccept() {
            return ACCEPT;
        }
    }
    ,
    ACCEPT{

        boolean isActive() {
            return true;
        }

        SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveAllocate();
            return REQUEST_ACTIVE_KA;
        }

        SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
            return REQUEST_ACTIVE_NKA;
        }
    }
    ,
    REQUEST_READ{

        boolean isActive() {
            return true;
        }

        boolean isRequestActive() {
            return true;
        }

        SocketLinkState toKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveAllocate();
            return REQUEST_KEEPALIVE;
        }

        SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveAllocate();
            return REQUEST_ACTIVE_KA;
        }

        SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
            return REQUEST_ACTIVE_NKA;
        }
    }
    ,
    REQUEST_ACTIVE_KA{

        boolean isActive() {
            return true;
        }

        boolean isRequestActive() {
            return true;
        }

        boolean isKeepaliveAllocated() {
            return true;
        }

        SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
            return REQUEST_ACTIVE_KA;
        }

        SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return REQUEST_ACTIVE_NKA;
        }

        SocketLinkState toKillKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return REQUEST_ACTIVE_NKA;
        }

        SocketLinkState toKeepalive(TcpSocketLink conn) {
            return REQUEST_KEEPALIVE;
        }

        SocketLinkState toComet() {
            return COMET_KA;
        }

        SocketLinkState toDuplex(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return DUPLEX;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return CLOSED;
        }
    }
    ,
    REQUEST_ACTIVE_NKA{

        boolean isActive() {
            return true;
        }

        SocketLinkState toComet() {
            return COMET_NKA;
        }

        SocketLinkState toDuplex(TcpSocketLink conn) {
            return DUPLEX;
        }
    }
    ,
    REQUEST_KEEPALIVE{

        boolean isKeepalive() {
            return true;
        }

        boolean isKeepaliveAllocated() {
            return true;
        }

        SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
            return REQUEST_ACTIVE_KA;
        }

        SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return REQUEST_ACTIVE_KA;
        }

        SocketLinkState toKeepaliveSelect() {
            return REQUEST_KEEPALIVE_SELECT;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return CLOSED;
        }
    }
    ,
    REQUEST_KEEPALIVE_SELECT{

        boolean isKeepalive() {
            return true;
        }

        boolean isKeepaliveAllocated() {
            return true;
        }

        SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
            return REQUEST_ACTIVE_KA;
        }

        SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return REQUEST_ACTIVE_NKA;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return CLOSED;
        }
    }
    ,
    COMET_KA{

        boolean isComet() {
            return true;
        }

        boolean isCometActive() {
            return true;
        }

        boolean isKeepaliveAllocated() {
            return true;
        }

        SocketLinkState toCometSuspend() {
            return COMET_SUSPEND_KA;
        }

        SocketLinkState toCometDispatch() {
            return REQUEST_ACTIVE_KA;
        }

        SocketLinkState toCometComplete() {
            return COMET_COMPLETE_KA;
        }

        SocketLinkState toKillKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return COMET_NKA;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return CLOSED;
        }
    }
    ,
    COMET_NKA{

        boolean isComet() {
            return true;
        }

        boolean isCometActive() {
            return true;
        }

        SocketLinkState toCometDispatch() {
            return REQUEST_ACTIVE_NKA;
        }

        SocketLinkState toCometSuspend() {
            return COMET_SUSPEND_NKA;
        }

        SocketLinkState toCometComplete() {
            return COMET_COMPLETE_NKA;
        }
    }
    ,
    COMET_SUSPEND_KA{

        boolean isComet() {
            return true;
        }

        boolean isCometSuspend() {
            return true;
        }

        boolean isKeepaliveAllocated() {
            return true;
        }

        SocketLinkState toKillKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return COMET_SUSPEND_NKA;
        }

        SocketLinkState toCometResume() {
            return COMET_KA;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            throw new IllegalStateException();
        }

        SocketLinkState toDestroy(TcpSocketLink conn) {
            throw new IllegalStateException();
        }
    }
    ,
    COMET_SUSPEND_NKA{

        boolean isComet() {
            return true;
        }

        boolean isCometSuspend() {
            return true;
        }

        SocketLinkState toCometResume() {
            return COMET_NKA;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            throw new IllegalStateException();
        }

        SocketLinkState toDestroy(TcpSocketLink conn) {
            throw new IllegalStateException();
        }
    }
    ,
    COMET_COMPLETE_KA{

        boolean isComet() {
            return true;
        }

        boolean isCometComplete() {
            return true;
        }

        boolean isKeepaliveAllocated() {
            return true;
        }

        SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
            return REQUEST_ACTIVE_KA;
        }

        SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return REQUEST_ACTIVE_NKA;
        }

        SocketLinkState toKillKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return COMET_COMPLETE_NKA;
        }

        SocketLinkState toCometComplete() {
            return this;
        }

        SocketLinkState toKeepalive(TcpSocketLink conn) {
            return REQUEST_KEEPALIVE;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return CLOSED;
        }
    }
    ,
    COMET_COMPLETE_NKA{

        boolean isComet() {
            return true;
        }

        boolean isCometComplete() {
            return true;
        }

        SocketLinkState toCometComplete() {
            return this;
        }
    }
    ,
    DUPLEX{

        boolean isDuplex() {
            return true;
        }

        SocketLinkState toKeepalive(TcpSocketLink conn) {
            conn.getPort().duplexKeepaliveBegin();
            return DUPLEX_KEEPALIVE;
        }

        SocketLinkState toDuplexActive(TcpSocketLink conn) {
            return DUPLEX;
        }
    }
    ,
    DUPLEX_KEEPALIVE{

        boolean isDuplex() {
            return true;
        }

        boolean isKeepalive() {
            return true;
        }

        SocketLinkState toDuplexActive(TcpSocketLink conn) {
            conn.getPort().duplexKeepaliveEnd();
            return DUPLEX;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().duplexKeepaliveEnd();
            return CLOSED;
        }
    }
    ,
    CLOSED{

        boolean isClosed() {
            return true;
        }

        boolean isAllowIdle() {
            return true;
        }

        SocketLinkState toAccept() {
            return ACCEPT;
        }

        SocketLinkState toIdle() {
            return IDLE;
        }
    }
    ,
    IDLE{

        boolean isIdle() {
            return true;
        }

        SocketLinkState toInit() {
            return INIT;
        }

        SocketLinkState toDestroy(TcpSocketLink conn) {
            throw new IllegalStateException((Object)((Object)this) + " is an illegal destroy state");
        }
    }
    ,
    DESTROYED{

        boolean isClosed() {
            return true;
        }

        boolean isDestroyed() {
            return true;
        }

        SocketLinkState toIdle() {
            return this;
        }

        SocketLinkState toClosed(TcpSocketLink conn) {
            return this;
        }

        SocketLinkState toDestroy(TcpSocketLink conn) {
            return this;
        }
    };


    boolean isIdle() {
        return false;
    }

    boolean isComet() {
        return false;
    }

    boolean isCometActive() {
        return false;
    }

    boolean isCometSuspend() {
        return false;
    }

    boolean isCometComplete() {
        return false;
    }

    boolean isDuplex() {
        return false;
    }

    boolean isKeepaliveAllocated() {
        return false;
    }

    boolean isKeepalive() {
        return false;
    }

    boolean isActive() {
        return false;
    }

    boolean isRequestActive() {
        return false;
    }

    boolean isClosed() {
        return false;
    }

    boolean isDestroyed() {
        return false;
    }

    boolean isAllowIdle() {
        return false;
    }

    SocketLinkState toInit() {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to init");
    }

    SocketLinkState toAccept() {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to accept");
    }

    SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to active");
    }

    SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to active");
    }

    SocketLinkState toKillKeepalive(TcpSocketLink conn) {
        return this;
    }

    SocketLinkState toKeepalive(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to keepalive");
    }

    SocketLinkState toKeepaliveSelect() {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to keepalive select");
    }

    SocketLinkState toComet() {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to comet");
    }

    SocketLinkState toCometSuspend() {
        throw new IllegalStateException((Object)((Object)this) + " cannot suspend comet");
    }

    SocketLinkState toCometResume() {
        throw new IllegalStateException((Object)((Object)this) + " cannot resume comet");
    }

    SocketLinkState toCometDispatch() {
        throw new IllegalStateException((Object)((Object)this) + " cannot dispatch comet");
    }

    SocketLinkState toCometComplete() {
        throw new IllegalStateException((Object)((Object)this) + " cannot complete comet");
    }

    SocketLinkState toDuplex(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to duplex/websocket");
    }

    SocketLinkState toDuplexActive(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to duplex/websocket");
    }

    SocketLinkState toIdle() {
        throw new IllegalStateException((Object)((Object)this) + " is an illegal idle state");
    }

    SocketLinkState toClosed(TcpSocketLink conn) {
        return CLOSED;
    }

    SocketLinkState toDestroy(TcpSocketLink conn) {
        this.toClosed(conn);
        conn.getPort().destroy(conn);
        return DESTROYED;
    }
}

