/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.network.listen.AbstractSocketLink;
import com.caucho.network.listen.AsyncController;
import com.caucho.network.listen.CometHandler;
import com.caucho.network.listen.SocketLinkDuplexController;
import com.caucho.network.listen.SocketLinkDuplexListener;
import com.caucho.vfs.VfsStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;

public class StreamSocketLink
extends AbstractSocketLink {
    private int _id = 1;
    private InetAddress _localAddress;
    private int _localPort;
    private String _virtualHost;
    private InetAddress _remoteAddress;
    private int _remotePort;
    private boolean _isSecure;
    private boolean _isKeepalive = true;

    public StreamSocketLink() {
    }

    public StreamSocketLink(InputStream is, OutputStream os) {
        this.setStream(is, os);
    }

    public int getId() {
        return this._id;
    }

    public InetAddress getLocalAddress() {
        return this._localAddress;
    }

    public int getLocalPort() {
        return this._localPort;
    }

    public boolean isPortActive() {
        return true;
    }

    public InetAddress getRemoteAddress() {
        return this._remoteAddress;
    }

    public int getRemotePort() {
        return this._remotePort;
    }

    public void setRemotePort(int port) {
        this._remotePort = port;
    }

    public String getVirtualHost() {
        return this._virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this._virtualHost = virtualHost;
    }

    public void setStream(InputStream is, OutputStream os) {
        VfsStream _vfsStream = new VfsStream(is, os);
        this.getWriteStream().init(_vfsStream);
        this.getReadStream().init(_vfsStream, this.getWriteStream());
    }

    public void setSecure(boolean isSecure) {
        this._isSecure = isSecure;
    }

    public boolean isSecure() {
        return this._isSecure;
    }

    public boolean isKeepaliveAllocated() {
        return this._isKeepalive;
    }

    public void killKeepalive() {
        this._isKeepalive = false;
    }

    public void setLocalAddress(InetAddress addr) {
        this._localAddress = addr;
    }

    public void setLocalPort(int port) {
        this._localPort = port;
    }

    public void setRemoteAddress(InetAddress addr) {
        this._remoteAddress = addr;
    }

    public AsyncController toComet(CometHandler handler) {
        StreamAsyncController asyncController = new StreamAsyncController(handler);
        return asyncController;
    }

    public SocketLinkDuplexController startDuplex(SocketLinkDuplexListener handler) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    class StreamAsyncController
    extends AsyncController {
        StreamAsyncController(CometHandler handler) {
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[]";
        }
    }
}

