/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.inject.Module;
import com.caucho.network.listen.AsyncController;
import com.caucho.network.listen.CometHandler;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.util.Alarm;

@Module
public class TcpCometController
extends AsyncController {
    private TcpSocketLink _conn;
    private CometHandler _cometHandler;
    private boolean _isTimeout;

    TcpCometController(TcpSocketLink conn, CometHandler cometHandler) {
        this._conn = conn;
        this._cometHandler = cometHandler;
    }

    public TcpSocketLink getConnection() {
        return this._conn;
    }

    public void setMaxIdleTime(long idleTime) {
        if (idleTime < 0L || 0x3FFFFFFFFFFFFFFFL < idleTime) {
            idleTime = 0x3FFFFFFFFFFFFFFFL;
        }
        this._conn.setIdleTimeout(idleTime);
    }

    public long getMaxIdleTime() {
        return this._conn.getIdleTimeout();
    }

    public final void complete() {
        TcpSocketLink conn = this._conn;
        if (conn != null) {
            conn.toCometComplete();
        }
        this.wake();
    }

    public final boolean wake() {
        TcpSocketLink conn = this._conn;
        if (conn != null) {
            return conn.wake();
        }
        return false;
    }

    public boolean isDuplex() {
        return false;
    }

    public final void timeout() {
        this._cometHandler.onTimeout();
        this._conn.toCometComplete();
        this.wake();
    }

    public final boolean isTimeout() {
        return this._isTimeout;
    }

    public final boolean isActive() {
        return this._conn != null;
    }

    public boolean isComet() {
        TcpSocketLink conn = this._conn;
        return conn != null && !conn.isCometComplete();
    }

    public final boolean isClosed() {
        TcpSocketLink conn = this._conn;
        return conn == null || conn.isCometComplete();
    }

    public void closeImpl() {
        TcpSocketLink conn = this._conn;
        this._conn = null;
        if (conn != null) {
            conn.closeController(this);
        }
    }

    public String toString() {
        TcpSocketLink conn = this._conn;
        if (conn == null) {
            return this.getClass().getSimpleName() + "[closed]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        if (Alarm.isTest()) {
            sb.append("test");
        } else {
            sb.append(conn.getId());
        }
        TcpSocketLink tcpConn = null;
        if (this._conn instanceof TcpSocketLink) {
            tcpConn = this._conn;
        }
        if (tcpConn != null && tcpConn.isCometComplete()) {
            sb.append(",complete");
        }
        if (tcpConn != null && tcpConn.isCometSuspend()) {
            sb.append(",suspended");
        }
        if (tcpConn != null && tcpConn.isWakeRequested()) {
            sb.append(",wake");
        }
        sb.append("]");
        return sb.toString();
    }
}

