/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.inject.Module;
import com.caucho.network.listen.AsyncController;
import com.caucho.network.listen.TcpDuplexHandler;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.util.Alarm;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
public class TcpDuplexController
extends AsyncController {
    private static final L10N L = new L10N(TcpDuplexController.class);
    private static final Logger log = Logger.getLogger(TcpDuplexController.class.getName());
    private ClassLoader _loader;
    private TcpSocketLink _conn;
    private ReadStream _is;
    private WriteStream _os;
    private TcpDuplexHandler _handler;
    private String _readThreadName;

    public TcpDuplexController(TcpSocketLink conn, TcpDuplexHandler handler) {
        if (handler == null) {
            throw new NullPointerException(L.l("handler is a required argument"));
        }
        this._conn = conn;
        this._handler = handler;
        this._loader = Thread.currentThread().getContextClassLoader();
        this._is = this._conn.getReadStream();
        this._os = this._conn.getWriteStream();
        this._readThreadName = "resin-" + this._handler.getClass().getSimpleName() + "-read-" + conn.getId();
    }

    public boolean isDuplex() {
        return true;
    }

    public void setIdleTimeMax(long idleTime) {
        TcpSocketLink conn;
        if (idleTime < 0L || 0x3FFFFFFFFFFFFFFFL < idleTime) {
            idleTime = 0x3FFFFFFFFFFFFFFFL;
        }
        if ((conn = this._conn) != null) {
            conn.setIdleTimeout(idleTime);
        }
    }

    public long getIdleTimeMax() {
        TcpSocketLink conn = this._conn;
        if (conn != null) {
            return conn.getIdleTimeout();
        }
        return -1L;
    }

    public ReadStream getReadStream() {
        return this._is;
    }

    public WriteStream getWriteStream() {
        return this._os;
    }

    public TcpDuplexHandler getHandler() {
        return this._handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean serviceRead() {
        TcpDuplexHandler handler;
        String oldName;
        boolean isValid;
        Thread thread;
        block12: {
            ReadStream is;
            block11: {
                thread = Thread.currentThread();
                isValid = false;
                oldName = thread.getName();
                thread.setName(this._readThreadName);
                thread.setContextClassLoader(this._loader);
                TcpSocketLink conn = this._conn;
                is = this._is;
                handler = this._handler;
                if (conn != null && is != null && handler != null) break block11;
                boolean bl = false;
                Object var9_11 = null;
                thread.setName(oldName);
                if (!isValid) {
                    this.close();
                }
                return bl;
            }
            if (is.getAvailable() <= 0) break block12;
            isValid = true;
            handler.onRead(this);
            boolean bl = true;
            Object var9_12 = null;
            thread.setName(oldName);
            if (!isValid) {
                this.close();
            }
            return bl;
        }
        try {
            handler.onComplete(this);
            boolean bl = false;
            Object var9_13 = null;
            thread.setName(oldName);
            if (!isValid) {
                this.close();
            }
            return bl;
        }
        catch (Exception e) {
            try {
                log.log(Level.FINE, e.toString(), e);
                Object var9_14 = null;
                thread.setName(oldName);
                if (!isValid) {
                    this.close();
                }
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                thread.setName(oldName);
                if (!isValid) {
                    this.close();
                }
                throw throwable;
            }
        }
        return true;
    }

    public void complete() {
        this.close();
    }

    public void close() {
        this.closeImpl();
    }

    public void closeImpl() {
        ReadStream is = this._is;
        this._is = null;
        TcpSocketLink conn = this._conn;
        this._conn = null;
        this._os = null;
        this._handler = null;
        this._loader = null;
        IoUtil.close(is);
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.closeImpl();
    }

    public String toString() {
        TcpSocketLink conn = this._conn;
        if (conn == null) {
            return this.getClass().getSimpleName() + "[" + this._handler + ",closed]";
        }
        if (Alarm.isTest()) {
            return this.getClass().getSimpleName() + "[" + this._handler + "]";
        }
        return this.getClass().getSimpleName() + "[" + conn.getId() + "," + this._handler + "]";
    }
}

