/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.shutdown.ShutdownService;
import com.caucho.inject.Module;
import com.caucho.inject.RequestContext;
import com.caucho.loader.Environment;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.TcpConnectionMXBean;
import com.caucho.network.listen.AbstractSocketLink;
import com.caucho.network.listen.AsyncController;
import com.caucho.network.listen.CometHandler;
import com.caucho.network.listen.Protocol;
import com.caucho.network.listen.ProtocolConnection;
import com.caucho.network.listen.SocketLinkDuplexController;
import com.caucho.network.listen.SocketLinkDuplexListener;
import com.caucho.network.listen.SocketLinkListener;
import com.caucho.network.listen.SocketLinkState;
import com.caucho.network.listen.TcpCometController;
import com.caucho.util.Alarm;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
public class TcpSocketLink
extends AbstractSocketLink {
    private static final Logger log = Logger.getLogger(TcpSocketLink.class.getName());
    private static final ThreadLocal<ProtocolConnection> _currentRequest = new ThreadLocal();
    private static ClassLoader _systemClassLoader = ClassLoader.getSystemClassLoader();
    private final int _connectionId;
    private final String _id;
    private final String _name;
    private String _dbgId;
    private final SocketLinkListener _port;
    private final QSocket _socket;
    private final ProtocolConnection _request;
    private final ClassLoader _loader;
    private final byte[] _testBuffer = new byte[1];
    private final AcceptTask _acceptTask = new AcceptTask();
    private final KeepaliveRequestTask _keepaliveTask = new KeepaliveRequestTask();
    private final ResumeTask _resumeTask = new ResumeTask();
    private DuplexReadTask _duplexReadTask;
    private final Admin _admin = new Admin();
    private SocketLinkState _state = SocketLinkState.INIT;
    private AsyncController _controller;
    private boolean _isWakeRequested;
    private boolean _isCompleteRequested;
    private long _idleTimeout;
    private long _connectionStartTime;
    private long _requestStartTime;
    private long _idleStartTime;
    private long _idleExpireTime;
    private String _displayState;
    private Thread _thread;

    TcpSocketLink(int connId, SocketLinkListener port, QSocket socket) {
        this._connectionId = connId;
        this._port = port;
        this._socket = socket;
        int id = this.getId();
        this._loader = port.getClassLoader();
        Protocol protocol = port.getProtocol();
        this._request = protocol.createConnection(this);
        this._name = this._id = port.getDebugId() + "-" + id;
    }

    public static ProtocolConnection getCurrentRequest() {
        return _currentRequest.get();
    }

    public static void qaSetCurrentRequest(ProtocolConnection request) {
        _currentRequest.set(request);
    }

    public int getId() {
        return this._connectionId;
    }

    public String getName() {
        return this._name;
    }

    public SocketLinkListener getPort() {
        return this._port;
    }

    public final ProtocolConnection getRequest() {
        return this._request;
    }

    public TcpConnectionMXBean getAdmin() {
        return this._admin;
    }

    public void setIdleTimeout(long idleTimeout) {
        this._idleTimeout = idleTimeout;
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    public boolean isPortActive() {
        return this._port.isActive();
    }

    public SocketLinkState getState() {
        return this._state;
    }

    public final boolean isIdle() {
        return this._state.isIdle();
    }

    public boolean isActive() {
        return this._state.isActive();
    }

    public boolean isRequestActive() {
        return this._state.isRequestActive();
    }

    public boolean isKeepaliveAllocated() {
        return this._state.isKeepaliveAllocated();
    }

    public boolean isClosed() {
        return this._state.isClosed();
    }

    public final boolean isDestroyed() {
        return this._state.isDestroyed();
    }

    public void requestShutdownBegin() {
        this._port.requestShutdownBegin();
    }

    public void requestShutdownEnd() {
        this._port.requestShutdownEnd();
    }

    public boolean isCometActive() {
        return this._state.isCometActive() && !this._isCompleteRequested;
    }

    public boolean isCometSuspend() {
        return this._state.isCometSuspend();
    }

    public boolean isCometComplete() {
        return this._state.isCometComplete();
    }

    public boolean isDuplex() {
        return this._state.isDuplex();
    }

    public boolean isWakeRequested() {
        return this._isWakeRequested;
    }

    public QSocket getSocket() {
        return this._socket;
    }

    public InetAddress getLocalAddress() {
        return this._socket.getLocalAddress();
    }

    public String getLocalHost() {
        return this._socket.getLocalHost();
    }

    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        return this._socket.getRemoteAddress();
    }

    public String getRemoteHost() {
        return this._socket.getRemoteHost();
    }

    public int getRemoteAddress(byte[] buffer, int offset, int length) {
        return this._socket.getRemoteAddress(buffer, offset, length);
    }

    public int getRemotePort() {
        return this._socket.getRemotePort();
    }

    public boolean isSecure() {
        return this._socket.isSecure() || this._port.isSecure();
    }

    public String getVirtualHost() {
        return this.getPort().getVirtualHost();
    }

    public String getCipherSuite() {
        return this._socket.getCipherSuite();
    }

    public int getKeySize() {
        return this._socket.getCipherBits();
    }

    public X509Certificate[] getClientCertificates() throws CertificateException {
        return this._socket.getClientCertificates();
    }

    public final long getThreadId() {
        Thread thread = this._thread;
        if (thread != null) {
            return thread.getId();
        }
        return -1L;
    }

    public final long getRequestStartTime() {
        return this._requestStartTime;
    }

    public long getIdleExpireTime() {
        return this._idleExpireTime;
    }

    public long getIdleStartTime() {
        return this._idleStartTime;
    }

    public Runnable getAcceptTask() {
        return this._acceptTask;
    }

    public Runnable getKeepaliveTask() {
        if (this._state.isDuplex()) {
            return this._duplexReadTask;
        }
        return this._keepaliveTask;
    }

    public Runnable getResumeTask() {
        return this._resumeTask;
    }

    public String getDisplayState() {
        return this._displayState;
    }

    public void setStatState(String state) {
        this._displayState = state;
    }

    public AsyncController getAsyncController() {
        return this._controller;
    }

    public boolean isReadEof() {
        QSocket socket = this._socket;
        if (socket == null) {
            return true;
        }
        try {
            StreamImpl s = socket.getStream();
            int len = s.read(this._testBuffer, 0, 0);
            return len < 0;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RequestState handleRequests(boolean isKeepalive) throws IOException {
        RequestState result;
        block15: {
            Thread thread = Thread.currentThread();
            result = null;
            try {
                try {
                    Thread.interrupted();
                    result = this.handleRequestsImpl(isKeepalive);
                }
                catch (ClientDisconnectException e) {
                    this._port.addLifetimeClientDisconnectCount();
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(this.dbgId() + e);
                    }
                    Object var6_5 = null;
                    thread.setContextClassLoader(this._loader);
                    if (result == null) {
                        this.destroy();
                        return RequestState.EXIT;
                    }
                    break block15;
                }
                catch (InterruptedIOException e) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, this.dbgId() + e, e);
                    }
                    Object var6_6 = null;
                    thread.setContextClassLoader(this._loader);
                    if (result == null) {
                        this.destroy();
                        return RequestState.EXIT;
                    }
                    break block15;
                }
                catch (IOException e) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, this.dbgId() + e, e);
                    }
                    Object var6_7 = null;
                    thread.setContextClassLoader(this._loader);
                    if (result == null) {
                        this.destroy();
                        return RequestState.EXIT;
                    }
                }
                Object var6_4 = null;
                thread.setContextClassLoader(this._loader);
                if (result == null) {
                    this.destroy();
                    return RequestState.EXIT;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                thread.setContextClassLoader(this._loader);
                if (result == null) {
                    this.destroy();
                    return RequestState.EXIT;
                }
                throw throwable;
            }
        }
        if (result == RequestState.DUPLEX) {
            return this._duplexReadTask.doTask();
        }
        return result;
    }

    private RequestState handleRequestsImpl(boolean isKeepalive) throws IOException {
        RequestState result = null;
        do {
            result = RequestState.REQUEST;
            if (this._port.isClosed()) {
                return RequestState.EXIT;
            }
            if (isKeepalive && (result = this.processKeepalive()) != RequestState.REQUEST) {
                return result;
            }
            this.dispatchRequest();
            if (this._state == SocketLinkState.DUPLEX) {
                return RequestState.DUPLEX;
            }
            this.getWriteStream().flush();
            if (this._state.isCometActive() && this.toSuspend()) {
                return RequestState.THREAD_DETACHED;
            }
            isKeepalive = true;
        } while (this._state.isKeepaliveAllocated());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchRequest() throws IOException {
        Thread thread = Thread.currentThread();
        try {
            thread.setContextClassLoader(this._loader);
            _currentRequest.set(this._request);
            RequestContext.begin();
            this._isWakeRequested = false;
            this._state = this._port.isKeepaliveAllowed(this._connectionStartTime) ? this._state.toActiveWithKeepalive(this) : this._state.toActiveNoKeepalive(this);
            if (!this.getRequest().handleRequest()) {
                this._state = this._state.toKillKeepalive(this);
            }
            Object var3_2 = null;
            thread.setContextClassLoader(this._loader);
            _currentRequest.set(null);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            thread.setContextClassLoader(this._loader);
            _currentRequest.set(null);
            RequestContext.end();
            throw throwable;
        }
        RequestContext.end();
    }

    private RequestState processKeepalive() throws IOException {
        SocketLinkListener port = this._port;
        int available = port.keepaliveThreadRead(this.getReadStream());
        if (available > 0) {
            return RequestState.REQUEST;
        }
        if (available < 0) {
            this.setStatState(null);
            this.close();
            return RequestState.EXIT;
        }
        this._idleStartTime = Alarm.getCurrentTime();
        this._idleExpireTime = this._idleStartTime + this._idleTimeout;
        this._state = this._state.toKeepalive(this);
        if (this._port.getSelectManager() != null) {
            if (this._port.getSelectManager().keepalive(this)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.dbgId() + " keepalive (select)");
                }
                return RequestState.THREAD_DETACHED;
            }
            log.warning(this.dbgId() + " failed keepalive (select)");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + " keepalive (thread)");
        }
        if (this.getReadStream().waitForRead()) {
            return RequestState.REQUEST;
        }
        this.close();
        return RequestState.EXIT;
    }

    public void clearKeepalive() {
    }

    public void finishRequest() {
        AsyncController controller = this._controller;
        this._controller = null;
        if (controller != null) {
            controller.closeImpl();
        }
    }

    public void killKeepalive() {
        this._state = this._state.toKillKeepalive(this);
    }

    public void closeOnShutdown() {
        QSocket socket = this._socket;
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    public AsyncController toComet(CometHandler cometHandler) {
        if (this._isCompleteRequested) {
            throw new IllegalStateException("Comet cannot be requested after complete().");
        }
        this._state = this._state.toComet();
        this._controller = new TcpCometController(this, cometHandler);
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " starting comet");
        }
        return this._controller;
    }

    private boolean toSuspend() {
        this._idleStartTime = Alarm.getCurrentTime();
        this._idleExpireTime = this._idleStartTime + this._idleTimeout;
        this._state = this._state.toCometSuspend();
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " suspending comet");
        }
        this._port.cometSuspend(this);
        if (this._isCompleteRequested) {
            this.wake();
        }
        return true;
    }

    void toCometResume() {
        this._state = this._state.toCometResume();
    }

    public boolean wake() {
        if (!this._state.isComet()) {
            return false;
        }
        this._isWakeRequested = true;
        if (this._state.isCometSuspend() && this.getPort().cometResume(this)) {
            log.fine(this.dbgId() + " wake");
            return true;
        }
        return false;
    }

    void toCometTimeout() {
        this._isCompleteRequested = true;
        AsyncController async = this.getAsyncController();
        if (async != null) {
            async.timeout();
        }
        this.wake();
    }

    public void toCometComplete() {
        this._isCompleteRequested = true;
        SocketLinkState state = this._state;
        if (state.isCometSuspend()) {
            this.wake();
        }
    }

    public SocketLinkDuplexController startDuplex(SocketLinkDuplexListener handler) {
        this._state = this._state.toDuplex(this);
        SocketLinkDuplexController duplex = new SocketLinkDuplexController(this, handler);
        this._controller = duplex;
        this._duplexReadTask = new DuplexReadTask(duplex);
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " starting duplex " + handler);
        }
        try {
            handler.onStart(duplex);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return duplex;
    }

    public void closeController(TcpCometController controller) {
        if (controller == this._controller) {
            this._controller = null;
            this.closeControllerImpl();
        }
    }

    protected void closeControllerImpl() {
        this._isCompleteRequested = true;
        this.getPort().cometResume(this);
    }

    public void close() {
        this.closeImpl();
    }

    private void closeImpl() {
        SocketLinkState state = this._state;
        this._state = this._state.toClosed(this);
        if (state.isClosed() || state.isIdle()) {
            return;
        }
        QSocket socket = this._socket;
        if (state.isComet() || state.isCometSuspend()) {
            this.getPort().cometDetach(this);
        }
        this.getRequest().onCloseConnection();
        AsyncController controller = this._controller;
        this._controller = null;
        if (controller != null) {
            controller.closeImpl();
        }
        this._duplexReadTask = null;
        SocketLinkListener port = this.getPort();
        if (log.isLoggable(Level.FINER)) {
            if (port != null) {
                log.finer(this.dbgId() + "closing connection " + this + ", total=" + port.getConnectionCount());
            } else {
                log.finer(this.dbgId() + "closing connection " + this);
            }
        }
        try {
            this.getWriteStream().close();
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        try {
            this.getReadStream().close();
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        if (socket != null) {
            this.getPort().closeSocket(socket);
            try {
                socket.close();
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    public final void toInit() {
        this._state = this._state.toInit();
    }

    public final void destroy() {
        this._socket.forceShutdown();
        this.closeImpl();
        this._state = this._state.toDestroy(this);
    }

    void finishThread() {
        this.closeImpl();
        SocketLinkState state = this._state;
        this._state = state.toIdle();
        this._isCompleteRequested = false;
        if (state.isAllowIdle()) {
            this._port.free(this);
        }
    }

    protected String dbgId() {
        if (this._dbgId == null) {
            Object serverId = Environment.getAttribute("caucho.server-id");
            this._dbgId = serverId != null ? this.getClass().getSimpleName() + "[id=" + this.getId() + "," + serverId + "] " : this.getClass().getSimpleName() + "[id=" + this.getId() + "] ";
        }
        return this._dbgId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this._id + "," + this._port.toURL() + "," + (Object)((Object)this._state) + "]";
    }

    class Admin
    extends AbstractManagedObject
    implements TcpConnectionMXBean {
        Admin() {
            super(_systemClassLoader);
        }

        public String getName() {
            return TcpSocketLink.this._name;
        }

        public long getThreadId() {
            return TcpSocketLink.this.getThreadId();
        }

        public long getRequestActiveTime() {
            if (TcpSocketLink.this._requestStartTime > 0L) {
                return Alarm.getCurrentTime() - TcpSocketLink.this._requestStartTime;
            }
            return -1L;
        }

        public String getUrl() {
            ProtocolConnection request = TcpSocketLink.this.getRequest();
            String url = request.getProtocolRequestURL();
            if (url != null && !"".equals(url)) {
                return url;
            }
            SocketLinkListener port = TcpSocketLink.this.getPort();
            if (port.getAddress() == null) {
                return "request://*:" + port.getPort();
            }
            return "request://" + port.getAddress() + ":" + port.getPort();
        }

        public String getState() {
            return TcpSocketLink.this.getState().toString();
        }

        public String getDisplayState() {
            return TcpSocketLink.this.getDisplayState();
        }

        public String getRemoteAddress() {
            return TcpSocketLink.this.getRemoteHost();
        }

        void register() {
            this.registerSelf();
        }

        void unregister() {
            this.unregisterSelf();
        }
    }

    class ResumeTask
    implements Runnable {
        ResumeTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block14: {
                boolean isValid = false;
                try {
                    block13: {
                        try {
                            TcpSocketLink.this._isWakeRequested = false;
                            TcpSocketLink.this._state = TcpSocketLink.this._state.toCometDispatch();
                            AsyncController controller = TcpSocketLink.this._controller;
                            TcpSocketLink.this._controller = null;
                            if (controller != null) {
                                controller.close();
                            }
                            TcpSocketLink.this.getRequest().handleResume();
                            if (TcpSocketLink.this._state.isCometActive() && TcpSocketLink.this.toSuspend()) {
                                isValid = true;
                                break block13;
                            }
                            if (!TcpSocketLink.this._state.isKeepaliveAllocated()) break block13;
                            isValid = true;
                            TcpSocketLink.this._isCompleteRequested = false;
                            TcpSocketLink.this._keepaliveTask.run();
                        }
                        catch (IOException e) {
                            log.log(Level.FINE, e.toString(), e);
                            Object var5_7 = null;
                            if (!isValid) {
                                TcpSocketLink.this.finishThread();
                            }
                            break block14;
                        }
                        catch (OutOfMemoryError e) {
                            String msg = "TcpSocketLink OutOfMemory";
                            ShutdownService.shutdownActive(ExitCode.MEMORY, msg);
                            Object var5_8 = null;
                            if (!isValid) {
                                TcpSocketLink.this.finishThread();
                            }
                            break block14;
                        }
                        catch (Throwable e) {
                            log.log(Level.WARNING, e.toString(), e);
                            Object var5_9 = null;
                            if (!isValid) {
                                TcpSocketLink.this.finishThread();
                            }
                        }
                    }
                    Object var5_6 = null;
                    if (!isValid) {
                        TcpSocketLink.this.finishThread();
                    }
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    if (!isValid) {
                        TcpSocketLink.this.finishThread();
                    }
                    throw throwable;
                }
            }
        }
    }

    class DuplexReadTask
    extends ConnectionReadTask {
        private final SocketLinkDuplexController _duplex;

        DuplexReadTask(SocketLinkDuplexController duplex) {
            this._duplex = duplex;
        }

        public void run() {
            this.runThread();
        }

        public RequestState doTask() throws IOException {
            RequestState result;
            TcpSocketLink.this._state = TcpSocketLink.this._state.toDuplexActive(TcpSocketLink.this);
            ReadStream readStream = TcpSocketLink.this.getReadStream();
            while ((result = TcpSocketLink.this.processKeepalive()) == RequestState.REQUEST) {
                long position = readStream.getPosition();
                this._duplex.serviceRead();
                if (position != readStream.getPosition()) continue;
                log.warning(this._duplex + " was not processing any data. Shutting down.");
                TcpSocketLink.this.setStatState(null);
                TcpSocketLink.this.close();
                return RequestState.EXIT;
            }
            return result;
        }
    }

    class KeepaliveRequestTask
    extends ConnectionReadTask {
        KeepaliveRequestTask() {
        }

        public void run() {
            this.runThread();
        }

        public RequestState doTask() throws IOException {
            boolean isKeepalive = true;
            RequestState result = TcpSocketLink.this.handleRequests(isKeepalive);
            if (result == RequestState.THREAD_DETACHED) {
                return result;
            }
            if (result == RequestState.DUPLEX) {
                return TcpSocketLink.this._duplexReadTask.doTask();
            }
            TcpSocketLink.this.close();
            return TcpSocketLink.this._acceptTask.doTask();
        }
    }

    class AcceptTask
    extends ConnectionReadTask {
        AcceptTask() {
        }

        public void run() {
            SocketLinkListener port = TcpSocketLink.this._port;
            port.startConnection(TcpSocketLink.this);
            this.runThread();
        }

        RequestState doTask() throws IOException {
            RequestState result = RequestState.EXIT;
            while (!TcpSocketLink.this._port.isClosed() && !TcpSocketLink.this._state.isDestroyed()) {
                TcpSocketLink.this._state = TcpSocketLink.this._state.toAccept();
                TcpSocketLink.this.setStatState("accept");
                if (!TcpSocketLink.this._port.accept(TcpSocketLink.this._socket)) {
                    TcpSocketLink.this.setStatState(null);
                    TcpSocketLink.this.close();
                    return RequestState.EXIT;
                }
                TcpSocketLink.this._connectionStartTime = Alarm.getCurrentTime();
                TcpSocketLink.this.setStatState("read");
                this.initSocket();
                TcpSocketLink.this._request.onStartConnection();
                boolean isKeepalive = false;
                result = TcpSocketLink.this.handleRequests(isKeepalive);
                if (result == RequestState.THREAD_DETACHED) {
                    return result;
                }
                if (result == RequestState.DUPLEX) {
                    TcpSocketLink.this.setStatState("duplex");
                    return TcpSocketLink.this._duplexReadTask.doTask();
                }
                TcpSocketLink.this.setStatState(null);
                TcpSocketLink.this.close();
            }
            return RequestState.EXIT;
        }

        private void initSocket() throws IOException {
            TcpSocketLink.this._idleTimeout = TcpSocketLink.this._port.getKeepaliveTimeout();
            TcpSocketLink.this.getWriteStream().init(TcpSocketLink.this._socket.getStream());
            TcpSocketLink.this.getReadStream().init(TcpSocketLink.this._socket.getStream(), null);
            if (log.isLoggable(Level.FINE)) {
                log.fine(TcpSocketLink.this.dbgId() + "starting connection " + TcpSocketLink.this + ", total=" + TcpSocketLink.this._port.getConnectionCount());
            }
        }
    }

    abstract class ConnectionReadTask
    implements Runnable {
        ConnectionReadTask() {
        }

        abstract RequestState doTask() throws IOException;

        public void run() {
            this.runThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runThread() {
            block13: {
                Thread thread = Thread.currentThread();
                String oldThreadName = thread.getName();
                thread.setName(TcpSocketLink.this._id);
                TcpSocketLink.this._thread = thread;
                ClassLoader systemLoader = _systemClassLoader;
                thread.setContextClassLoader(systemLoader);
                RequestState result = null;
                TcpSocketLink.this._port.threadBegin(TcpSocketLink.this);
                try {
                    try {
                        result = this.doTask();
                    }
                    catch (OutOfMemoryError e) {
                        String msg = "TcpSocketLink OutOfMemory";
                        ShutdownService.shutdownActive(ExitCode.MEMORY, msg);
                        Object var8_6 = null;
                        thread.setName(oldThreadName);
                        TcpSocketLink.this._port.threadEnd(TcpSocketLink.this);
                        if (result == null) {
                            TcpSocketLink.this.destroy();
                        }
                        if (result != RequestState.THREAD_DETACHED) {
                            TcpSocketLink.this.finishThread();
                        }
                        break block13;
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                        Object var8_7 = null;
                        thread.setName(oldThreadName);
                        TcpSocketLink.this._port.threadEnd(TcpSocketLink.this);
                        if (result == null) {
                            TcpSocketLink.this.destroy();
                        }
                        if (result != RequestState.THREAD_DETACHED) {
                            TcpSocketLink.this.finishThread();
                        }
                    }
                    Object var8_5 = null;
                    thread.setName(oldThreadName);
                    TcpSocketLink.this._port.threadEnd(TcpSocketLink.this);
                    if (result == null) {
                        TcpSocketLink.this.destroy();
                    }
                    if (result != RequestState.THREAD_DETACHED) {
                        TcpSocketLink.this.finishThread();
                    }
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    thread.setName(oldThreadName);
                    TcpSocketLink.this._port.threadEnd(TcpSocketLink.this);
                    if (result == null) {
                        TcpSocketLink.this.destroy();
                    }
                    if (result != RequestState.THREAD_DETACHED) {
                        TcpSocketLink.this.finishThread();
                    }
                    throw throwable;
                }
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + TcpSocketLink.this + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RequestState {
        REQUEST,
        THREAD_DETACHED,
        DUPLEX,
        EXIT;

    }
}

