/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus;

import com.caucho.VersionFactory;
import com.caucho.distcache.AbstractCache;
import com.caucho.distcache.CacheManager;
import com.caucho.env.distcache.DistCacheService;
import com.caucho.java.WorkDir;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.module.ResinModuleContext;
import com.caucho.server.cluster.Server;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.WebApp;
import com.caucho.sql.DBPool;
import com.caucho.sql.DatabaseManager;
import com.caucho.sql.ManagedConnectionImpl;
import com.caucho.sql.UserConnection;
import com.caucho.sql.UserStatement;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.util.WeakAlarm;
import com.caucho.vfs.Vfs;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class ResinQuercus
extends QuercusContext {
    private static L10N L = new L10N(ResinQuercus.class);
    private static final Logger log = Logger.getLogger(ResinQuercus.class.getName());
    private static EnvironmentLocal<ModuleContext> _localModuleContext = new EnvironmentLocal();
    private AbstractCache _sessionCache;
    private WebApp _webApp;
    private long _dependencyCheckInterval = 2000L;

    public ResinQuercus() {
        this.setPwd(Vfs.lookup());
        this.setWorkDir(WorkDir.getLocalWorkDir());
        EnvironmentClassLoader loader = Environment.getEnvironmentClassLoader();
        if (loader != null) {
            this._dependencyCheckInterval = loader.getDependencyCheckInterval();
        }
    }

    public void setWebApp(WebApp webApp) {
        this._webApp = webApp;
    }

    public WebApp getWebApp() {
        return this._webApp;
    }

    public long getCurrentTime() {
        return Alarm.getCurrentTime();
    }

    public long getExactTimeNanoseconds() {
        return Alarm.getExactTimeNanoseconds();
    }

    public long getExactTime() {
        return Alarm.getExactTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleContext getLocalContext(ClassLoader loader) {
        EnvironmentLocal<ModuleContext> environmentLocal = _localModuleContext;
        synchronized (environmentLocal) {
            ModuleContext context = _localModuleContext.getLevel(loader);
            if (context == null) {
                EnvironmentClassLoader envLoader = Environment.getEnvironmentClassLoader(loader);
                ModuleContext parent = null;
                if (envLoader != null) {
                    parent = this.getLocalContext(envLoader.getParent());
                }
                context = this.createModuleContext(parent, loader);
                _localModuleContext.set(context, loader);
                context.init();
            }
            return context;
        }
    }

    protected ModuleContext createModuleContext(ModuleContext parent, ClassLoader loader) {
        return new ResinModuleContext(parent, loader);
    }

    public String getCookieName() {
        SessionManager sm = this.getSessionManager();
        if (sm != null) {
            return sm.getCookieName();
        }
        return "JSESSIONID";
    }

    public Map getSessionCache() {
        if (this._sessionCache == null && Server.getCurrent() != null) {
            CacheManager cacheManager = DistCacheService.getCurrent().getCacheManager();
            AbstractCache cache = cacheManager.create("resin:quercus:session");
            cache.setIdleTimeoutMillis(3600000L);
            this._sessionCache = cache;
        }
        return this._sessionCache;
    }

    public void setSessionTimeout(long sessionTimeout) {
        if (this._sessionCache == null) {
            this.getSessionCache();
        }
        this._sessionCache.setIdleTimeoutMillis(sessionTimeout);
    }

    public SessionManager getSessionManager() {
        if (this._webApp != null) {
            return this._webApp.getSessionManager();
        }
        return null;
    }

    public long getDependencyCheckInterval() {
        return this._dependencyCheckInterval;
    }

    public String getVersion() {
        return VersionFactory.getVersion();
    }

    public String getVersionDate() {
        return VersionFactory.getVersionDate();
    }

    public DataSource findDatabase(String driver, String url) {
        try {
            if (this.getDatabase() != null) {
                return this.getDatabase();
            }
            if (this.isConnectionPool()) {
                return DatabaseManager.findDatabase(url, driver);
            }
            return super.findDatabase(driver, url);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QuercusModuleException(e);
        }
    }

    public Connection getConnection(Connection conn) {
        try {
            return ((UserConnection)conn).getConnection();
        }
        catch (Exception e) {
            throw new QuercusModuleException(e);
        }
    }

    public void markForPoolRemoval(Connection conn) {
        ManagedConnectionImpl mConn = ((UserConnection)conn).getMConn();
        String url = mConn.getURL();
        String driver = mConn.getDriverClass().getCanonicalName();
        DataSource ds = this.findDatabase(driver, url);
        ((DBPool)ds).markForPoolRemoval(mConn);
    }

    public Statement getStatement(Statement stmt) {
        return ((UserStatement)stmt).getStatement();
    }

    public boolean isResin() {
        return true;
    }

    public void start() {
        new Alarm(this.getQuercusSessionManager()).queue(60000L);
        new WeakAlarm(new EnvTimeoutAlarmListener()).queue(this._envTimeout);
    }

    class EnvTimeoutAlarmListener
    implements AlarmListener {
        EnvTimeoutAlarmListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleAlarm(Alarm alarm) {
            try {
                ArrayList activeEnv = new ArrayList(ResinQuercus.this._activeEnvSet.keySet());
                for (Env env : activeEnv) {
                    env.updateTimeout();
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (!ResinQuercus.this.isClosed()) {
                    alarm.queue(ResinQuercus.this._envTimeout);
                }
                throw throwable;
            }
            if (!ResinQuercus.this.isClosed()) {
                alarm.queue(ResinQuercus.this._envTimeout);
            }
        }
    }
}

