/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaOverloadMethod;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.util.L10N;

public abstract class AbstractJavaMethod
extends AbstractFunction {
    private static final L10N L = new L10N(AbstractJavaMethod.class);
    private static final Object[] NULL_ARGS = new Object[0];
    private static final Value[] NULL_VALUES = new Value[0];

    public abstract int getMinArgLength();

    public abstract int getMaxArgLength();

    public abstract boolean getHasRestArgs();

    public abstract int getMarshalingCost(Value[] var1);

    public abstract int getMarshalingCost(Expr[] var1);

    public Class getJavaDeclaringClass() {
        return null;
    }

    public Class[] getJavaParameterTypes() {
        return null;
    }

    public AbstractJavaMethod overload(AbstractJavaMethod fun) {
        if (this.isSameMethod(this, fun)) {
            if (this.getJavaDeclaringClass().isAssignableFrom(fun.getJavaDeclaringClass())) {
                return fun;
            }
            return this;
        }
        AbstractJavaMethod method = new JavaOverloadMethod(this);
        method = ((AbstractJavaMethod)method).overload(fun);
        return method;
    }

    private boolean isSameMethod(AbstractJavaMethod funA, AbstractJavaMethod funB) {
        Class[] paramTypesA = funA.getJavaParameterTypes();
        Class[] paramTypesB = funB.getJavaParameterTypes();
        if (paramTypesA == null || paramTypesB == null) {
            return false;
        }
        if (paramTypesA.length != paramTypesB.length) {
            return false;
        }
        for (int i = 0; i < paramTypesA.length; ++i) {
            if (paramTypesA[i].equals(paramTypesB[i])) continue;
            return false;
        }
        return true;
    }

    public abstract Value callMethod(Env var1, QuercusClass var2, Value var3, Value[] var4);

    public Value callCopy(Env env, Value[] args) {
        return this.call(env, args);
    }

    public Value call(Env env, Value[] args) {
        return this.callMethod(env, this.getQuercusClass(), (Value)null, args);
    }

    public Value call(Env env) {
        return this.callMethod(env, this.getQuercusClass(), (Value)null, new Value[0]);
    }

    public Value call(Env env, Value a1) {
        return this.callMethod(env, this.getQuercusClass(), (Value)null, new Value[]{a1});
    }

    public Value call(Env env, Value a1, Value a2) {
        return this.callMethod(env, this.getQuercusClass(), (Value)null, new Value[]{a1, a2});
    }

    public Value call(Env env, Value a1, Value a2, Value a3) {
        return this.callMethod(env, this.getQuercusClass(), (Value)null, new Value[]{a1, a2, a3});
    }

    public Value call(Env env, Value a1, Value a2, Value a3, Value a4) {
        return this.callMethod(env, this.getQuercusClass(), (Value)null, new Value[]{a1, a2, a3, a4});
    }

    public Value call(Env env, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.callMethod(env, this.getQuercusClass(), (Value)null, new Value[]{a1, a2, a3, a4, a5});
    }

    public Value callMethod(Env env, QuercusClass qClass, Value qThis) {
        return this.callMethod(env, qClass, qThis, new Value[0]);
    }

    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value a1) {
        return this.callMethod(env, qClass, qThis, new Value[]{a1});
    }

    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2) {
        return this.callMethod(env, qClass, qThis, new Value[]{a1, a2});
    }

    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2, Value a3) {
        return this.callMethod(env, qClass, qThis, new Value[]{a1, a2, a3});
    }

    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2, Value a3, Value a4) {
        return this.callMethod(env, qClass, qThis, new Value[]{a1, a2, a3, a4});
    }

    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.callMethod(env, qClass, qThis, new Value[]{a1, a2, a3, a4, a5});
    }
}

