/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Post;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.string.StringModule;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.vfs.WriteStream;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CgiEnv
extends Env {
    public CgiEnv(QuercusContext quercus, QuercusPage page, WriteStream out, HttpServletRequest request, HttpServletResponse response) {
        super(quercus, page, out, request, response);
    }

    public CgiEnv(QuercusContext quercus) {
        this(quercus, null, null, null, null);
    }

    protected String getQueryString() {
        Value serverEnv = this.getGlobalValue("_SERVER");
        return serverEnv.get(this.createString("QUERY_STRING")).toString();
    }

    protected String getContentType() {
        Value serverEnv = this.getGlobalValue("_SERVER");
        return serverEnv.get(this.createString("CONTENT_TYPE")).toString();
    }

    protected ArrayValue getCookies() {
        ArrayValueImpl array = new ArrayValueImpl();
        boolean isMagicQuotes = this.getIniBoolean("magic_quotes_gpc");
        Value serverEnv = this.getGlobalValue("_SERVER");
        String cookies = serverEnv.get(this.createString("HTTP_COOKIE")).toString();
        int i = 0;
        int j = 0;
        int len = cookies.length();
        while ((j = cookies.indexOf(59, i)) >= 0) {
            if (j == i) {
                i = j + 1;
                continue;
            }
            this.addCookie(array, cookies, i, j, isMagicQuotes);
            i = j + 1;
        }
        if (i < len) {
            this.addCookie(array, cookies, i, len, isMagicQuotes);
        }
        return array;
    }

    private void addCookie(ArrayValue array, String cookies, int start, int end, boolean isMagicQuotes) {
        int eqIndex = cookies.indexOf(61, start);
        String name = "";
        String value = "";
        if (eqIndex < end) {
            name = cookies.substring(start, eqIndex);
            StringValue nameV = this.cleanCookieName(name);
            if (array.get(nameV) != UnsetValue.UNSET) {
                return;
            }
            value = cookies.substring(eqIndex + 1, end);
            value = CgiEnv.decodeValue(value);
            StringValue valueV = this.createString(value);
            if (isMagicQuotes) {
                valueV = StringModule.addslashes(valueV);
            }
            array.append(nameV, valueV);
        } else {
            name = cookies.substring(start, end);
            StringValue nameV = this.cleanCookieName(name);
            if (nameV.length() > 0 && nameV.charAt(0) == '$') {
                array.append(nameV, this.getEmptyString());
            }
        }
    }

    private StringValue cleanCookieName(CharSequence name) {
        int len = name.length();
        StringValue sb = this.createStringBuilder();
        int i = 0;
        while (i < len) {
            char ch = name.charAt(i);
            if (ch == ' ') {
                ++i;
                continue;
            }
            if (ch == '+') {
                ++i;
                continue;
            }
            if (i + 2 >= len || ch != '%' || name.charAt(i + 1) != '2' || name.charAt(i + 2) != '0') break;
            i += 3;
        }
        int spaces = 0;
        while (i < len) {
            char ch = name.charAt(i);
            switch (ch) {
                case '%': {
                    if (i + 2 < len && name.charAt(i + 1) == '2' && name.charAt(i + 2) == '0') {
                        ++spaces;
                        i += 2;
                        break;
                    }
                    while (spaces > 0) {
                        sb.append('_');
                        --spaces;
                    }
                    sb.append(ch);
                    break;
                }
                case ' ': 
                case '+': 
                case '.': {
                    ++spaces;
                    break;
                }
                default: {
                    while (spaces > 0) {
                        sb.append('_');
                        --spaces;
                    }
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb;
    }

    protected void fillPost(ArrayValue postArray, ArrayValue files, HttpServletRequest request, boolean isMagicQuotes) {
        InputStream is = System.in;
        Value serverEnv = this.getGlobalValue("_SERVER");
        String method = serverEnv.get(this.createString("REQUEST_METHOD")).toString();
        String contentType = serverEnv.get(this.createString("CONTENT_TYPE")).toString();
        int contentLength = Integer.MAX_VALUE;
        Value contentLengthV = serverEnv.get(this.createString("CONTENT_LENGTH"));
        if (contentLengthV.isset()) {
            contentLength = contentLengthV.toInt();
        }
        if (method.equals("POST")) {
            Post.fillPost(this, postArray, files, is, contentType, null, contentLength, isMagicQuotes, this.getIniBoolean("file_uploads"));
        } else if (!method.equals("GET")) {
            StringValue bb = this.createBinaryBuilder();
            this.setInputData(bb);
        }
    }
}

